/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.solo.service;

import javax.inject.Inject;
import org.b3log.latke.Keys;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.repository.Transaction;
import org.b3log.latke.service.ServiceException;
import org.b3log.latke.service.annotation.Service;
import org.b3log.solo.repository.LinkRepository;
import org.json.JSONObject;

@Service
public class LinkMgmtService {
    private static final Logger LOGGER = Logger.getLogger((String)LinkMgmtService.class.getName());
    @Inject
    private LinkRepository linkRepository;

    public void removeLink(String linkId) throws ServiceException {
        Transaction transaction = this.linkRepository.beginTransaction();
        try {
            this.linkRepository.remove(linkId);
            transaction.commit();
        }
        catch (Exception e) {
            if (transaction.isActive()) {
                transaction.rollback();
            }
            LOGGER.log(Level.ERROR, "Removes a link[id=" + linkId + "] failed", (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
    }

    public void updateLink(JSONObject requestJSONObject) throws ServiceException {
        Transaction transaction = this.linkRepository.beginTransaction();
        try {
            JSONObject link = requestJSONObject.getJSONObject("link");
            String linkId = link.getString(Keys.OBJECT_ID);
            JSONObject oldLink = this.linkRepository.get(linkId);
            link.put("linkOrder", oldLink.getInt("linkOrder"));
            this.linkRepository.update(linkId, link);
            transaction.commit();
        }
        catch (Exception e) {
            if (transaction.isActive()) {
                transaction.rollback();
            }
            LOGGER.log(Level.ERROR, e.getMessage(), (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
    }

    public void changeOrder(String linkId, String direction) throws ServiceException {
        Transaction transaction = this.linkRepository.beginTransaction();
        try {
            JSONObject srcLink = this.linkRepository.get(linkId);
            int srcLinkOrder = srcLink.getInt("linkOrder");
            JSONObject targetLink = null;
            targetLink = "up".equals(direction) ? this.linkRepository.getUpper(linkId) : this.linkRepository.getUnder(linkId);
            if (null == targetLink) {
                if (transaction.isActive()) {
                    transaction.rollback();
                }
                LOGGER.log(Level.WARN, "Cant not find the target link of source link[order={0}]", new Object[]{srcLinkOrder});
                return;
            }
            srcLink.put("linkOrder", targetLink.getInt("linkOrder"));
            targetLink.put("linkOrder", srcLinkOrder);
            this.linkRepository.update(srcLink.getString(Keys.OBJECT_ID), srcLink);
            this.linkRepository.update(targetLink.getString(Keys.OBJECT_ID), targetLink);
            transaction.commit();
        }
        catch (Exception e) {
            if (transaction.isActive()) {
                transaction.rollback();
            }
            LOGGER.log(Level.ERROR, "Changes link's order failed", (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
    }

    public String addLink(JSONObject requestJSONObject) throws ServiceException {
        Transaction transaction = this.linkRepository.beginTransaction();
        try {
            JSONObject link = requestJSONObject.getJSONObject("link");
            int maxOrder = this.linkRepository.getMaxOrder();
            link.put("linkOrder", maxOrder + 1);
            String ret = this.linkRepository.add(link);
            transaction.commit();
            return ret;
        }
        catch (Exception e) {
            if (transaction.isActive()) {
                transaction.rollback();
            }
            LOGGER.log(Level.ERROR, "Adds a link failed", (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
    }

    public void setLinkRepository(LinkRepository linkRepository) {
        this.linkRepository = linkRepository;
    }
}

