/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.solo.service;

import java.net.URL;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang.time.DateUtils;
import org.b3log.latke.Keys;
import org.b3log.latke.Latkes;
import org.b3log.latke.RuntimeEnv;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.plugin.PluginManager;
import org.b3log.latke.repository.RepositoryException;
import org.b3log.latke.repository.Transaction;
import org.b3log.latke.repository.jdbc.util.JdbcRepositories;
import org.b3log.latke.service.LangPropsService;
import org.b3log.latke.service.ServiceException;
import org.b3log.latke.service.annotation.Service;
import org.b3log.latke.urlfetch.HTTPRequest;
import org.b3log.latke.urlfetch.URLFetchService;
import org.b3log.latke.urlfetch.URLFetchServiceFactory;
import org.b3log.latke.util.Ids;
import org.b3log.latke.util.MD5;
import org.b3log.latke.util.freemarker.Templates;
import org.b3log.solo.SoloServletListener;
import org.b3log.solo.model.Preference;
import org.b3log.solo.repository.ArchiveDateArticleRepository;
import org.b3log.solo.repository.ArchiveDateRepository;
import org.b3log.solo.repository.ArticleRepository;
import org.b3log.solo.repository.CommentRepository;
import org.b3log.solo.repository.PreferenceRepository;
import org.b3log.solo.repository.StatisticRepository;
import org.b3log.solo.repository.TagArticleRepository;
import org.b3log.solo.repository.TagRepository;
import org.b3log.solo.repository.UserRepository;
import org.b3log.solo.util.Comments;
import org.b3log.solo.util.Skins;
import org.b3log.solo.util.Thumbnails;
import org.b3log.solo.util.TimeZones;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Service
public class InitService {
    private static final Logger LOGGER = Logger.getLogger((String)InitService.class.getName());
    @Inject
    private StatisticRepository statisticRepository;
    @Inject
    private PreferenceRepository preferenceRepository;
    @Inject
    private UserRepository userRepository;
    @Inject
    private TagArticleRepository tagArticleRepository;
    @Inject
    private ArchiveDateRepository archiveDateRepository;
    @Inject
    private ArchiveDateArticleRepository archiveDateArticleRepository;
    @Inject
    private TagRepository tagRepository;
    @Inject
    private ArticleRepository articleRepository;
    @Inject
    private CommentRepository commentRepository;
    private static final int MAX_RETRIES_CNT = 3;
    private static final String INIT_TIME_ZONE_ID = "Asia/Shanghai";
    @Inject
    private LangPropsService langPropsService;
    @Inject
    private PluginManager pluginManager;

    public boolean isInited() {
        try {
            JSONObject admin = this.userRepository.getAdmin();
            return null != admin;
        }
        catch (RepositoryException e) {
            LOGGER.log(Level.WARN, "Solo has not been initialized", new Object[0]);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(JSONObject requestJSONObject) throws ServiceException {
        Transaction transaction;
        if (this.isInited()) {
            return;
        }
        RuntimeEnv runtimeEnv = Latkes.getRuntimeEnv();
        if (RuntimeEnv.LOCAL == runtimeEnv) {
            LOGGER.log(Level.INFO, "Solo is running on [" + runtimeEnv + "] environment, database [{0}], creates all tables", new Object[]{Latkes.getRuntimeDatabase()});
            List createTableResults = JdbcRepositories.initAllTables();
            for (JdbcRepositories.CreateTableResult createTableResult : createTableResults) {
                LOGGER.log(Level.INFO, "Create table result[tableName={0}, isSuccess={1}]", new Object[]{createTableResult.getName(), createTableResult.isSuccess()});
            }
        }
        int retries = 3;
        while (true) {
            transaction = this.userRepository.beginTransaction();
            try {
                JSONObject statistic = this.statisticRepository.get("statistic");
                if (null == statistic) {
                    this.initStatistic();
                    this.initPreference(requestJSONObject);
                    this.initReplyNotificationTemplate();
                    this.initAdmin(requestJSONObject);
                }
                transaction.commit();
            }
            catch (Exception e) {
                if (0 == retries) {
                    LOGGER.log(Level.ERROR, "Initialize Solo error", (Throwable)e);
                    throw new ServiceException("Initailize Solo error: " + e.getMessage());
                }
                LOGGER.log(Level.WARN, "Retrying to init Solo[retries={0}]", new Object[]{--retries});
                continue;
            }
            finally {
                if (!transaction.isActive()) continue;
                transaction.rollback();
                continue;
            }
            break;
        }
        transaction = this.userRepository.beginTransaction();
        try {
            this.helloWorld();
            transaction.commit();
        }
        catch (Exception e) {
            if (transaction.isActive()) {
                transaction.rollback();
            }
            LOGGER.log(Level.ERROR, "Hello World error?!", (Throwable)e);
        }
        try {
            URLFetchService urlFetchService = URLFetchServiceFactory.getURLFetchService();
            HTTPRequest req = new HTTPRequest();
            req.setURL(new URL(Latkes.getServePath() + "/blog/symphony/user"));
            urlFetchService.fetch(req);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARN, "Sync account failed", new Object[0]);
        }
        this.pluginManager.load();
    }

    private void helloWorld() throws Exception {
        JSONObject article = new JSONObject();
        article.put("articleTitle", (Object)this.langPropsService.get("helloWorld.title"));
        String content = this.langPropsService.get("helloWorld.content");
        article.put("articleAbstract", (Object)content);
        article.put("articleContent", (Object)content);
        article.put("articleTags", (Object)"B3log,Solo");
        article.put("articlePermalink", (Object)"/hello-solo");
        article.put("articleIsPublished", true);
        article.put("articleHadBeenPublished", true);
        article.put("articleSignId", (Object)"1");
        article.put("articleCommentCount", 1);
        article.put("articleViewCount", 0);
        Date date = new Date();
        article.put("articleCreateDate", (Object)date);
        article.put("articleUpdateDate", (Object)date);
        article.put("articlePutTop", false);
        article.put("articleRandomDouble", Math.random());
        article.put("articleAuthorEmail", (Object)this.preferenceRepository.get("preference").optString("adminEmail"));
        article.put("articleCommentable", true);
        article.put("articleViewPwd", (Object)"");
        article.put("articleEditorType", (Object)"tinyMCE");
        String articleId = this.addHelloWorldArticle(article);
        JSONObject comment = new JSONObject();
        comment.put(Keys.OBJECT_ID, (Object)articleId);
        comment.put("commentName", (Object)"88250");
        comment.put("commentEmail", (Object)"dl88250@gmail.com");
        comment.put("commentURL", (Object)"http://88250.b3log.org");
        comment.put("commentContent", (Object)StringEscapeUtils.escapeHtml((String)this.langPropsService.get("helloWorld.comment.content")));
        comment.put("commentOriginalCommentId", (Object)"");
        comment.put("commentOriginalCommentName", (Object)"");
        comment.put("commentThumbnailURL", (Object)(Thumbnails.GRAVATAR + "59a5e8209c780307dbe9c9ba728073f5??s=60&r=G"));
        comment.put("commentDate", (Object)date);
        comment.put("commentOnId", (Object)articleId);
        comment.put("commentOnType", (Object)"article");
        String commentId = Ids.genTimeMillisId();
        comment.put(Keys.OBJECT_ID, (Object)commentId);
        String commentSharpURL = Comments.getCommentSharpURLForArticle(article, commentId);
        comment.put("commentSharpURL", (Object)commentSharpURL);
        this.commentRepository.add(comment);
        LOGGER.info("Hello World!");
    }

    private String addHelloWorldArticle(JSONObject article) throws RepositoryException {
        String ret = Ids.genTimeMillisId();
        try {
            article.put(Keys.OBJECT_ID, (Object)ret);
            String tagsString = article.optString("articleTags");
            String[] tagTitles = tagsString.split(",");
            JSONArray tags = this.tag(tagTitles, article);
            this.addTagArticleRelation(tags, article);
            JSONObject statistic = this.statisticRepository.get("statistic");
            statistic.put("statisticBlogArticleCount", 1);
            statistic.put("statisticPublishedBlogArticleCount", 1);
            statistic.put("statisticPublishedBlogCommentCount", 1);
            statistic.put("statisticBlogCommentCount", 1);
            this.statisticRepository.update("statistic", statistic);
            this.archiveDate(article);
            this.articleRepository.add(article);
            JSONObject admin = this.userRepository.getAdmin();
            admin.put("userArticleCount", 1);
            admin.put("userPublishedArticleCount", 1);
            this.userRepository.update(admin.optString(Keys.OBJECT_ID), admin);
        }
        catch (RepositoryException e) {
            LOGGER.log(Level.ERROR, "Adds an article failed", (Throwable)e);
            throw new RepositoryException((Throwable)e);
        }
        return ret;
    }

    public void archiveDate(JSONObject article) throws RepositoryException {
        Date createDate = (Date)article.opt("articleCreateDate");
        String createDateString = DateFormatUtils.format((Date)createDate, (String)"yyyy/MM");
        JSONObject archiveDate = new JSONObject();
        try {
            archiveDate.put("archiveTime", DateUtils.parseDate((String)createDateString, (String[])new String[]{"yyyy/MM"}).getTime());
            archiveDate.put("archiveDateArticleCount", 1);
            archiveDate.put("archiveDatePublishedArticleCount", 1);
            this.archiveDateRepository.add(archiveDate);
        }
        catch (ParseException e) {
            LOGGER.log(Level.ERROR, e.getMessage(), (Throwable)e);
            throw new RepositoryException((Throwable)e);
        }
        JSONObject archiveDateArticleRelation = new JSONObject();
        archiveDateArticleRelation.put("archiveDate_" + Keys.OBJECT_ID, (Object)archiveDate.optString(Keys.OBJECT_ID));
        archiveDateArticleRelation.put("article_" + Keys.OBJECT_ID, (Object)article.optString(Keys.OBJECT_ID));
        this.archiveDateArticleRepository.add(archiveDateArticleRelation);
    }

    private void addTagArticleRelation(JSONArray tags, JSONObject article) throws RepositoryException {
        for (int i = 0; i < tags.length(); ++i) {
            JSONObject tag = tags.optJSONObject(i);
            JSONObject tagArticleRelation = new JSONObject();
            tagArticleRelation.put("tag_" + Keys.OBJECT_ID, (Object)tag.optString(Keys.OBJECT_ID));
            tagArticleRelation.put("article_" + Keys.OBJECT_ID, (Object)article.optString(Keys.OBJECT_ID));
            this.tagArticleRepository.add(tagArticleRelation);
        }
    }

    private JSONArray tag(String[] tagTitles, JSONObject article) throws RepositoryException {
        JSONArray ret = new JSONArray();
        for (int i = 0; i < tagTitles.length; ++i) {
            String tagTitle = tagTitles[i].trim();
            JSONObject tag = new JSONObject();
            LOGGER.log(Level.TRACE, "Found a new tag[title={0}] in article[title={1}]", new Object[]{tagTitle, article.optString("articleTitle")});
            tag.put("tagTitle", (Object)tagTitle);
            tag.put("tagReferenceCount", 1);
            tag.put("tagPublishedRefCount", 1);
            String tagId = this.tagRepository.add(tag);
            tag.put(Keys.OBJECT_ID, (Object)tagId);
            ret.put((Object)tag);
        }
        return ret;
    }

    private void initAdmin(JSONObject requestJSONObject) throws Exception {
        LOGGER.info("Initializing admin....");
        JSONObject admin = new JSONObject();
        admin.put("userName", (Object)requestJSONObject.getString("userName"));
        admin.put("userEmail", (Object)requestJSONObject.getString("userEmail"));
        admin.put("userURL", (Object)Latkes.getServePath());
        admin.put("userRole", (Object)"adminRole");
        admin.put("userPassword", (Object)MD5.hash((String)requestJSONObject.getString("userPassword")));
        admin.put("userArticleCount", 0);
        admin.put("userPublishedArticleCount", 0);
        this.userRepository.add(admin);
        LOGGER.info("Initialized admin");
    }

    private JSONObject initStatistic() throws RepositoryException, JSONException {
        LOGGER.info("Initializing statistic....");
        JSONObject ret = new JSONObject();
        ret.put(Keys.OBJECT_ID, (Object)"statistic");
        ret.put("statisticBlogArticleCount", 0);
        ret.put("statisticPublishedBlogArticleCount", 0);
        ret.put("statisticBlogViewCount", 0);
        ret.put("statisticBlogCommentCount", 0);
        ret.put("statisticPublishedBlogCommentCount", 0);
        this.statisticRepository.add(ret);
        LOGGER.info("Initialized statistic");
        return ret;
    }

    private void initReplyNotificationTemplate() throws Exception {
        LOGGER.info("Initializing reply notification template");
        JSONObject replyNotificationTemplate = new JSONObject(Preference.Default.DEFAULT_REPLY_NOTIFICATION_TEMPLATE);
        replyNotificationTemplate.put(Keys.OBJECT_ID, (Object)"replyNotificationTemplate");
        this.preferenceRepository.add(replyNotificationTemplate);
        LOGGER.info("Initialized reply notification template");
    }

    private JSONObject initPreference(JSONObject requestJSONObject) throws Exception {
        LOGGER.info("Initializing preference....");
        JSONObject ret = new JSONObject();
        ret.put("noticeBoard", (Object)"Open Source, Open Mind, <br/>Open Sight, Open Future!");
        ret.put("metaDescription", (Object)"An open source blog with Java. Java \u5f00\u6e90\u535a\u5ba2");
        ret.put("metaKeywords", (Object)"Java \u535a\u5ba2,GAE,b3log");
        ret.put("htmlHead", (Object)"");
        ret.put("relevantArticlesDisplayCount", 5);
        ret.put("randomArticlesDisplayCount", 5);
        ret.put("externalRelevantArticlesDisplayCount", 5);
        ret.put("mostViewArticleDisplayCount", 5);
        ret.put("articleListDisplayCount", 20);
        ret.put("articleListPaginationWindowSize", 15);
        ret.put("mostUsedTagDisplayCount", 20);
        ret.put("mostCommentArticleDisplayCount", 5);
        ret.put("recentArticleDisplayCount", 10);
        ret.put("recentCommentDisplayCount", 10);
        ret.put("blogTitle", (Object)"Solo \u793a\u4f8b");
        ret.put("blogSubtitle", (Object)"Java \u5f00\u6e90\u535a\u5ba2");
        ret.put("adminEmail", (Object)requestJSONObject.getString("userEmail"));
        ret.put("localeString", (Object)"zh_CN");
        ret.put("enableArticleUpdateHint", true);
        ret.put("signs", (Object)Preference.Default.DEFAULT_SIGNS);
        ret.put("timeZoneId", (Object)INIT_TIME_ZONE_ID);
        ret.put("allowVisitDraftViaPermalink", false);
        ret.put("commentable", true);
        ret.put("version", (Object)"1.0.0");
        ret.put("articleListStyle", (Object)"titleAndAbstract");
        ret.put("keyOfSolo", (Object)Ids.genTimeMillisId());
        ret.put("feedOutputMode", (Object)"abstract");
        ret.put("feedOutputCnt", 10);
        ret.put("editorType", (Object)"tinyMCE");
        String skinDirName = "finding";
        ret.put("skinDirName", (Object)"finding");
        String skinName = Latkes.getSkinName((String)"finding");
        ret.put("skinName", (Object)skinName);
        Set<String> skinDirNames = Skins.getSkinDirNames();
        JSONArray skinArray = new JSONArray();
        for (String dirName : skinDirNames) {
            JSONObject skin = new JSONObject();
            skinArray.put((Object)skin);
            String name = Latkes.getSkinName((String)dirName);
            skin.put("skinName", (Object)name);
            skin.put("skinDirName", (Object)dirName);
        }
        ret.put("skins", (Object)skinArray.toString());
        ServletContext servletContext = SoloServletListener.getServletContext();
        Templates.MAIN_CFG.setServletContextForTemplateLoading((Object)servletContext, "/skins/finding");
        TimeZones.setTimeZone(INIT_TIME_ZONE_ID);
        ret.put(Keys.OBJECT_ID, (Object)"preference");
        this.preferenceRepository.add(ret);
        LOGGER.info("Initialized preference");
        return ret;
    }

    public void setArchiveDateArticleRepository(ArchiveDateArticleRepository archiveDateArticleRepository) {
        this.archiveDateArticleRepository = archiveDateArticleRepository;
    }

    public void setArchiveDateRepository(ArchiveDateRepository archiveDateRepository) {
        this.archiveDateRepository = archiveDateRepository;
    }

    public void setArticleRepository(ArticleRepository articleRepository) {
        this.articleRepository = articleRepository;
    }

    public void setUserRepository(UserRepository userRepository) {
        this.userRepository = userRepository;
    }

    public void setPreferenceRepository(PreferenceRepository preferenceRepository) {
        this.preferenceRepository = preferenceRepository;
    }

    public void setStatisticRepository(StatisticRepository statisticRepository) {
        this.statisticRepository = statisticRepository;
    }

    public void setTagRepository(TagRepository tagRepository) {
        this.tagRepository = tagRepository;
    }

    public void setTagArticleRepository(TagArticleRepository tagArticleRepository) {
        this.tagArticleRepository = tagArticleRepository;
    }

    public void setCommentRepository(CommentRepository commentRepository) {
        this.commentRepository = commentRepository;
    }

    public void setLangPropsService(LangPropsService langPropsService) {
        this.langPropsService = langPropsService;
    }

    public void setPluginManager(PluginManager pluginManager) {
        this.pluginManager = pluginManager;
    }
}

