/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.solo.service;

import java.io.IOException;
import java.net.URL;
import java.util.Date;
import javax.inject.Inject;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.b3log.latke.Keys;
import org.b3log.latke.Latkes;
import org.b3log.latke.event.Event;
import org.b3log.latke.event.EventManager;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.mail.MailService;
import org.b3log.latke.mail.MailServiceFactory;
import org.b3log.latke.repository.RepositoryException;
import org.b3log.latke.repository.Transaction;
import org.b3log.latke.service.LangPropsService;
import org.b3log.latke.service.ServiceException;
import org.b3log.latke.service.annotation.Service;
import org.b3log.latke.urlfetch.HTTPRequest;
import org.b3log.latke.urlfetch.HTTPResponse;
import org.b3log.latke.urlfetch.URLFetchService;
import org.b3log.latke.urlfetch.URLFetchServiceFactory;
import org.b3log.latke.util.Ids;
import org.b3log.latke.util.Strings;
import org.b3log.solo.repository.ArticleRepository;
import org.b3log.solo.repository.CommentRepository;
import org.b3log.solo.repository.PageRepository;
import org.b3log.solo.service.ArticleMgmtService;
import org.b3log.solo.service.PreferenceQueryService;
import org.b3log.solo.service.StatisticMgmtService;
import org.b3log.solo.util.Comments;
import org.b3log.solo.util.Thumbnails;
import org.json.JSONException;
import org.json.JSONObject;

@Service
public class CommentMgmtService {
    private static final Logger LOGGER = Logger.getLogger((String)CommentMgmtService.class.getName());
    @Inject
    private ArticleMgmtService articleMgmtService;
    @Inject
    private CommentRepository commentRepository;
    @Inject
    private ArticleRepository articleRepository;
    @Inject
    private StatisticMgmtService statisticMgmtService;
    @Inject
    private PageRepository pageRepository;
    @Inject
    private PreferenceQueryService preferenceQueryService;
    @Inject
    private static EventManager eventManager;
    private static final String DEFAULT_USER_THUMBNAIL = "default-user-thumbnail.png";
    private static URLFetchService urlFetchService;
    @Inject
    private LangPropsService langPropsService;
    private static final int MIN_COMMENT_NAME_LENGTH = 2;
    private static final int MAX_COMMENT_NAME_LENGTH = 20;
    private static final int MIN_COMMENT_CONTENT_LENGTH = 2;
    private static final int MAX_COMMENT_CONTENT_LENGTH = 500;
    private MailService mailService = MailServiceFactory.getMailService();
    public static final String COMMENT_MAIL_HTML_BODY = "<p>{articleOrPage} [<a href=\"{articleOrPageURL}\">{title}</a>] received a new comment:</p>{commenter}: <span><a href=\"{commentSharpURL}\">{commentContent}</a></span>";

    public void sendNotificationMail(JSONObject articleOrPage, JSONObject comment, JSONObject originalComment, JSONObject preference) throws IOException, JSONException {
        String mailBody;
        String articleOrPageURL;
        String mailSubject;
        String originalEmail;
        String commentEmail = comment.getString("commentEmail");
        String commentId = comment.getString(Keys.OBJECT_ID);
        String commentContent = comment.getString("commentContent").replaceAll("_esc_enter_88250_", "<br/>");
        String adminEmail = preference.getString("adminEmail");
        if (adminEmail.equalsIgnoreCase(commentEmail)) {
            LOGGER.log(Level.DEBUG, "Do not send comment notification mail to admin itself[{0}]", new Object[]{adminEmail});
            return;
        }
        if (null != originalComment && comment.has("commentOriginalCommentId") && (originalEmail = originalComment.getString("commentEmail")).equalsIgnoreCase(adminEmail)) {
            LOGGER.log(Level.DEBUG, "Do not send comment notification mail to admin while the specified comment[{0}] is an reply", new Object[]{commentId});
            return;
        }
        String blogTitle = preference.getString("blogTitle");
        boolean isArticle = true;
        String title = articleOrPage.optString("articleTitle");
        if (Strings.isEmptyOrNull((String)title)) {
            title = articleOrPage.getString("pageTitle");
            isArticle = false;
        }
        String commentSharpURL = comment.getString("commentSharpURL");
        MailService.Message message = new MailService.Message();
        message.setFrom(adminEmail);
        message.addRecipient(adminEmail);
        if (isArticle) {
            mailSubject = blogTitle + ": New comment on article [" + title + "]";
            articleOrPageURL = Latkes.getServePath() + articleOrPage.getString("articlePermalink");
            mailBody = COMMENT_MAIL_HTML_BODY.replace("{articleOrPage}", "Article");
        } else {
            mailSubject = blogTitle + ": New comment on page [" + title + "]";
            articleOrPageURL = Latkes.getServePath() + articleOrPage.getString("pagePermalink");
            mailBody = COMMENT_MAIL_HTML_BODY.replace("{articleOrPage}", "Page");
        }
        message.setSubject(mailSubject);
        String commentName = comment.getString("commentName");
        String commentURL = comment.getString("commentURL");
        String commenter = !"http://".equals(commentURL) ? "<a target=\"_blank\" href=\"" + commentURL + "\">" + commentName + "</a>" : commentName;
        mailBody = mailBody.replace("{articleOrPageURL}", articleOrPageURL).replace("{title}", title).replace("{commentContent}", commentContent).replace("{commentSharpURL}", Latkes.getServePath() + commentSharpURL).replace("{commenter}", commenter);
        message.setHtmlBody(mailBody);
        LOGGER.log(Level.DEBUG, "Sending a mail[mailSubject={0}, mailBody=[{1}] to admin[email={2}]", new Object[]{mailSubject, mailBody, adminEmail});
        this.mailService.send(message);
    }

    public JSONObject checkAddCommentRequest(JSONObject requestJSONObject) {
        JSONObject ret = new JSONObject();
        try {
            String commentName;
            ret.put("sc", false);
            JSONObject preference = this.preferenceQueryService.getPreference();
            if (null == preference || !preference.optBoolean("commentable")) {
                ret.put("msg", (Object)this.langPropsService.get("notAllowCommentLabel"));
                return ret;
            }
            String id = requestJSONObject.optString(Keys.OBJECT_ID);
            String type = requestJSONObject.optString("type");
            if ("article".equals(type)) {
                JSONObject article = this.articleRepository.get(id);
                if (null == article || !article.optBoolean("articleCommentable")) {
                    ret.put("msg", (Object)this.langPropsService.get("notAllowCommentLabel"));
                    return ret;
                }
            } else {
                JSONObject page = this.pageRepository.get(id);
                if (null == page || !page.optBoolean("pageCommentable")) {
                    ret.put("msg", (Object)this.langPropsService.get("notAllowCommentLabel"));
                    return ret;
                }
            }
            if (20 < (commentName = requestJSONObject.getString("commentName")).length() || 2 > commentName.length()) {
                LOGGER.log(Level.WARN, "Comment name is too long[{0}]", new Object[]{commentName});
                ret.put("msg", (Object)this.langPropsService.get("nameTooLongLabel"));
                return ret;
            }
            String commentEmail = requestJSONObject.getString("commentEmail").trim().toLowerCase();
            if (!Strings.isEmail((String)commentEmail)) {
                LOGGER.log(Level.WARN, "Comment email is invalid[{0}]", new Object[]{commentEmail});
                ret.put("msg", (Object)this.langPropsService.get("mailInvalidLabel"));
                return ret;
            }
            String commentURL = requestJSONObject.optString("commentURL");
            if (!Strings.isURL((String)commentURL)) {
                LOGGER.log(Level.WARN, "Comment URL is invalid[{0}]", new Object[]{commentURL});
                ret.put("msg", (Object)this.langPropsService.get("urlInvalidLabel"));
                return ret;
            }
            String commentContent = requestJSONObject.optString("commentContent").replaceAll("\\n", "_esc_enter_88250_");
            if (500 < commentContent.length() || 2 > commentContent.length()) {
                LOGGER.log(Level.WARN, "Comment conent length is invalid[{0}]", new Object[]{commentContent.length()});
                ret.put("msg", (Object)this.langPropsService.get("commentContentCannotEmptyLabel"));
                return ret;
            }
            ret.put("sc", true);
            return ret;
        }
        catch (Exception e) {
            LOGGER.log(Level.WARN, "Checks add comment request[" + requestJSONObject.toString() + "] failed", (Throwable)e);
            ret.put("sc", false);
            ret.put("msg", (Object)this.langPropsService.get("addFailLabel"));
            return ret;
        }
    }

    public JSONObject addPageComment(JSONObject requestJSONObject) throws ServiceException {
        JSONObject ret = new JSONObject();
        Transaction transaction = this.commentRepository.beginTransaction();
        try {
            String pageId = requestJSONObject.getString(Keys.OBJECT_ID);
            JSONObject page = this.pageRepository.get(pageId);
            String commentName = requestJSONObject.getString("commentName");
            String commentEmail = requestJSONObject.getString("commentEmail").trim().toLowerCase();
            String commentURL = requestJSONObject.optString("commentURL");
            String commentContent = requestJSONObject.getString("commentContent").replaceAll("\\n", "_esc_enter_88250_");
            commentContent = StringEscapeUtils.escapeHtml((String)commentContent);
            String originalCommentId = requestJSONObject.optString("commentOriginalCommentId");
            JSONObject comment = new JSONObject();
            comment.put("commentOriginalCommentId", (Object)"");
            comment.put("commentOriginalCommentName", (Object)"");
            JSONObject originalComment = null;
            comment.put("commentName", (Object)commentName);
            comment.put("commentEmail", (Object)commentEmail);
            comment.put("commentURL", (Object)commentURL);
            comment.put("commentContent", (Object)commentContent);
            JSONObject preference = this.preferenceQueryService.getPreference();
            Date date = new Date();
            comment.put("commentDate", (Object)date);
            ret.put("commentDate", (Object)DateFormatUtils.format((Date)date, (String)"yyyy-MM-dd hh:mm:ss"));
            if (!Strings.isEmptyOrNull((String)originalCommentId)) {
                originalComment = this.commentRepository.get(originalCommentId);
                if (null != originalComment) {
                    comment.put("commentOriginalCommentId", (Object)originalCommentId);
                    String originalCommentName = originalComment.getString("commentName");
                    comment.put("commentOriginalCommentName", (Object)originalCommentName);
                    ret.put("commentOriginalCommentName", (Object)originalCommentName);
                } else {
                    LOGGER.log(Level.WARN, "Not found orginal comment[id={0}] of reply[name={1}, content={2}]", new Object[]{originalCommentId, commentName, commentContent});
                }
            }
            CommentMgmtService.setCommentThumbnailURL(comment);
            ret.put("commentThumbnailURL", (Object)comment.getString("commentThumbnailURL"));
            comment.put("commentOnId", (Object)pageId);
            comment.put("commentOnType", (Object)"page");
            String commentId = Ids.genTimeMillisId();
            ret.put(Keys.OBJECT_ID, (Object)commentId);
            String commentSharpURL = Comments.getCommentSharpURLForPage(page, commentId);
            ret.put("commentSharpURL", (Object)commentSharpURL);
            comment.put("commentSharpURL", (Object)commentSharpURL);
            comment.put(Keys.OBJECT_ID, (Object)commentId);
            this.commentRepository.add(comment);
            this.incPageCommentCount(pageId);
            this.statisticMgmtService.incBlogCommentCount();
            this.statisticMgmtService.incPublishedBlogCommentCount();
            try {
                this.sendNotificationMail(page, comment, originalComment, preference);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARN, "Send mail failed", (Throwable)e);
            }
            JSONObject eventData = new JSONObject();
            eventData.put("comment", (Object)comment);
            eventData.put("page", (Object)page);
            eventManager.fireEventSynchronously(new Event("Add Comment To Page", (Object)eventData));
            transaction.commit();
        }
        catch (Exception e) {
            if (transaction.isActive()) {
                transaction.rollback();
            }
            throw new ServiceException((Throwable)e);
        }
        return ret;
    }

    public JSONObject addArticleComment(JSONObject requestJSONObject) throws ServiceException {
        JSONObject ret = new JSONObject();
        Transaction transaction = this.commentRepository.beginTransaction();
        try {
            String commentContent;
            String articleId = requestJSONObject.getString(Keys.OBJECT_ID);
            JSONObject article = this.articleRepository.get(articleId);
            String commentName = requestJSONObject.getString("commentName");
            String commentEmail = requestJSONObject.getString("commentEmail").trim().toLowerCase();
            String commentURL = requestJSONObject.optString("commentURL");
            String contentNoEsc = commentContent = requestJSONObject.getString("commentContent").replaceAll("\\n", "_esc_enter_88250_");
            commentContent = StringEscapeUtils.escapeHtml((String)commentContent);
            String originalCommentId = requestJSONObject.optString("commentOriginalCommentId");
            JSONObject comment = new JSONObject();
            comment.put("commentOriginalCommentId", (Object)"");
            comment.put("commentOriginalCommentName", (Object)"");
            JSONObject originalComment = null;
            comment.put("commentName", (Object)commentName);
            comment.put("commentEmail", (Object)commentEmail);
            comment.put("commentURL", (Object)commentURL);
            comment.put("commentContent", (Object)commentContent);
            comment.put("commentOriginalCommentId", (Object)requestJSONObject.optString("commentOriginalCommentId"));
            comment.put("commentOriginalCommentName", (Object)requestJSONObject.optString("commentOriginalCommentName"));
            JSONObject preference = this.preferenceQueryService.getPreference();
            Date date = new Date();
            comment.put("commentDate", (Object)date);
            ret.put("commentDate", (Object)DateFormatUtils.format((Date)date, (String)"yyyy-MM-dd hh:mm:ss"));
            if (!Strings.isEmptyOrNull((String)originalCommentId)) {
                originalComment = this.commentRepository.get(originalCommentId);
                if (null != originalComment) {
                    comment.put("commentOriginalCommentId", (Object)originalCommentId);
                    String originalCommentName = originalComment.getString("commentName");
                    comment.put("commentOriginalCommentName", (Object)originalCommentName);
                    ret.put("commentOriginalCommentName", (Object)originalCommentName);
                } else {
                    LOGGER.log(Level.WARN, "Not found orginal comment[id={0}] of reply[name={1}, content={2}]", (Object[])new String[]{originalCommentId, commentName, commentContent});
                }
            }
            CommentMgmtService.setCommentThumbnailURL(comment);
            ret.put("commentThumbnailURL", (Object)comment.getString("commentThumbnailURL"));
            comment.put("commentOnId", (Object)articleId);
            comment.put("commentOnType", (Object)"article");
            String commentId = Ids.genTimeMillisId();
            comment.put(Keys.OBJECT_ID, (Object)commentId);
            ret.put(Keys.OBJECT_ID, (Object)commentId);
            String commentSharpURL = Comments.getCommentSharpURLForArticle(article, commentId);
            comment.put("commentSharpURL", (Object)commentSharpURL);
            ret.put("commentSharpURL", (Object)commentSharpURL);
            this.commentRepository.add(comment);
            this.articleMgmtService.incArticleCommentCount(articleId);
            this.statisticMgmtService.incBlogCommentCount();
            this.statisticMgmtService.incPublishedBlogCommentCount();
            try {
                this.sendNotificationMail(article, comment, originalComment, preference);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARN, "Send mail failed", (Throwable)e);
            }
            JSONObject eventData = new JSONObject();
            eventData.put("comment", (Object)comment);
            comment.put("commentContent", (Object)contentNoEsc);
            eventData.put("article", (Object)article);
            eventManager.fireEventSynchronously(new Event("Add Comment To Article", (Object)eventData));
            transaction.commit();
        }
        catch (Exception e) {
            if (transaction.isActive()) {
                transaction.rollback();
            }
            throw new ServiceException((Throwable)e);
        }
        return ret;
    }

    public void removePageComment(String commentId) throws ServiceException {
        Transaction transaction = this.commentRepository.beginTransaction();
        try {
            JSONObject comment = this.commentRepository.get(commentId);
            String pageId = comment.getString("commentOnId");
            this.commentRepository.remove(commentId);
            this.decPageCommentCount(pageId);
            this.statisticMgmtService.decBlogCommentCount();
            this.statisticMgmtService.decPublishedBlogCommentCount();
            transaction.commit();
        }
        catch (Exception e) {
            if (transaction.isActive()) {
                transaction.rollback();
            }
            LOGGER.log(Level.ERROR, "Removes a comment of a page failed", (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
    }

    public void removeArticleComment(String commentId) throws ServiceException {
        Transaction transaction = this.commentRepository.beginTransaction();
        try {
            JSONObject comment = this.commentRepository.get(commentId);
            String articleId = comment.getString("commentOnId");
            this.commentRepository.remove(commentId);
            this.decArticleCommentCount(articleId);
            this.statisticMgmtService.decBlogCommentCount();
            this.statisticMgmtService.decPublishedBlogCommentCount();
            transaction.commit();
        }
        catch (Exception e) {
            if (transaction.isActive()) {
                transaction.rollback();
            }
            LOGGER.log(Level.ERROR, "Removes a comment of an article failed", (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
    }

    public void incPageCommentCount(String pageId) throws JSONException, RepositoryException {
        JSONObject page = this.pageRepository.get(pageId);
        JSONObject newPage = new JSONObject(page, JSONObject.getNames((JSONObject)page));
        int commentCnt = page.getInt("pageCommentCount");
        newPage.put("pageCommentCount", commentCnt + 1);
        this.pageRepository.update(pageId, newPage);
    }

    private void decArticleCommentCount(String articleId) throws JSONException, RepositoryException {
        JSONObject article = this.articleRepository.get(articleId);
        JSONObject newArticle = new JSONObject(article, JSONObject.getNames((JSONObject)article));
        int commentCnt = article.getInt("articleCommentCount");
        newArticle.put("articleCommentCount", commentCnt - 1);
        this.articleRepository.update(articleId, newArticle);
    }

    private void decPageCommentCount(String pageId) throws JSONException, RepositoryException {
        JSONObject page = this.pageRepository.get(pageId);
        JSONObject newPage = new JSONObject(page, JSONObject.getNames((JSONObject)page));
        int commentCnt = page.getInt("pageCommentCount");
        newPage.put("pageCommentCount", commentCnt - 1);
        this.pageRepository.update(pageId, newPage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setCommentThumbnailURL(JSONObject comment) throws Exception {
        String commentEmail = comment.getString("commentEmail");
        String thumbnailURL = Thumbnails.getGravatarURL(commentEmail.toLowerCase(), "60");
        URL gravatarURL = new URL(thumbnailURL);
        int statusCode = 200;
        try {
            HTTPRequest request = new HTTPRequest();
            request.setURL(gravatarURL);
            HTTPResponse response = urlFetchService.fetch(request);
            statusCode = response.getResponseCode();
        }
        catch (IOException e) {
            LOGGER.log(Level.WARN, "Can not fetch thumbnail from Gravatar[commentEmail={0}]", new Object[]{commentEmail});
        }
        finally {
            if (200 != statusCode) {
                thumbnailURL = Latkes.getStaticServePath() + "/images/" + DEFAULT_USER_THUMBNAIL;
            }
        }
        comment.put("commentThumbnailURL", (Object)thumbnailURL);
    }

    public void setArticleRepository(ArticleRepository articleRepository) {
        this.articleRepository = articleRepository;
    }

    public void setArticleMgmtService(ArticleMgmtService articleMgmtService) {
        this.articleMgmtService = articleMgmtService;
    }

    public void setPageRepository(PageRepository pageRepository) {
        this.pageRepository = pageRepository;
    }

    public void setPreferenceQueryService(PreferenceQueryService preferenceQueryService) {
        this.preferenceQueryService = preferenceQueryService;
    }

    public void setStatisticMgmtService(StatisticMgmtService statisticMgmtService) {
        this.statisticMgmtService = statisticMgmtService;
    }

    public void setCommentRepository(CommentRepository commentRepository) {
        this.commentRepository = commentRepository;
    }

    public void setLangPropsService(LangPropsService langPropsService) {
        this.langPropsService = langPropsService;
    }

    static {
        urlFetchService = URLFetchServiceFactory.getURLFetchService();
    }
}

