/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.solo.repository.impl;

import org.b3log.latke.repository.AbstractRepository;
import org.b3log.latke.repository.Filter;
import org.b3log.latke.repository.FilterOperator;
import org.b3log.latke.repository.PropertyFilter;
import org.b3log.latke.repository.Query;
import org.b3log.latke.repository.RepositoryException;
import org.b3log.latke.repository.annotation.Repository;
import org.b3log.solo.repository.UserRepository;
import org.json.JSONArray;
import org.json.JSONObject;

@Repository
public class UserRepositoryImpl
extends AbstractRepository
implements UserRepository {
    public UserRepositoryImpl() {
        super("user");
    }

    @Override
    public JSONObject getByEmail(String email) throws RepositoryException {
        Query query = new Query().setPageCount(1);
        query.setFilter((Filter)new PropertyFilter("userEmail", FilterOperator.EQUAL, (Object)email.toLowerCase().trim()));
        JSONObject result = this.get(query);
        JSONArray array = result.optJSONArray("rslts");
        if (0 == array.length()) {
            return null;
        }
        return array.optJSONObject(0);
    }

    @Override
    public JSONObject getAdmin() throws RepositoryException {
        Query query = new Query().setFilter((Filter)new PropertyFilter("userRole", FilterOperator.EQUAL, (Object)"adminRole")).setPageCount(1);
        JSONObject result = this.get(query);
        JSONArray array = result.optJSONArray("rslts");
        if (0 == array.length()) {
            return null;
        }
        return array.optJSONObject(0);
    }

    @Override
    public boolean isAdminEmail(String email) throws RepositoryException {
        JSONObject user = this.getByEmail(email);
        if (null == user) {
            return false;
        }
        return "adminRole".equals(user.optString("userRole"));
    }
}

