/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.solo.repository.impl;

import java.util.List;
import org.b3log.latke.repository.AbstractRepository;
import org.b3log.latke.repository.Filter;
import org.b3log.latke.repository.FilterOperator;
import org.b3log.latke.repository.PropertyFilter;
import org.b3log.latke.repository.Query;
import org.b3log.latke.repository.RepositoryException;
import org.b3log.latke.repository.SortDirection;
import org.b3log.latke.repository.annotation.Repository;
import org.b3log.latke.util.CollectionUtils;
import org.b3log.solo.repository.PageRepository;
import org.json.JSONArray;
import org.json.JSONObject;

@Repository
public class PageRepositoryImpl
extends AbstractRepository
implements PageRepository {
    public PageRepositoryImpl() {
        super("page");
    }

    @Override
    public JSONObject getByPermalink(String permalink) throws RepositoryException {
        Query query = new Query().setFilter((Filter)new PropertyFilter("pagePermalink", FilterOperator.EQUAL, (Object)permalink)).setPageCount(1);
        JSONObject result = this.get(query);
        JSONArray array = result.optJSONArray("rslts");
        if (0 == array.length()) {
            return null;
        }
        return array.optJSONObject(0);
    }

    @Override
    public int getMaxOrder() throws RepositoryException {
        Query query = new Query().addSort("pageOrder", SortDirection.DESCENDING).setPageCount(1);
        JSONObject result = this.get(query);
        JSONArray array = result.optJSONArray("rslts");
        if (0 == array.length()) {
            return -1;
        }
        return array.optJSONObject(0).optInt("pageOrder");
    }

    @Override
    public JSONObject getUpper(String id) throws RepositoryException {
        JSONObject page = this.get(id);
        if (null == page) {
            return null;
        }
        Query query = new Query().setFilter((Filter)new PropertyFilter("pageOrder", FilterOperator.LESS_THAN, (Object)page.optInt("pageOrder"))).addSort("pageOrder", SortDirection.DESCENDING).setCurrentPageNum(1).setPageSize(1).setPageCount(1);
        JSONObject result = this.get(query);
        JSONArray array = result.optJSONArray("rslts");
        if (1 != array.length()) {
            return null;
        }
        return array.optJSONObject(0);
    }

    @Override
    public JSONObject getUnder(String id) throws RepositoryException {
        JSONObject page = this.get(id);
        if (null == page) {
            return null;
        }
        Query query = new Query().setFilter((Filter)new PropertyFilter("pageOrder", FilterOperator.GREATER_THAN, (Object)page.optInt("pageOrder"))).addSort("pageOrder", SortDirection.ASCENDING).setCurrentPageNum(1).setPageSize(1).setPageCount(1);
        JSONObject result = this.get(query);
        JSONArray array = result.optJSONArray("rslts");
        if (1 != array.length()) {
            return null;
        }
        return array.optJSONObject(0);
    }

    @Override
    public JSONObject getByOrder(int order) throws RepositoryException {
        Query query = new Query().setFilter((Filter)new PropertyFilter("pageOrder", FilterOperator.EQUAL, (Object)order)).setPageCount(1);
        JSONObject result = this.get(query);
        JSONArray array = result.optJSONArray("rslts");
        if (0 == array.length()) {
            return null;
        }
        return array.optJSONObject(0);
    }

    @Override
    public List<JSONObject> getPages() throws RepositoryException {
        Query query = new Query().addSort("pageOrder", SortDirection.ASCENDING).setPageCount(1);
        JSONObject result = this.get(query);
        return CollectionUtils.jsonArrayToList((JSONArray)result.optJSONArray("rslts"));
    }
}

