/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.solo.repository.impl;

import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import org.b3log.latke.Keys;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.repository.AbstractRepository;
import org.b3log.latke.repository.Filter;
import org.b3log.latke.repository.FilterOperator;
import org.b3log.latke.repository.PropertyFilter;
import org.b3log.latke.repository.Query;
import org.b3log.latke.repository.RepositoryException;
import org.b3log.latke.repository.SortDirection;
import org.b3log.latke.repository.annotation.Repository;
import org.b3log.latke.util.CollectionUtils;
import org.b3log.solo.repository.ArticleRepository;
import org.b3log.solo.repository.CommentRepository;
import org.json.JSONArray;
import org.json.JSONObject;

@Repository
public class CommentRepositoryImpl
extends AbstractRepository
implements CommentRepository {
    private static final Logger LOGGER = Logger.getLogger((String)CommentRepositoryImpl.class.getName());
    @Inject
    private ArticleRepository articleRepository;

    public CommentRepositoryImpl() {
        super("comment");
    }

    @Override
    public int removeComments(String onId) throws RepositoryException {
        List<JSONObject> comments = this.getComments(onId, 1, Integer.MAX_VALUE);
        for (JSONObject comment : comments) {
            String commentId = comment.optString(Keys.OBJECT_ID);
            this.remove(commentId);
        }
        LOGGER.log(Level.DEBUG, "Removed comments[onId={0}, removedCnt={1}]", new Object[]{onId, comments.size()});
        return comments.size();
    }

    @Override
    public List<JSONObject> getComments(String onId, int currentPageNum, int pageSize) throws RepositoryException {
        Query query = new Query().addSort(Keys.OBJECT_ID, SortDirection.DESCENDING).setFilter((Filter)new PropertyFilter("commentOnId", FilterOperator.EQUAL, (Object)onId)).setCurrentPageNum(currentPageNum).setPageSize(pageSize).setPageCount(1);
        JSONObject result = this.get(query);
        JSONArray array = result.optJSONArray("rslts");
        return CollectionUtils.jsonArrayToList((JSONArray)array);
    }

    @Override
    public List<JSONObject> getRecentComments(int num) throws RepositoryException {
        Query query = new Query().addSort(Keys.OBJECT_ID, SortDirection.DESCENDING).setCurrentPageNum(1).setPageSize(num).setPageCount(1);
        JSONObject result = this.get(query);
        JSONArray array = result.optJSONArray("rslts");
        List ret = CollectionUtils.jsonArrayToList((JSONArray)array);
        this.removeForUnpublishedArticles(ret);
        return ret;
    }

    private void removeForUnpublishedArticles(List<JSONObject> comments) throws RepositoryException {
        LOGGER.debug("Removing unpublished articles' comments....");
        Iterator<JSONObject> iterator = comments.iterator();
        while (iterator.hasNext()) {
            String articleId;
            JSONObject comment = iterator.next();
            String commentOnType = comment.optString("commentOnType");
            if (!"article".equals(commentOnType) || this.articleRepository.isPublished(articleId = comment.optString("commentOnId"))) continue;
            iterator.remove();
        }
        LOGGER.debug("Removed unpublished articles' comments....");
    }

    public void setArticleRepository(ArticleRepository articleRepository) {
        this.articleRepository = articleRepository;
    }
}

