/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.solo.repository.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.repository.AbstractRepository;
import org.b3log.latke.repository.CompositeFilterOperator;
import org.b3log.latke.repository.Filter;
import org.b3log.latke.repository.FilterOperator;
import org.b3log.latke.repository.PropertyFilter;
import org.b3log.latke.repository.Query;
import org.b3log.latke.repository.RepositoryException;
import org.b3log.latke.repository.SortDirection;
import org.b3log.latke.repository.annotation.Repository;
import org.b3log.latke.util.CollectionUtils;
import org.b3log.solo.repository.ArticleRepository;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Repository
public class ArticleRepositoryImpl
extends AbstractRepository
implements ArticleRepository {
    private static final Logger LOGGER = Logger.getLogger((String)ArticleRepositoryImpl.class.getName());
    private static final double RANDOM_RANGE = 0.1;

    public ArticleRepositoryImpl() {
        super("article");
    }

    @Override
    public JSONObject getByAuthorEmail(String authorEmail, int currentPageNum, int pageSize) throws RepositoryException {
        Query query = new Query().setFilter((Filter)CompositeFilterOperator.and((Filter[])new Filter[]{new PropertyFilter("articleAuthorEmail", FilterOperator.EQUAL, (Object)authorEmail), new PropertyFilter("articleIsPublished", FilterOperator.EQUAL, (Object)true)})).addSort("articleUpdateDate", SortDirection.DESCENDING).addSort("articlePutTop", SortDirection.DESCENDING).setCurrentPageNum(currentPageNum).setPageSize(pageSize).setPageCount(1);
        return this.get(query);
    }

    @Override
    public JSONObject getByPermalink(String permalink) throws RepositoryException {
        Query query = new Query().setFilter((Filter)new PropertyFilter("articlePermalink", FilterOperator.EQUAL, (Object)permalink)).setPageCount(1);
        JSONObject result = this.get(query);
        JSONArray array = result.optJSONArray("rslts");
        if (0 == array.length()) {
            return null;
        }
        return array.optJSONObject(0);
    }

    @Override
    public List<JSONObject> getRecentArticles(int fetchSize) throws RepositoryException {
        Query query = new Query();
        query.setFilter((Filter)new PropertyFilter("articleIsPublished", FilterOperator.EQUAL, (Object)true));
        query.addSort("articleUpdateDate", SortDirection.DESCENDING);
        query.setCurrentPageNum(1);
        query.setPageSize(fetchSize);
        query.setPageCount(1);
        JSONObject result = this.get(query);
        JSONArray array = result.optJSONArray("rslts");
        return CollectionUtils.jsonArrayToList((JSONArray)array);
    }

    @Override
    public List<JSONObject> getMostCommentArticles(int num) throws RepositoryException {
        Query query = new Query().addSort("articleCommentCount", SortDirection.DESCENDING).addSort("articleUpdateDate", SortDirection.DESCENDING).setFilter((Filter)new PropertyFilter("articleIsPublished", FilterOperator.EQUAL, (Object)true)).setCurrentPageNum(1).setPageSize(num).setPageCount(1);
        JSONObject result = this.get(query);
        JSONArray array = result.optJSONArray("rslts");
        return CollectionUtils.jsonArrayToList((JSONArray)array);
    }

    @Override
    public List<JSONObject> getMostViewCountArticles(int num) throws RepositoryException {
        Query query = new Query();
        query.addSort("articleViewCount", SortDirection.DESCENDING).addSort("articleUpdateDate", SortDirection.DESCENDING);
        query.setFilter((Filter)new PropertyFilter("articleIsPublished", FilterOperator.EQUAL, (Object)true));
        query.setCurrentPageNum(1);
        query.setPageSize(num);
        query.setPageCount(1);
        JSONObject result = this.get(query);
        JSONArray array = result.optJSONArray("rslts");
        return CollectionUtils.jsonArrayToList((JSONArray)array);
    }

    @Override
    public JSONObject getPreviousArticle(String articleId) throws RepositoryException {
        JSONObject currentArticle = this.get(articleId);
        Date currentArticleCreateDate = (Date)currentArticle.opt("articleCreateDate");
        Query query = new Query().setFilter((Filter)CompositeFilterOperator.and((Filter[])new Filter[]{new PropertyFilter("articleCreateDate", FilterOperator.LESS_THAN, (Object)currentArticleCreateDate), new PropertyFilter("articleIsPublished", FilterOperator.EQUAL, (Object)true)})).addSort("articleCreateDate", SortDirection.DESCENDING).setCurrentPageNum(1).setPageSize(1).setPageCount(1).addProjection("articleTitle", String.class).addProjection("articlePermalink", String.class).addProjection("articleAbstract", String.class);
        JSONObject result = this.get(query);
        JSONArray array = result.optJSONArray("rslts");
        if (1 != array.length()) {
            return null;
        }
        JSONObject ret = new JSONObject();
        JSONObject article = array.optJSONObject(0);
        try {
            ret.put("articleTitle", (Object)article.getString("articleTitle"));
            ret.put("articlePermalink", (Object)article.getString("articlePermalink"));
            ret.put("articleAbstract", (Object)article.getString("articleAbstract"));
        }
        catch (JSONException e) {
            throw new RepositoryException((Throwable)e);
        }
        return ret;
    }

    @Override
    public JSONObject getNextArticle(String articleId) throws RepositoryException {
        JSONObject currentArticle = this.get(articleId);
        Date currentArticleCreateDate = (Date)currentArticle.opt("articleCreateDate");
        Query query = new Query().setFilter((Filter)CompositeFilterOperator.and((Filter[])new Filter[]{new PropertyFilter("articleCreateDate", FilterOperator.GREATER_THAN, (Object)currentArticleCreateDate), new PropertyFilter("articleIsPublished", FilterOperator.EQUAL, (Object)true)})).addSort("articleCreateDate", SortDirection.ASCENDING).setCurrentPageNum(1).setPageSize(1).setPageCount(1).addProjection("articleTitle", String.class).addProjection("articlePermalink", String.class).addProjection("articleAbstract", String.class);
        JSONObject result = this.get(query);
        JSONArray array = result.optJSONArray("rslts");
        if (1 != array.length()) {
            return null;
        }
        JSONObject ret = new JSONObject();
        JSONObject article = array.optJSONObject(0);
        try {
            ret.put("articleTitle", (Object)article.getString("articleTitle"));
            ret.put("articlePermalink", (Object)article.getString("articlePermalink"));
            ret.put("articleAbstract", (Object)article.getString("articleAbstract"));
        }
        catch (JSONException e) {
            throw new RepositoryException((Throwable)e);
        }
        return ret;
    }

    @Override
    public boolean isPublished(String articleId) throws RepositoryException {
        JSONObject article = this.get(articleId);
        if (null == article) {
            return false;
        }
        return article.optBoolean("articleIsPublished");
    }

    public List<JSONObject> getRandomly(int fetchSize) throws RepositoryException {
        ArrayList<JSONObject> ret = new ArrayList<JSONObject>();
        if (0L == this.count()) {
            return ret;
        }
        double mid = Math.random() + 0.1;
        LOGGER.log(Level.TRACE, "Random mid[{0}]", new Object[]{mid});
        Query query = new Query();
        query.setFilter((Filter)CompositeFilterOperator.and((Filter[])new Filter[]{new PropertyFilter("articleRandomDouble", FilterOperator.GREATER_THAN_OR_EQUAL, (Object)mid), new PropertyFilter("articleRandomDouble", FilterOperator.LESS_THAN_OR_EQUAL, (Object)mid), new PropertyFilter("articleIsPublished", FilterOperator.EQUAL, (Object)true)}));
        query.setCurrentPageNum(1);
        query.setPageSize(fetchSize);
        query.setPageCount(1);
        JSONObject result1 = this.get(query);
        JSONArray array1 = result1.optJSONArray("rslts");
        List list1 = CollectionUtils.jsonArrayToList((JSONArray)array1);
        ret.addAll(list1);
        int reminingSize = fetchSize - array1.length();
        if (0 != reminingSize) {
            query = new Query();
            query.setFilter((Filter)CompositeFilterOperator.and((Filter[])new Filter[]{new PropertyFilter("articleRandomDouble", FilterOperator.GREATER_THAN_OR_EQUAL, (Object)0.0), new PropertyFilter("articleRandomDouble", FilterOperator.LESS_THAN_OR_EQUAL, (Object)mid), new PropertyFilter("articleIsPublished", FilterOperator.EQUAL, (Object)true)}));
            query.setCurrentPageNum(1);
            query.setPageSize(reminingSize);
            query.setPageCount(1);
            JSONObject result2 = this.get(query);
            JSONArray array2 = result2.optJSONArray("rslts");
            List list2 = CollectionUtils.jsonArrayToList((JSONArray)array2);
            ret.addAll(list2);
        }
        return ret;
    }
}

