/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.solo.processor.util;

import freemarker.template.Template;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.b3log.latke.Keys;
import org.b3log.latke.Latkes;
import org.b3log.latke.event.Event;
import org.b3log.latke.event.EventException;
import org.b3log.latke.event.EventManager;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.plugin.ViewLoadEventData;
import org.b3log.latke.repository.Filter;
import org.b3log.latke.repository.FilterOperator;
import org.b3log.latke.repository.PropertyFilter;
import org.b3log.latke.repository.Query;
import org.b3log.latke.repository.RepositoryException;
import org.b3log.latke.repository.SortDirection;
import org.b3log.latke.service.LangPropsService;
import org.b3log.latke.service.ServiceException;
import org.b3log.latke.service.annotation.Service;
import org.b3log.latke.user.UserService;
import org.b3log.latke.user.UserServiceFactory;
import org.b3log.latke.util.CollectionUtils;
import org.b3log.latke.util.Dates;
import org.b3log.latke.util.Locales;
import org.b3log.latke.util.Paginator;
import org.b3log.latke.util.Stopwatchs;
import org.b3log.latke.util.Strings;
import org.b3log.latke.util.freemarker.Templates;
import org.b3log.solo.SoloServletListener;
import org.b3log.solo.processor.util.FillTagArticles;
import org.b3log.solo.processor.util.TopBars;
import org.b3log.solo.repository.ArchiveDateRepository;
import org.b3log.solo.repository.ArticleRepository;
import org.b3log.solo.repository.CommentRepository;
import org.b3log.solo.repository.LinkRepository;
import org.b3log.solo.repository.PageRepository;
import org.b3log.solo.repository.TagRepository;
import org.b3log.solo.repository.UserRepository;
import org.b3log.solo.service.ArticleQueryService;
import org.b3log.solo.service.StatisticQueryService;
import org.b3log.solo.service.TagQueryService;
import org.b3log.solo.service.UserQueryService;
import org.b3log.solo.util.Thumbnails;
import org.b3log.solo.util.comparator.Comparators;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Service
public class Filler {
    private static final Logger LOGGER = Logger.getLogger((String)Filler.class.getName());
    @Inject
    private TopBars topBars;
    @Inject
    private ArticleRepository articleRepository;
    @Inject
    private CommentRepository commentRepository;
    @Inject
    private ArchiveDateRepository archiveDateRepository;
    @Inject
    private TagRepository tagRepository;
    @Inject
    private LinkRepository linkRepository;
    @Inject
    private PageRepository pageRepository;
    @Inject
    private StatisticQueryService statisticQueryService;
    @Inject
    private UserRepository userRepository;
    @Inject
    private ArticleQueryService articleQueryService;
    private static final boolean PUBLISHED = true;
    @Inject
    private TagQueryService tagQueryService;
    @Inject
    private UserQueryService userQueryService;
    @Inject
    private FillTagArticles fillTagArticles;
    private static UserService userService = UserServiceFactory.getUserService();
    @Inject
    private EventManager eventManager;
    @Inject
    private LangPropsService langPropsService;

    public void fillIndexArticles(HttpServletRequest request, Map<String, Object> dataModel, int currentPageNum, JSONObject preference) throws ServiceException {
        Stopwatchs.start((String)"Fill Index Articles");
        try {
            int pageSize = preference.getInt("articleListDisplayCount");
            int windowSize = preference.getInt("articleListPaginationWindowSize");
            JSONObject statistic = this.statisticQueryService.getStatistic();
            int publishedArticleCnt = statistic.getInt("statisticPublishedBlogArticleCount");
            int pageCount = (int)Math.ceil((double)publishedArticleCnt / (double)pageSize);
            Query query = new Query().setCurrentPageNum(currentPageNum).setPageSize(pageSize).setPageCount(pageCount).setFilter((Filter)new PropertyFilter("articleIsPublished", FilterOperator.EQUAL, (Object)true));
            Template template = Templates.getTemplate((String)((String)request.getAttribute("templateDirName")), (String)"index.ftl");
            boolean isArticles1 = false;
            if (null == template) {
                LOGGER.debug("The skin dose not contain [index.ftl] template");
            } else if (Templates.hasExpression((Template)template, (String)"<#list articles1 as article>")) {
                isArticles1 = true;
                query.addSort("articleCreateDate", SortDirection.DESCENDING);
                LOGGER.trace("Query ${articles1} in index.ftl");
            } else {
                query.addSort("articlePutTop", SortDirection.DESCENDING);
                if (preference.getBoolean("enableArticleUpdateHint")) {
                    query.addSort("articleUpdateDate", SortDirection.DESCENDING);
                } else {
                    query.addSort("articleCreateDate", SortDirection.DESCENDING);
                }
            }
            query.index(new String[]{"articlePermalink"});
            JSONObject result = this.articleRepository.get(query);
            List pageNums = Paginator.paginate((int)currentPageNum, (int)pageSize, (int)pageCount, (int)windowSize);
            if (0 != pageNums.size()) {
                dataModel.put("paginationFirstPageNum", pageNums.get(0));
                dataModel.put("paginationLastPageNum", pageNums.get(pageNums.size() - 1));
            }
            dataModel.put("paginationPageCount", pageCount);
            dataModel.put("paginationPageNums", pageNums);
            List articles = CollectionUtils.jsonArrayToList((JSONArray)result.getJSONArray("rslts"));
            boolean hasMultipleUsers = this.userQueryService.hasMultipleUsers();
            if (hasMultipleUsers) {
                this.setArticlesExProperties(request, articles, preference);
            } else if (!articles.isEmpty()) {
                JSONObject author = this.articleQueryService.getAuthor((JSONObject)articles.get(0));
                this.setArticlesExProperties(request, articles, author, preference);
            }
            if (!isArticles1) {
                dataModel.put("articles", articles);
            } else {
                dataModel.put("articles1", articles);
            }
        }
        catch (JSONException e) {
            LOGGER.log(Level.ERROR, "Fills index articles failed", (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
        catch (RepositoryException e) {
            LOGGER.log(Level.ERROR, "Fills index articles failed", (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
        finally {
            Stopwatchs.end();
        }
    }

    public void fillLinks(Map<String, Object> dataModel) throws ServiceException {
        Stopwatchs.start((String)"Fill Links");
        try {
            HashMap<String, SortDirection> sorts = new HashMap<String, SortDirection>();
            sorts.put("linkOrder", SortDirection.ASCENDING);
            Query query = new Query().addSort("linkOrder", SortDirection.ASCENDING).setPageCount(1);
            JSONObject linkResult = this.linkRepository.get(query);
            List links = CollectionUtils.jsonArrayToList((JSONArray)linkResult.getJSONArray("rslts"));
            dataModel.put("links", links);
        }
        catch (JSONException e) {
            LOGGER.log(Level.ERROR, "Fills links failed", (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
        catch (RepositoryException e) {
            LOGGER.log(Level.ERROR, "Fills links failed", (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
        finally {
            Stopwatchs.end();
        }
        Stopwatchs.end();
    }

    public void fillTags(Map<String, Object> dataModel) throws ServiceException {
        Stopwatchs.start((String)"Fill Tags");
        try {
            List<JSONObject> tags = this.tagQueryService.getTags();
            this.tagQueryService.removeForUnpublishedArticles(tags);
            Collections.sort(tags, Comparators.TAG_REF_CNT_COMPARATOR);
            dataModel.put("tags", tags);
        }
        catch (JSONException e) {
            LOGGER.log(Level.ERROR, "Fills tags failed", (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
        catch (RepositoryException e) {
            LOGGER.log(Level.ERROR, "Fills tagss failed", (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
        finally {
            Stopwatchs.end();
        }
        Stopwatchs.end();
    }

    public void fillMostUsedTags(Map<String, Object> dataModel, JSONObject preference) throws ServiceException {
        Stopwatchs.start((String)"Fill Most Used Tags");
        try {
            LOGGER.debug("Filling most used tags....");
            int mostUsedTagDisplayCnt = preference.getInt("mostUsedTagDisplayCount");
            List<JSONObject> tags = this.tagRepository.getMostUsedTags(mostUsedTagDisplayCnt);
            this.tagQueryService.removeForUnpublishedArticles(tags);
            dataModel.put("mostUsedTags", tags);
        }
        catch (JSONException e) {
            LOGGER.log(Level.ERROR, "Fills most used tags failed", (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
        catch (RepositoryException e) {
            LOGGER.log(Level.ERROR, "Fills most used tags failed", (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
        finally {
            Stopwatchs.end();
        }
    }

    public void fillArchiveDates(Map<String, Object> dataModel, JSONObject preference) throws ServiceException {
        Stopwatchs.start((String)"Fill Archive Dates");
        try {
            LOGGER.debug("Filling archive dates....");
            List<JSONObject> archiveDates = this.archiveDateRepository.getArchiveDates();
            ArrayList<JSONObject> archiveDates2 = new ArrayList<JSONObject>();
            dataModel.put("archiveDates", archiveDates2);
            if (archiveDates.isEmpty()) {
                return;
            }
            archiveDates2.add(archiveDates.get(0));
            if (1 < archiveDates.size()) {
                for (int i = 1; i < archiveDates.size(); ++i) {
                    JSONObject last;
                    String lastDateString;
                    JSONObject archiveDate = archiveDates.get(i);
                    long time = archiveDate.getLong("archiveTime");
                    String dateString = DateFormatUtils.format((long)time, (String)"yyyy/MM");
                    if (!dateString.equals(lastDateString = DateFormatUtils.format((long)(last = (JSONObject)archiveDates2.get(archiveDates2.size() - 1)).getLong("archiveTime"), (String)"yyyy/MM"))) {
                        archiveDates2.add(archiveDate);
                        continue;
                    }
                    LOGGER.log(Level.WARN, "Found a duplicated archive date [{0}]", new Object[]{dateString});
                }
            }
            String localeString = preference.getString("localeString");
            String language = Locales.getLanguage((String)localeString);
            for (JSONObject archiveDate : archiveDates2) {
                long time = archiveDate.getLong("archiveTime");
                String dateString = DateFormatUtils.format((long)time, (String)"yyyy/MM");
                String[] dateStrings = dateString.split("/");
                String year = dateStrings[0];
                String month = dateStrings[1];
                archiveDate.put("archiveDateYear", (Object)year);
                archiveDate.put("archiveDateMonth", (Object)month);
                if (!"en".equals(language)) continue;
                String monthName = (String)Dates.EN_MONTHS.get(month);
                archiveDate.put("monthName", (Object)monthName);
            }
            dataModel.put("archiveDates", archiveDates2);
        }
        catch (JSONException e) {
            LOGGER.log(Level.ERROR, "Fills archive dates failed", (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
        catch (RepositoryException e) {
            LOGGER.log(Level.ERROR, "Fills archive dates failed", (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
        finally {
            Stopwatchs.end();
        }
    }

    public void fillMostViewCountArticles(Map<String, Object> dataModel, JSONObject preference) throws ServiceException {
        Stopwatchs.start((String)"Fill Most View Articles");
        try {
            LOGGER.debug("Filling the most view count articles....");
            int mostCommentArticleDisplayCnt = preference.getInt("mostViewArticleDisplayCount");
            List<JSONObject> mostViewCountArticles = this.articleRepository.getMostViewCountArticles(mostCommentArticleDisplayCnt);
            dataModel.put("mostViewCountArticles", mostViewCountArticles);
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Fills most view count articles failed", (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
        finally {
            Stopwatchs.end();
        }
    }

    public void fillMostCommentArticles(Map<String, Object> dataModel, JSONObject preference) throws ServiceException {
        Stopwatchs.start((String)"Fill Most CMMTs Articles");
        try {
            LOGGER.debug("Filling most comment articles....");
            int mostCommentArticleDisplayCnt = preference.getInt("mostCommentArticleDisplayCount");
            List<JSONObject> mostCommentArticles = this.articleRepository.getMostCommentArticles(mostCommentArticleDisplayCnt);
            dataModel.put("mostCommentArticles", mostCommentArticles);
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Fills most comment articles failed", (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
        finally {
            Stopwatchs.end();
        }
    }

    public void fillRecentArticles(Map<String, Object> dataModel, JSONObject preference) throws ServiceException {
        Stopwatchs.start((String)"Fill Recent Articles");
        try {
            int recentArticleDisplayCnt = preference.getInt("recentArticleDisplayCount");
            List<JSONObject> recentArticles = this.articleRepository.getRecentArticles(recentArticleDisplayCnt);
            dataModel.put("recentArticles", recentArticles);
        }
        catch (JSONException e) {
            LOGGER.log(Level.ERROR, "Fills recent articles failed", (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
        catch (RepositoryException e) {
            LOGGER.log(Level.ERROR, "Fills recent articles failed", (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
        finally {
            Stopwatchs.end();
        }
    }

    public void fillRecentComments(Map<String, Object> dataModel, JSONObject preference) throws ServiceException {
        Stopwatchs.start((String)"Fill Recent Comments");
        try {
            LOGGER.debug("Filling recent comments....");
            int recentCommentDisplayCnt = preference.getInt("recentCommentDisplayCount");
            List<JSONObject> recentComments = this.commentRepository.getRecentComments(recentCommentDisplayCnt);
            for (JSONObject comment : recentComments) {
                String content = comment.getString("commentContent").replaceAll("_esc_enter_88250_", "&nbsp;");
                comment.put("commentContent", (Object)content);
                comment.put("commentName", (Object)StringEscapeUtils.escapeHtml((String)comment.getString("commentName")));
                comment.put("commentURL", (Object)StringEscapeUtils.escapeHtml((String)comment.getString("commentURL")));
                comment.remove("commentEmail");
            }
            dataModel.put("recentComments", recentComments);
        }
        catch (JSONException e) {
            LOGGER.log(Level.ERROR, "Fills recent comments failed", (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
        catch (RepositoryException e) {
            LOGGER.log(Level.ERROR, "Fills recent comments failed", (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
        finally {
            Stopwatchs.end();
        }
    }

    public void fillBlogFooter(HttpServletRequest request, Map<String, Object> dataModel, JSONObject preference) throws ServiceException {
        Stopwatchs.start((String)"Fill Footer");
        try {
            LOGGER.debug("Filling footer....");
            String blogTitle = preference.getString("blogTitle");
            dataModel.put("blogTitle", blogTitle);
            dataModel.put("blogHost", Latkes.getServerHost() + ":" + Latkes.getServerPort());
            dataModel.put("version", "1.0.0");
            dataModel.put("staticResourceVersion", Latkes.getStaticResourceVersion());
            dataModel.put("year", String.valueOf(Calendar.getInstance().get(1)));
            dataModel.put("staticServer", Latkes.getStaticServer());
            dataModel.put("server", Latkes.getServer());
            dataModel.put("isIndex", "/".equals(request.getRequestURI()));
            dataModel.put("userName", "");
            JSONObject currentUser = this.userQueryService.getCurrentUser(request);
            if (null != currentUser) {
                String email = currentUser.optString("userEmail");
                String gravatar = Thumbnails.getGravatarURL(email, "60");
                dataModel.put("gravatar", gravatar);
                dataModel.put("userName", currentUser.optString("userName"));
            }
            try {
                ViewLoadEventData data = new ViewLoadEventData();
                data.setViewName("footer.ftl");
                data.setDataModel(dataModel);
                this.eventManager.fireEventSynchronously(new Event("FreeMarkerAction", (Object)data));
                if (Strings.isEmptyOrNull((String)((String)dataModel.get("plugins")))) {
                    dataModel.put("plugins", "");
                }
            }
            catch (EventException e) {
                LOGGER.log(Level.WARN, "Event[FREEMARKER_ACTION] handle failed, ignores this exception for kernel health", (Throwable)e);
            }
        }
        catch (JSONException e) {
            LOGGER.log(Level.ERROR, "Fills blog footer failed", (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
        finally {
            Stopwatchs.end();
        }
    }

    public void fillBlogHeader(HttpServletRequest request, HttpServletResponse response, Map<String, Object> dataModel, JSONObject preference) throws ServiceException {
        Stopwatchs.start((String)"Fill Header");
        try {
            LOGGER.debug("Filling header....");
            String topBarHTML = this.topBars.getTopBarHTML(request, response);
            dataModel.put("loginURL", userService.createLoginURL("/admin-index.do#main"));
            dataModel.put("logoutURL", userService.createLogoutURL("/"));
            dataModel.put("onlineVisitorCnt", StatisticQueryService.getOnlineVisitorCount());
            dataModel.put("topBarReplacement", topBarHTML);
            dataModel.put("articleListDisplayCount", preference.getInt("articleListDisplayCount"));
            dataModel.put("articleListPaginationWindowSize", preference.getInt("articleListPaginationWindowSize"));
            dataModel.put("localeString", preference.getString("localeString"));
            dataModel.put("blogTitle", preference.getString("blogTitle"));
            dataModel.put("blogSubtitle", preference.getString("blogSubtitle"));
            dataModel.put("htmlHead", preference.getString("htmlHead"));
            String metaKeywords = preference.getString("metaKeywords");
            if (Strings.isEmptyOrNull((String)metaKeywords)) {
                metaKeywords = "";
            }
            dataModel.put("metaKeywords", metaKeywords);
            String metaDescription = preference.getString("metaDescription");
            if (Strings.isEmptyOrNull((String)metaDescription)) {
                metaDescription = "";
            }
            dataModel.put("metaDescription", metaDescription);
            dataModel.put("year", String.valueOf(Calendar.getInstance().get(1)));
            dataModel.put("isLoggedIn", null != this.userQueryService.getCurrentUser(request));
            dataModel.put("faviconAPI", SoloServletListener.FAVICON_API);
            String noticeBoard = preference.getString("noticeBoard");
            dataModel.put("noticeBoard", noticeBoard);
            Query query = new Query().setPageCount(1);
            JSONObject result = this.userRepository.get(query);
            JSONArray users = result.getJSONArray("rslts");
            List userList = CollectionUtils.jsonArrayToList((JSONArray)users);
            dataModel.put("users", userList);
            for (JSONObject user : userList) {
                user.remove("userEmail");
                user.remove("userPassword");
            }
            String skinDirName = (String)request.getAttribute("templateDirName");
            dataModel.put("skinDirName", skinDirName);
            Keys.fillRuntime(dataModel);
            this.fillMinified(dataModel);
            this.fillPageNavigations(dataModel);
            this.fillStatistic(dataModel);
        }
        catch (JSONException e) {
            LOGGER.log(Level.ERROR, "Fills blog header failed", (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
        catch (RepositoryException e) {
            LOGGER.log(Level.ERROR, "Fills blog header failed", (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
        finally {
            Stopwatchs.end();
        }
    }

    public void fillMinified(Map<String, Object> dataModel) {
        switch (Latkes.getRuntimeMode()) {
            case DEVELOPMENT: {
                dataModel.put("miniPostfix", "");
                break;
            }
            case PRODUCTION: {
                dataModel.put("miniPostfix", ".min");
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    public void fillSide(HttpServletRequest request, Map<String, Object> dataModel, JSONObject preference) throws ServiceException {
        Stopwatchs.start((String)"Fill Side");
        try {
            LOGGER.debug("Filling side....");
            Template template = Templates.getTemplate((String)((String)request.getAttribute("templateDirName")), (String)"side.ftl");
            if (null == template) {
                LOGGER.debug("The skin dose not contain [side.ftl] template");
                template = Templates.getTemplate((String)((String)request.getAttribute("templateDirName")), (String)"index.ftl");
                if (null == template) {
                    LOGGER.debug("The skin dose not contain [index.ftl] template");
                    return;
                }
            }
            dataModel.put("fillTagArticles", this.fillTagArticles);
            if (Templates.hasExpression((Template)template, (String)"<#list recentArticles as article>")) {
                this.fillRecentArticles(dataModel, preference);
            }
            if (Templates.hasExpression((Template)template, (String)"<#list links as link>")) {
                this.fillLinks(dataModel);
            }
            if (Templates.hasExpression((Template)template, (String)"<#list recentComments as comment>")) {
                this.fillRecentComments(dataModel, preference);
            }
            if (Templates.hasExpression((Template)template, (String)"<#list mostUsedTags as tag>")) {
                this.fillMostUsedTags(dataModel, preference);
            }
            if (Templates.hasExpression((Template)template, (String)"<#list mostCommentArticles as article>")) {
                this.fillMostCommentArticles(dataModel, preference);
            }
            if (Templates.hasExpression((Template)template, (String)"<#list mostViewCountArticles as article>")) {
                this.fillMostViewCountArticles(dataModel, preference);
            }
            if (Templates.hasExpression((Template)template, (String)"<#list archiveDates as archiveDate>")) {
                this.fillArchiveDates(dataModel, preference);
            }
        }
        catch (ServiceException e) {
            LOGGER.log(Level.ERROR, "Fills side failed", (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
        finally {
            Stopwatchs.end();
        }
    }

    public void fillUserTemplate(HttpServletRequest request, Template template, Map<String, Object> dataModel, JSONObject preference) throws ServiceException {
        Stopwatchs.start((String)("Fill User Template[name=" + template.getName() + "]"));
        try {
            LOGGER.log(Level.DEBUG, "Filling user template[name{0}]", new Object[]{template.getName()});
            if (Templates.hasExpression((Template)template, (String)"<#list links as link>")) {
                this.fillLinks(dataModel);
            }
            if (Templates.hasExpression((Template)template, (String)"<#list tags as tag>")) {
                this.fillTags(dataModel);
            }
            if (Templates.hasExpression((Template)template, (String)"<#list recentComments as comment>")) {
                this.fillRecentComments(dataModel, preference);
            }
            if (Templates.hasExpression((Template)template, (String)"<#list mostUsedTags as tag>")) {
                this.fillMostUsedTags(dataModel, preference);
            }
            if (Templates.hasExpression((Template)template, (String)"<#list mostCommentArticles as article>")) {
                this.fillMostCommentArticles(dataModel, preference);
            }
            if (Templates.hasExpression((Template)template, (String)"<#list mostViewCountArticles as article>")) {
                this.fillMostViewCountArticles(dataModel, preference);
            }
            if (Templates.hasExpression((Template)template, (String)"<#list archiveDates as archiveDate>")) {
                this.fillArchiveDates(dataModel, preference);
            }
            if (Templates.hasExpression((Template)template, (String)"<#include \"side.ftl\"/>")) {
                this.fillSide(request, dataModel, preference);
            }
            String noticeBoard = preference.getString("noticeBoard");
            dataModel.put("noticeBoard", noticeBoard);
        }
        catch (JSONException e) {
            LOGGER.log(Level.ERROR, "Fills user template failed", (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
        finally {
            Stopwatchs.end();
        }
    }

    private void fillPageNavigations(Map<String, Object> dataModel) throws ServiceException {
        Stopwatchs.start((String)"Fill Navigations");
        try {
            LOGGER.debug("Filling page navigations....");
            List<JSONObject> pages = this.pageRepository.getPages();
            for (JSONObject page : pages) {
                if (!"page".equals(page.optString("pageType"))) continue;
                String permalink = page.optString("pagePermalink");
                page.put("pagePermalink", (Object)(Latkes.getServePath() + permalink));
            }
            dataModel.put("pageNavigations", pages);
        }
        catch (RepositoryException e) {
            LOGGER.log(Level.ERROR, "Fills page navigations failed", (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
        finally {
            Stopwatchs.end();
        }
    }

    private void fillStatistic(Map<String, Object> dataModel) throws ServiceException {
        Stopwatchs.start((String)"Fill Statistic");
        try {
            LOGGER.debug("Filling statistic....");
            JSONObject statistic = this.statisticQueryService.getStatistic();
            dataModel.put("statistic", statistic);
        }
        catch (ServiceException e) {
            LOGGER.log(Level.ERROR, "Fills statistic failed", (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
        finally {
            Stopwatchs.end();
        }
    }

    private void setArticleExProperties(HttpServletRequest request, JSONObject article, JSONObject author, JSONObject preference) throws ServiceException {
        try {
            String authorName = author.getString("userName");
            article.put("authorName", (Object)authorName);
            String authorId = author.getString(Keys.OBJECT_ID);
            article.put("authorId", (Object)authorId);
            String thumbnailURL = Thumbnails.getGravatarURL(author.optString("userEmail"), "60");
            article.put("authorThumbnailURL", (Object)thumbnailURL);
            if (preference.getBoolean("enableArticleUpdateHint")) {
                article.put("hasUpdated", this.articleQueryService.hasUpdated(article));
            } else {
                article.put("hasUpdated", false);
            }
            if (this.articleQueryService.needViewPwd(request, article)) {
                String content = this.langPropsService.get("articleContentPwd");
                article.put("articleContent", (Object)content);
            }
            this.processArticleAbstract(preference, article);
            this.articleQueryService.markdown(article);
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Sets article extra properties failed", (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
    }

    private void setArticleExProperties(HttpServletRequest request, JSONObject article, JSONObject preference) throws ServiceException {
        try {
            JSONObject author = this.articleQueryService.getAuthor(article);
            String authorName = author.getString("userName");
            article.put("authorName", (Object)authorName);
            String authorId = author.getString(Keys.OBJECT_ID);
            article.put("authorId", (Object)authorId);
            String thumbnailURL = Thumbnails.getGravatarURL(author.optString("userEmail"), "60");
            article.put("authorThumbnailURL", (Object)thumbnailURL);
            if (preference.getBoolean("enableArticleUpdateHint")) {
                article.put("hasUpdated", this.articleQueryService.hasUpdated(article));
            } else {
                article.put("hasUpdated", false);
            }
            if (this.articleQueryService.needViewPwd(request, article)) {
                String content = this.langPropsService.get("articleContentPwd");
                article.put("articleContent", (Object)content);
            }
            this.processArticleAbstract(preference, article);
            this.articleQueryService.markdown(article);
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Sets article extra properties failed", (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
    }

    public void setArticlesExProperties(HttpServletRequest request, List<JSONObject> articles, JSONObject author, JSONObject preference) throws ServiceException {
        for (JSONObject article : articles) {
            this.setArticleExProperties(request, article, author, preference);
        }
    }

    public void setArticlesExProperties(HttpServletRequest request, List<JSONObject> articles, JSONObject preference) throws ServiceException {
        for (JSONObject article : articles) {
            this.setArticleExProperties(request, article, preference);
        }
    }

    private void processArticleAbstract(JSONObject preference, JSONObject article) {
        String articleListStyle;
        String articleAbstract = article.optString("articleAbstract", null);
        if (null == articleAbstract) {
            article.put("articleAbstract", (Object)"");
        }
        if ("titleOnly".equals(articleListStyle = preference.optString("articleListStyle"))) {
            article.put("articleAbstract", (Object)"");
        } else if ("titleAndContent".equals(articleListStyle)) {
            article.put("articleAbstract", (Object)article.optString("articleContent"));
        }
    }
}

