/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.solo.processor.util;

import freemarker.template.TemplateMethodModel;
import freemarker.template.TemplateModelException;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.b3log.latke.Keys;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.service.ServiceException;
import org.b3log.latke.service.annotation.Service;
import org.b3log.solo.service.ArticleQueryService;
import org.b3log.solo.service.TagQueryService;
import org.json.JSONException;
import org.json.JSONObject;

@Service
public class FillTagArticles
implements TemplateMethodModel {
    private static final Logger LOGGER = Logger.getLogger((String)FillTagArticles.class.getName());
    @Inject
    private TagQueryService tagQueryService;
    @Inject
    private ArticleQueryService articleQueryService;
    private static final int ARG_SIZE = 3;

    public Object exec(List arguments) throws TemplateModelException {
        if (arguments.size() != 3) {
            LOGGER.debug("FillTagArticles with wrong arguments!");
            throw new TemplateModelException("Wrong arguments!");
        }
        String tagTitle = (String)arguments.get(0);
        int currentPageNum = Integer.parseInt((String)arguments.get(1));
        int pageSize = Integer.parseInt((String)arguments.get(2));
        try {
            JSONObject result = this.tagQueryService.getTagByTitle(tagTitle);
            if (null == result) {
                return new ArrayList();
            }
            JSONObject tag = result.getJSONObject("tag");
            String tagId = tag.getString(Keys.OBJECT_ID);
            List<JSONObject> list = this.articleQueryService.getArticlesByTag(tagId, currentPageNum, pageSize);
            return list;
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return null;
    }
}

