/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.solo.processor.console.common;

import java.io.IOException;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.b3log.latke.ioc.LatkeBeanManager;
import org.b3log.latke.ioc.Lifecycle;
import org.b3log.latke.servlet.HTTPRequestContext;
import org.b3log.latke.servlet.advice.BeforeRequestProcessAdvice;
import org.b3log.latke.servlet.advice.RequestProcessAdviceException;
import org.b3log.latke.servlet.advice.RequestReturnAdviceException;
import org.b3log.solo.service.UserQueryService;

@Named
@Singleton
public class ProcessAuthAdvice
extends BeforeRequestProcessAdvice {
    public void doAdvice(HTTPRequestContext context, Map<String, Object> args) throws RequestProcessAdviceException {
        LatkeBeanManager beanManager = Lifecycle.getBeanManager();
        UserQueryService userQueryService = (UserQueryService)beanManager.getReference(UserQueryService.class);
        if (!userQueryService.isLoggedIn(context.getRequest(), context.getResponse())) {
            try {
                context.getResponse().sendError(403);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            throw new RequestReturnAdviceException(null);
        }
    }
}

