/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.solo.processor.console;

import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.b3log.latke.Keys;
import org.b3log.latke.Latkes;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.service.LangPropsService;
import org.b3log.latke.service.ServiceException;
import org.b3log.latke.servlet.HTTPRequestContext;
import org.b3log.latke.servlet.HTTPRequestMethod;
import org.b3log.latke.servlet.annotation.RequestProcessing;
import org.b3log.latke.servlet.annotation.RequestProcessor;
import org.b3log.latke.servlet.renderer.AbstractHTTPResponseRenderer;
import org.b3log.latke.servlet.renderer.JSONRenderer;
import org.b3log.latke.util.Requests;
import org.b3log.solo.service.UserMgmtService;
import org.b3log.solo.service.UserQueryService;
import org.b3log.solo.util.QueryResults;
import org.json.JSONObject;

@RequestProcessor
public class UserConsole {
    private static final Logger LOGGER = Logger.getLogger((String)UserConsole.class.getName());
    @Inject
    private UserQueryService userQueryService;
    @Inject
    private UserMgmtService userMgmtService;
    @Inject
    private LangPropsService langPropsService;

    @RequestProcessing(value={"/console/user/"}, method={HTTPRequestMethod.PUT})
    public void updateUser(HttpServletRequest request, HttpServletResponse response, HTTPRequestContext context) throws Exception {
        if (!this.userQueryService.isAdminLoggedIn(request)) {
            response.sendError(403);
            return;
        }
        JSONRenderer renderer = new JSONRenderer();
        context.setRenderer((AbstractHTTPResponseRenderer)renderer);
        JSONObject ret = new JSONObject();
        try {
            JSONObject requestJSONObject = Requests.parseRequestJSONObject((HttpServletRequest)request, (HttpServletResponse)response);
            this.userMgmtService.updateUser(requestJSONObject);
            ret.put("sc", true);
            ret.put("msg", (Object)this.langPropsService.get("updateSuccLabel"));
            renderer.setJSONObject(ret);
        }
        catch (ServiceException e) {
            LOGGER.log(Level.ERROR, e.getMessage(), (Throwable)e);
            JSONObject jsonObject = QueryResults.defaultResult();
            renderer.setJSONObject(jsonObject);
            jsonObject.put("msg", (Object)e.getMessage());
        }
    }

    @RequestProcessing(value={"/console/user/"}, method={HTTPRequestMethod.POST})
    public void addUser(HttpServletRequest request, HttpServletResponse response, HTTPRequestContext context) throws Exception {
        JSONRenderer renderer = new JSONRenderer();
        context.setRenderer((AbstractHTTPResponseRenderer)renderer);
        JSONObject ret = new JSONObject();
        try {
            JSONObject requestJSONObject = Requests.parseRequestJSONObject((HttpServletRequest)request, (HttpServletResponse)response);
            if (this.userQueryService.isAdminLoggedIn(request)) {
                requestJSONObject.put("userRole", (Object)"defaultRole");
            } else {
                requestJSONObject.put("userRole", (Object)"visitorRole");
            }
            String userId = this.userMgmtService.addUser(requestJSONObject);
            ret.put(Keys.OBJECT_ID, (Object)userId);
            ret.put("msg", (Object)this.langPropsService.get("addSuccLabel"));
            ret.put("sc", true);
            renderer.setJSONObject(ret);
        }
        catch (ServiceException e) {
            LOGGER.log(Level.ERROR, e.getMessage(), (Throwable)e);
            JSONObject jsonObject = QueryResults.defaultResult();
            renderer.setJSONObject(jsonObject);
            jsonObject.put("msg", (Object)e.getMessage());
        }
    }

    @RequestProcessing(value={"/console/user/*"}, method={HTTPRequestMethod.DELETE})
    public void removeUser(HttpServletRequest request, HttpServletResponse response, HTTPRequestContext context) throws Exception {
        if (!this.userQueryService.isAdminLoggedIn(request)) {
            response.sendError(403);
            return;
        }
        JSONRenderer renderer = new JSONRenderer();
        context.setRenderer((AbstractHTTPResponseRenderer)renderer);
        JSONObject jsonObject = new JSONObject();
        renderer.setJSONObject(jsonObject);
        try {
            String userId = request.getRequestURI().substring((Latkes.getContextPath() + "/console/user/").length());
            this.userMgmtService.removeUser(userId);
            jsonObject.put("sc", true);
            jsonObject.put("msg", (Object)this.langPropsService.get("removeSuccLabel"));
        }
        catch (ServiceException e) {
            LOGGER.log(Level.ERROR, e.getMessage(), (Throwable)e);
            jsonObject.put("sc", false);
            jsonObject.put("msg", (Object)this.langPropsService.get("removeFailLabel"));
        }
    }

    @RequestProcessing(value={"/console/users/*/*/*"}, method={HTTPRequestMethod.GET})
    public void getUsers(HttpServletRequest request, HttpServletResponse response, HTTPRequestContext context) throws Exception {
        JSONRenderer renderer = new JSONRenderer();
        context.setRenderer((AbstractHTTPResponseRenderer)renderer);
        if (!this.userQueryService.isAdminLoggedIn(request)) {
            response.sendError(403);
            return;
        }
        try {
            String requestURI = request.getRequestURI();
            String path = requestURI.substring((Latkes.getContextPath() + "/console/users/").length());
            JSONObject requestJSONObject = Requests.buildPaginationRequest((String)path);
            JSONObject result = this.userQueryService.getUsers(requestJSONObject);
            result.put("sc", true);
            renderer.setJSONObject(result);
        }
        catch (ServiceException e) {
            LOGGER.log(Level.ERROR, e.getMessage(), (Throwable)e);
            JSONObject jsonObject = QueryResults.defaultResult();
            renderer.setJSONObject(jsonObject);
            jsonObject.put("msg", (Object)this.langPropsService.get("getFailLabel"));
        }
    }

    @RequestProcessing(value={"/console/user/*"}, method={HTTPRequestMethod.GET})
    public void getUser(HttpServletRequest request, HttpServletResponse response, HTTPRequestContext context) throws Exception {
        if (!this.userQueryService.isAdminLoggedIn(request)) {
            response.sendError(403);
            return;
        }
        JSONRenderer renderer = new JSONRenderer();
        context.setRenderer((AbstractHTTPResponseRenderer)renderer);
        try {
            String requestURI = request.getRequestURI();
            String userId = requestURI.substring((Latkes.getContextPath() + "/console/user/").length());
            JSONObject result = this.userQueryService.getUser(userId);
            if (null == result) {
                renderer.setJSONObject(QueryResults.defaultResult());
                return;
            }
            renderer.setJSONObject(result);
            result.put("sc", true);
        }
        catch (ServiceException e) {
            LOGGER.log(Level.ERROR, e.getMessage(), (Throwable)e);
            JSONObject jsonObject = QueryResults.defaultResult();
            renderer.setJSONObject(jsonObject);
            jsonObject.put("msg", (Object)this.langPropsService.get("getFailLabel"));
        }
    }

    @RequestProcessing(value={"/console/changeRole/*"}, method={HTTPRequestMethod.GET})
    public void changeUserRole(HttpServletRequest request, HttpServletResponse response, HTTPRequestContext context) throws Exception {
        if (!this.userQueryService.isAdminLoggedIn(request)) {
            response.sendError(403);
            return;
        }
        JSONRenderer renderer = new JSONRenderer();
        context.setRenderer((AbstractHTTPResponseRenderer)renderer);
        JSONObject jsonObject = new JSONObject();
        renderer.setJSONObject(jsonObject);
        try {
            String userId = request.getRequestURI().substring((Latkes.getContextPath() + "/console/changeRole/").length());
            this.userMgmtService.changeRole(userId);
            jsonObject.put("sc", true);
            jsonObject.put("msg", (Object)this.langPropsService.get("updateSuccLabel"));
        }
        catch (ServiceException e) {
            LOGGER.log(Level.ERROR, e.getMessage(), (Throwable)e);
            jsonObject.put("sc", false);
            jsonObject.put("msg", (Object)this.langPropsService.get("removeFailLabel"));
        }
    }
}

