/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.solo.processor.console;

import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.b3log.latke.Keys;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.service.LangPropsService;
import org.b3log.latke.service.ServiceException;
import org.b3log.latke.servlet.HTTPRequestContext;
import org.b3log.latke.servlet.HTTPRequestMethod;
import org.b3log.latke.servlet.annotation.RequestProcessing;
import org.b3log.latke.servlet.annotation.RequestProcessor;
import org.b3log.latke.servlet.renderer.AbstractHTTPResponseRenderer;
import org.b3log.latke.servlet.renderer.JSONRenderer;
import org.b3log.latke.util.Requests;
import org.b3log.solo.service.OptionMgmtService;
import org.b3log.solo.service.OptionQueryService;
import org.b3log.solo.service.PreferenceMgmtService;
import org.b3log.solo.service.PreferenceQueryService;
import org.b3log.solo.service.UserQueryService;
import org.b3log.solo.util.QueryResults;
import org.json.JSONArray;
import org.json.JSONObject;

@RequestProcessor
public class PreferenceConsole {
    private static final Logger LOGGER = Logger.getLogger((String)PreferenceConsole.class.getName());
    @Inject
    private PreferenceQueryService preferenceQueryService;
    @Inject
    private PreferenceMgmtService preferenceMgmtService;
    @Inject
    private OptionMgmtService optionMgmtService;
    @Inject
    private OptionQueryService optionQueryService;
    @Inject
    private UserQueryService userQueryService;
    @Inject
    private LangPropsService langPropsService;
    private static final String PREFERENCE_URI_PREFIX = "/console/preference/";

    @RequestProcessing(value={"/console/reply/notification/template"}, method={HTTPRequestMethod.GET})
    public void getReplyNotificationTemplate(HttpServletRequest request, HttpServletResponse response, HTTPRequestContext context) throws Exception {
        if (!this.userQueryService.isLoggedIn(request, response)) {
            response.sendError(403);
            return;
        }
        JSONRenderer renderer = new JSONRenderer();
        context.setRenderer((AbstractHTTPResponseRenderer)renderer);
        try {
            JSONObject replyNotificationTemplate = this.preferenceQueryService.getReplyNotificationTemplate();
            JSONObject ret = new JSONObject();
            renderer.setJSONObject(ret);
            ret.put("replyNotificationTemplate", (Object)replyNotificationTemplate);
            ret.put("sc", true);
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, e.getMessage(), (Throwable)e);
            JSONObject jsonObject = QueryResults.defaultResult();
            renderer.setJSONObject(jsonObject);
            jsonObject.put("msg", (Object)this.langPropsService.get("getFailLabel"));
        }
    }

    @RequestProcessing(value={"/console/reply/notification/template"}, method={HTTPRequestMethod.PUT})
    public void updateReplyNotificationTemplate(HttpServletRequest request, HttpServletResponse response, HTTPRequestContext context) throws Exception {
        if (!this.userQueryService.isLoggedIn(request, response)) {
            response.sendError(403);
            return;
        }
        JSONRenderer renderer = new JSONRenderer();
        context.setRenderer((AbstractHTTPResponseRenderer)renderer);
        try {
            JSONObject requestJSONObject = Requests.parseRequestJSONObject((HttpServletRequest)request, (HttpServletResponse)response);
            JSONObject replyNotificationTemplate = requestJSONObject.getJSONObject("replyNotificationTemplate");
            this.preferenceMgmtService.updateReplyNotificationTemplate(replyNotificationTemplate);
            JSONObject ret = new JSONObject();
            ret.put("sc", true);
            ret.put("msg", (Object)this.langPropsService.get("updateSuccLabel"));
            renderer.setJSONObject(ret);
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, e.getMessage(), (Throwable)e);
            JSONObject jsonObject = QueryResults.defaultResult();
            renderer.setJSONObject(jsonObject);
            jsonObject.put("msg", (Object)this.langPropsService.get("updateFailLabel"));
        }
    }

    @RequestProcessing(value={"/console/signs/"}, method={HTTPRequestMethod.GET})
    public void getSigns(HttpServletRequest request, HttpServletResponse response, HTTPRequestContext context) throws Exception {
        if (!this.userQueryService.isLoggedIn(request, response)) {
            response.sendError(403);
            return;
        }
        JSONRenderer renderer = new JSONRenderer();
        context.setRenderer((AbstractHTTPResponseRenderer)renderer);
        try {
            JSONObject preference = this.preferenceQueryService.getPreference();
            JSONArray signs = new JSONArray();
            JSONArray allSigns = new JSONArray(preference.getString("signs"));
            for (int i = 1; i < allSigns.length(); ++i) {
                signs.put((Object)allSigns.getJSONObject(i));
            }
            JSONObject ret = new JSONObject();
            renderer.setJSONObject(ret);
            ret.put("signs", (Object)signs);
            ret.put("sc", true);
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, e.getMessage(), (Throwable)e);
            JSONObject jsonObject = QueryResults.defaultResult();
            renderer.setJSONObject(jsonObject);
            jsonObject.put("msg", (Object)this.langPropsService.get("getFailLabel"));
        }
    }

    @RequestProcessing(value={"/console/preference/"}, method={HTTPRequestMethod.GET})
    public void getPreference(HttpServletRequest request, HttpServletResponse response, HTTPRequestContext context) throws Exception {
        if (!this.userQueryService.isAdminLoggedIn(request)) {
            response.sendError(403);
            return;
        }
        JSONRenderer renderer = new JSONRenderer();
        context.setRenderer((AbstractHTTPResponseRenderer)renderer);
        try {
            JSONObject preference = this.preferenceQueryService.getPreference();
            if (null == preference) {
                renderer.setJSONObject(QueryResults.defaultResult());
                return;
            }
            JSONObject ret = new JSONObject();
            renderer.setJSONObject(ret);
            ret.put("preference", (Object)preference);
            ret.put("sc", true);
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, e.getMessage(), (Throwable)e);
            JSONObject jsonObject = QueryResults.defaultResult();
            renderer.setJSONObject(jsonObject);
            jsonObject.put("msg", (Object)this.langPropsService.get("getFailLabel"));
        }
    }

    @RequestProcessing(value={"/console/preference/"}, method={HTTPRequestMethod.PUT})
    public void updatePreference(HttpServletRequest request, HttpServletResponse response, HTTPRequestContext context) throws Exception {
        if (!this.userQueryService.isAdminLoggedIn(request)) {
            response.sendError(403);
            return;
        }
        JSONRenderer renderer = new JSONRenderer();
        context.setRenderer((AbstractHTTPResponseRenderer)renderer);
        try {
            JSONObject requestJSONObject = Requests.parseRequestJSONObject((HttpServletRequest)request, (HttpServletResponse)response);
            JSONObject preference = requestJSONObject.getJSONObject("preference");
            JSONObject ret = new JSONObject();
            renderer.setJSONObject(ret);
            if (this.isInvalid(preference, ret)) {
                return;
            }
            this.preferenceMgmtService.updatePreference(preference);
            ret.put("sc", true);
            ret.put("msg", (Object)this.langPropsService.get("updateSuccLabel"));
        }
        catch (ServiceException e) {
            LOGGER.log(Level.ERROR, e.getMessage(), (Throwable)e);
            JSONObject jsonObject = QueryResults.defaultResult();
            renderer.setJSONObject(jsonObject);
            jsonObject.put("msg", (Object)e.getMessage());
        }
    }

    @RequestProcessing(value={"/console/preference/qiniu"}, method={HTTPRequestMethod.GET})
    public void getQiniuPreference(HttpServletRequest request, HttpServletResponse response, HTTPRequestContext context) throws Exception {
        if (!this.userQueryService.isAdminLoggedIn(request)) {
            response.sendError(403);
            return;
        }
        JSONRenderer renderer = new JSONRenderer();
        context.setRenderer((AbstractHTTPResponseRenderer)renderer);
        try {
            JSONObject qiniu = this.optionQueryService.getOptions("qiniu");
            if (null == qiniu) {
                renderer.setJSONObject(QueryResults.defaultResult());
                return;
            }
            JSONObject ret = new JSONObject();
            renderer.setJSONObject(ret);
            ret.put("qiniu", (Object)qiniu);
            ret.put("sc", true);
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, e.getMessage(), (Throwable)e);
            JSONObject jsonObject = QueryResults.defaultResult();
            renderer.setJSONObject(jsonObject);
            jsonObject.put("msg", (Object)this.langPropsService.get("getFailLabel"));
        }
    }

    @RequestProcessing(value={"/console/preference/qiniu"}, method={HTTPRequestMethod.PUT})
    public void updateQiniu(HttpServletRequest request, HttpServletResponse response, HTTPRequestContext context) throws Exception {
        if (!this.userQueryService.isAdminLoggedIn(request)) {
            response.sendError(403);
            return;
        }
        JSONRenderer renderer = new JSONRenderer();
        context.setRenderer((AbstractHTTPResponseRenderer)renderer);
        try {
            JSONObject requestJSONObject = Requests.parseRequestJSONObject((HttpServletRequest)request, (HttpServletResponse)response);
            String accessKey = requestJSONObject.optString("qiniuAccessKey");
            String secretKey = requestJSONObject.optString("qiniuSecretKey");
            String domain = requestJSONObject.optString("qiniuDomain");
            String bucket = requestJSONObject.optString("qiniuBucket");
            JSONObject ret = new JSONObject();
            renderer.setJSONObject(ret);
            if (StringUtils.isNotBlank((String)domain) && !StringUtils.endsWith((String)domain, (String)"/")) {
                domain = domain + "/";
            }
            JSONObject accessKeyOpt = new JSONObject();
            accessKeyOpt.put(Keys.OBJECT_ID, (Object)"qiniuAccessKey");
            accessKeyOpt.put("optionCategory", (Object)"qiniu");
            accessKeyOpt.put("optionValue", (Object)accessKey);
            JSONObject secretKeyOpt = new JSONObject();
            secretKeyOpt.put(Keys.OBJECT_ID, (Object)"qiniuSecretKey");
            secretKeyOpt.put("optionCategory", (Object)"qiniu");
            secretKeyOpt.put("optionValue", (Object)secretKey);
            JSONObject domainOpt = new JSONObject();
            domainOpt.put(Keys.OBJECT_ID, (Object)"qiniuDomain");
            domainOpt.put("optionCategory", (Object)"qiniu");
            domainOpt.put("optionValue", (Object)domain);
            JSONObject bucketOpt = new JSONObject();
            bucketOpt.put(Keys.OBJECT_ID, (Object)"qiniuBucket");
            bucketOpt.put("optionCategory", (Object)"qiniu");
            bucketOpt.put("optionValue", (Object)bucket);
            this.optionMgmtService.addOrUpdateOption(accessKeyOpt);
            this.optionMgmtService.addOrUpdateOption(secretKeyOpt);
            this.optionMgmtService.addOrUpdateOption(domainOpt);
            this.optionMgmtService.addOrUpdateOption(bucketOpt);
            ret.put("sc", true);
            ret.put("msg", (Object)this.langPropsService.get("updateSuccLabel"));
        }
        catch (ServiceException e) {
            LOGGER.log(Level.ERROR, e.getMessage(), (Throwable)e);
            JSONObject jsonObject = QueryResults.defaultResult();
            renderer.setJSONObject(jsonObject);
            jsonObject.put("msg", (Object)e.getMessage());
        }
    }

    private boolean isInvalid(JSONObject preference, JSONObject responseObject) {
        responseObject.put("sc", false);
        StringBuilder errMsgBuilder = new StringBuilder('[' + this.langPropsService.get("paramSettingsLabel"));
        errMsgBuilder.append(" - ");
        String input = preference.optString("externalRelevantArticlesDisplayCount");
        if (!this.isNonNegativeInteger(input)) {
            errMsgBuilder.append(this.langPropsService.get("externalRelevantArticlesDisplayCntLabel")).append("]  ").append(this.langPropsService.get("nonNegativeIntegerOnlyLabel"));
            responseObject.put("msg", (Object)errMsgBuilder.toString());
            return true;
        }
        input = preference.optString("relevantArticlesDisplayCount");
        if (!this.isNonNegativeInteger(input)) {
            errMsgBuilder.append(this.langPropsService.get("relevantArticlesDisplayCntLabel")).append("]  ").append(this.langPropsService.get("nonNegativeIntegerOnlyLabel"));
            responseObject.put("msg", (Object)errMsgBuilder.toString());
            return true;
        }
        input = preference.optString("randomArticlesDisplayCount");
        if (!this.isNonNegativeInteger(input)) {
            errMsgBuilder.append(this.langPropsService.get("randomArticlesDisplayCntLabel")).append("]  ").append(this.langPropsService.get("nonNegativeIntegerOnlyLabel"));
            responseObject.put("msg", (Object)errMsgBuilder.toString());
            return true;
        }
        input = preference.optString("mostCommentArticleDisplayCount");
        if (!this.isNonNegativeInteger(input)) {
            errMsgBuilder.append(this.langPropsService.get("indexMostCommentArticleDisplayCntLabel")).append("]  ").append(this.langPropsService.get("nonNegativeIntegerOnlyLabel"));
            responseObject.put("msg", (Object)errMsgBuilder.toString());
            return true;
        }
        input = preference.optString("mostViewArticleDisplayCount");
        if (!this.isNonNegativeInteger(input)) {
            errMsgBuilder.append(this.langPropsService.get("indexMostViewArticleDisplayCntLabel")).append("]  ").append(this.langPropsService.get("nonNegativeIntegerOnlyLabel"));
            responseObject.put("msg", (Object)errMsgBuilder.toString());
            return true;
        }
        input = preference.optString("recentCommentDisplayCount");
        if (!this.isNonNegativeInteger(input)) {
            errMsgBuilder.append(this.langPropsService.get("indexRecentCommentDisplayCntLabel")).append("]  ").append(this.langPropsService.get("nonNegativeIntegerOnlyLabel"));
            responseObject.put("msg", (Object)errMsgBuilder.toString());
            return true;
        }
        input = preference.optString("mostUsedTagDisplayCount");
        if (!this.isNonNegativeInteger(input)) {
            errMsgBuilder.append(this.langPropsService.get("indexTagDisplayCntLabel")).append("]  ").append(this.langPropsService.get("nonNegativeIntegerOnlyLabel"));
            responseObject.put("msg", (Object)errMsgBuilder.toString());
            return true;
        }
        input = preference.optString("articleListDisplayCount");
        if (!this.isNonNegativeInteger(input)) {
            errMsgBuilder.append(this.langPropsService.get("pageSizeLabel")).append("]  ").append(this.langPropsService.get("nonNegativeIntegerOnlyLabel"));
            responseObject.put("msg", (Object)errMsgBuilder.toString());
            return true;
        }
        input = preference.optString("articleListPaginationWindowSize");
        if (!this.isNonNegativeInteger(input)) {
            errMsgBuilder.append(this.langPropsService.get("windowSizeLabel")).append("]  ").append(this.langPropsService.get("nonNegativeIntegerOnlyLabel"));
            responseObject.put("msg", (Object)errMsgBuilder.toString());
            return true;
        }
        input = preference.optString("feedOutputCnt");
        if (!this.isNonNegativeInteger(input)) {
            errMsgBuilder.append(this.langPropsService.get("feedOutputCntLabel")).append("]  ").append(this.langPropsService.get("nonNegativeIntegerOnlyLabel"));
            responseObject.put("msg", (Object)errMsgBuilder.toString());
            return true;
        }
        return false;
    }

    private boolean isNonNegativeInteger(String input) {
        try {
            return 0 <= Integer.valueOf(input);
        }
        catch (Exception e) {
            return false;
        }
    }
}

