/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.solo.processor.console;

import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.b3log.latke.Keys;
import org.b3log.latke.Latkes;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.service.LangPropsService;
import org.b3log.latke.servlet.HTTPRequestContext;
import org.b3log.latke.servlet.HTTPRequestMethod;
import org.b3log.latke.servlet.annotation.RequestProcessing;
import org.b3log.latke.servlet.annotation.RequestProcessor;
import org.b3log.latke.servlet.renderer.AbstractHTTPResponseRenderer;
import org.b3log.latke.servlet.renderer.JSONRenderer;
import org.b3log.latke.util.Requests;
import org.b3log.solo.service.LinkMgmtService;
import org.b3log.solo.service.LinkQueryService;
import org.b3log.solo.service.UserQueryService;
import org.b3log.solo.util.QueryResults;
import org.json.JSONObject;

@RequestProcessor
public class LinkConsole {
    private static final Logger LOGGER = Logger.getLogger((String)LinkConsole.class.getName());
    @Inject
    private UserQueryService userQueryService;
    @Inject
    private LinkQueryService linkQueryService;
    @Inject
    private LinkMgmtService linkMgmtService;
    @Inject
    private LangPropsService langPropsService;

    @RequestProcessing(value={"/console/link/*"}, method={HTTPRequestMethod.DELETE})
    public void removeLink(HttpServletRequest request, HttpServletResponse response, HTTPRequestContext context) throws Exception {
        if (!this.userQueryService.isAdminLoggedIn(request)) {
            response.sendError(403);
            return;
        }
        JSONRenderer renderer = new JSONRenderer();
        context.setRenderer((AbstractHTTPResponseRenderer)renderer);
        JSONObject jsonObject = new JSONObject();
        renderer.setJSONObject(jsonObject);
        try {
            String linkId = request.getRequestURI().substring((Latkes.getContextPath() + "/console/link/").length());
            this.linkMgmtService.removeLink(linkId);
            jsonObject.put("sc", true);
            jsonObject.put("msg", (Object)this.langPropsService.get("removeSuccLabel"));
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, e.getMessage(), (Throwable)e);
            jsonObject.put("sc", false);
            jsonObject.put("msg", (Object)this.langPropsService.get("removeFailLabel"));
        }
    }

    @RequestProcessing(value={"/console/link/"}, method={HTTPRequestMethod.PUT})
    public void updateLink(HttpServletRequest request, HttpServletResponse response, HTTPRequestContext context) throws Exception {
        if (!this.userQueryService.isAdminLoggedIn(request)) {
            response.sendError(403);
            return;
        }
        JSONRenderer renderer = new JSONRenderer();
        context.setRenderer((AbstractHTTPResponseRenderer)renderer);
        JSONObject ret = new JSONObject();
        try {
            JSONObject requestJSONObject = Requests.parseRequestJSONObject((HttpServletRequest)request, (HttpServletResponse)response);
            this.linkMgmtService.updateLink(requestJSONObject);
            ret.put("sc", true);
            ret.put("msg", (Object)this.langPropsService.get("updateSuccLabel"));
            renderer.setJSONObject(ret);
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, e.getMessage(), (Throwable)e);
            JSONObject jsonObject = QueryResults.defaultResult();
            renderer.setJSONObject(jsonObject);
            jsonObject.put("msg", (Object)this.langPropsService.get("updateFailLabel"));
        }
    }

    @RequestProcessing(value={"/console/link/order/"}, method={HTTPRequestMethod.PUT})
    public void changeOrder(HttpServletRequest request, HttpServletResponse response, HTTPRequestContext context) throws Exception {
        if (!this.userQueryService.isAdminLoggedIn(request)) {
            response.sendError(403);
            return;
        }
        JSONRenderer renderer = new JSONRenderer();
        context.setRenderer((AbstractHTTPResponseRenderer)renderer);
        JSONObject ret = new JSONObject();
        try {
            JSONObject requestJSONObject = Requests.parseRequestJSONObject((HttpServletRequest)request, (HttpServletResponse)response);
            String linkId = requestJSONObject.getString(Keys.OBJECT_ID);
            String direction = requestJSONObject.getString("direction");
            this.linkMgmtService.changeOrder(linkId, direction);
            ret.put("sc", true);
            ret.put("msg", (Object)this.langPropsService.get("updateSuccLabel"));
            renderer.setJSONObject(ret);
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, e.getMessage(), (Throwable)e);
            JSONObject jsonObject = QueryResults.defaultResult();
            renderer.setJSONObject(jsonObject);
            jsonObject.put("msg", (Object)this.langPropsService.get("updateFailLabel"));
        }
    }

    @RequestProcessing(value={"/console/link/"}, method={HTTPRequestMethod.POST})
    public void addLink(HttpServletRequest request, HttpServletResponse response, HTTPRequestContext context) throws Exception {
        if (!this.userQueryService.isAdminLoggedIn(request)) {
            response.sendError(403);
            return;
        }
        JSONRenderer renderer = new JSONRenderer();
        context.setRenderer((AbstractHTTPResponseRenderer)renderer);
        JSONObject ret = new JSONObject();
        try {
            JSONObject requestJSONObject = Requests.parseRequestJSONObject((HttpServletRequest)request, (HttpServletResponse)response);
            String linkId = this.linkMgmtService.addLink(requestJSONObject);
            ret.put(Keys.OBJECT_ID, (Object)linkId);
            ret.put("msg", (Object)this.langPropsService.get("addSuccLabel"));
            ret.put("sc", true);
            renderer.setJSONObject(ret);
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, e.getMessage(), (Throwable)e);
            JSONObject jsonObject = QueryResults.defaultResult();
            renderer.setJSONObject(jsonObject);
            jsonObject.put("msg", (Object)this.langPropsService.get("addFailLabel"));
        }
    }

    @RequestProcessing(value={"/console/links/*/*/*"}, method={HTTPRequestMethod.GET})
    public void getLinks(HttpServletRequest request, HttpServletResponse response, HTTPRequestContext context) throws Exception {
        if (!this.userQueryService.isLoggedIn(request, response)) {
            response.sendError(403);
            return;
        }
        JSONRenderer renderer = new JSONRenderer();
        context.setRenderer((AbstractHTTPResponseRenderer)renderer);
        try {
            String requestURI = request.getRequestURI();
            String path = requestURI.substring((Latkes.getContextPath() + "/console/links/").length());
            JSONObject requestJSONObject = Requests.buildPaginationRequest((String)path);
            JSONObject result = this.linkQueryService.getLinks(requestJSONObject);
            result.put("sc", true);
            renderer.setJSONObject(result);
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, e.getMessage(), (Throwable)e);
            JSONObject jsonObject = QueryResults.defaultResult();
            renderer.setJSONObject(jsonObject);
            jsonObject.put("msg", (Object)this.langPropsService.get("getFailLabel"));
        }
    }

    @RequestProcessing(value={"/console/link/*"}, method={HTTPRequestMethod.GET})
    public void getLink(HttpServletRequest request, HttpServletResponse response, HTTPRequestContext context) throws Exception {
        if (!this.userQueryService.isLoggedIn(request, response)) {
            response.sendError(403);
            return;
        }
        JSONRenderer renderer = new JSONRenderer();
        context.setRenderer((AbstractHTTPResponseRenderer)renderer);
        try {
            String requestURI = request.getRequestURI();
            String linkId = requestURI.substring((Latkes.getContextPath() + "/console/link/").length());
            JSONObject result = this.linkQueryService.getLink(linkId);
            if (null == result) {
                renderer.setJSONObject(QueryResults.defaultResult());
                return;
            }
            renderer.setJSONObject(result);
            result.put("sc", true);
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, e.getMessage(), (Throwable)e);
            JSONObject jsonObject = QueryResults.defaultResult();
            renderer.setJSONObject(jsonObject);
            jsonObject.put("msg", (Object)this.langPropsService.get("getFailLabel"));
        }
    }
}

