/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.solo.processor.console;

import java.util.List;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.b3log.latke.Latkes;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.service.LangPropsService;
import org.b3log.latke.servlet.HTTPRequestContext;
import org.b3log.latke.servlet.HTTPRequestMethod;
import org.b3log.latke.servlet.annotation.RequestProcessing;
import org.b3log.latke.servlet.annotation.RequestProcessor;
import org.b3log.latke.servlet.renderer.AbstractHTTPResponseRenderer;
import org.b3log.latke.servlet.renderer.JSONRenderer;
import org.b3log.latke.util.Requests;
import org.b3log.solo.service.CommentMgmtService;
import org.b3log.solo.service.CommentQueryService;
import org.b3log.solo.service.UserQueryService;
import org.b3log.solo.util.QueryResults;
import org.json.JSONObject;

@RequestProcessor
public class CommentConsole {
    private static final Logger LOGGER = Logger.getLogger((String)CommentConsole.class.getName());
    @Inject
    private UserQueryService userQueryService;
    @Inject
    private CommentQueryService commentQueryService;
    @Inject
    private CommentMgmtService commentMgmtService;
    @Inject
    private LangPropsService langPropsService;

    @RequestProcessing(value={"/console/page/comment/*"}, method={HTTPRequestMethod.DELETE})
    public void removePageComment(HttpServletRequest request, HttpServletResponse response, HTTPRequestContext context) throws Exception {
        if (!this.userQueryService.isLoggedIn(request, response)) {
            response.sendError(403);
            return;
        }
        JSONRenderer renderer = new JSONRenderer();
        context.setRenderer((AbstractHTTPResponseRenderer)renderer);
        JSONObject ret = new JSONObject();
        renderer.setJSONObject(ret);
        try {
            String commentId = request.getRequestURI().substring((Latkes.getContextPath() + "/console/page/comment/").length());
            if (!this.commentQueryService.canAccessComment(commentId, request)) {
                ret.put("sc", false);
                ret.put("msg", (Object)this.langPropsService.get("forbiddenLabel"));
                return;
            }
            this.commentMgmtService.removePageComment(commentId);
            ret.put("sc", true);
            ret.put("msg", (Object)this.langPropsService.get("removeSuccLabel"));
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, e.getMessage(), (Throwable)e);
            ret.put("sc", false);
            ret.put("msg", (Object)this.langPropsService.get("removeFailLabel"));
        }
    }

    @RequestProcessing(value={"/console/article/comment/*"}, method={HTTPRequestMethod.DELETE})
    public void removeArticleComment(HttpServletRequest request, HttpServletResponse response, HTTPRequestContext context) throws Exception {
        if (!this.userQueryService.isLoggedIn(request, response)) {
            response.sendError(403);
            return;
        }
        JSONRenderer renderer = new JSONRenderer();
        context.setRenderer((AbstractHTTPResponseRenderer)renderer);
        JSONObject ret = new JSONObject();
        renderer.setJSONObject(ret);
        try {
            String commentId = request.getRequestURI().substring((Latkes.getContextPath() + "/console/article/comment/").length());
            if (!this.commentQueryService.canAccessComment(commentId, request)) {
                ret.put("sc", false);
                ret.put("msg", (Object)this.langPropsService.get("forbiddenLabel"));
                return;
            }
            this.commentMgmtService.removeArticleComment(commentId);
            ret.put("sc", true);
            ret.put("msg", (Object)this.langPropsService.get("removeSuccLabel"));
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, e.getMessage(), (Throwable)e);
            ret.put("sc", false);
            ret.put("msg", (Object)this.langPropsService.get("removeFailLabel"));
        }
    }

    @RequestProcessing(value={"/console/comments/*/*/*"}, method={HTTPRequestMethod.GET})
    public void getComments(HttpServletRequest request, HttpServletResponse response, HTTPRequestContext context) throws Exception {
        if (!this.userQueryService.isLoggedIn(request, response)) {
            response.sendError(403);
            return;
        }
        JSONRenderer renderer = new JSONRenderer();
        context.setRenderer((AbstractHTTPResponseRenderer)renderer);
        try {
            String requestURI = request.getRequestURI();
            String path = requestURI.substring((Latkes.getContextPath() + "/console/comments/").length());
            JSONObject requestJSONObject = Requests.buildPaginationRequest((String)path);
            JSONObject result = this.commentQueryService.getComments(requestJSONObject);
            result.put("sc", true);
            renderer.setJSONObject(result);
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, e.getMessage(), (Throwable)e);
            JSONObject jsonObject = QueryResults.defaultResult();
            renderer.setJSONObject(jsonObject);
            jsonObject.put("msg", (Object)this.langPropsService.get("getFailLabel"));
        }
    }

    @RequestProcessing(value={"/console/comments/article/*"}, method={HTTPRequestMethod.GET})
    public void getArticleComments(HTTPRequestContext context, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!this.userQueryService.isLoggedIn(request, response)) {
            response.sendError(403);
            return;
        }
        JSONRenderer renderer = new JSONRenderer();
        context.setRenderer((AbstractHTTPResponseRenderer)renderer);
        try {
            JSONObject ret = new JSONObject();
            renderer.setJSONObject(ret);
            String requestURI = request.getRequestURI();
            String articleId = requestURI.substring((Latkes.getContextPath() + "/console/comments/article/").length());
            List<JSONObject> comments = this.commentQueryService.getComments(articleId);
            ret.put("comments", comments);
            ret.put("sc", true);
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, e.getMessage(), (Throwable)e);
            JSONObject jsonObject = QueryResults.defaultResult();
            renderer.setJSONObject(jsonObject);
            jsonObject.put("msg", (Object)this.langPropsService.get("getFailLabel"));
        }
    }

    @RequestProcessing(value={"/console/comments/page/*"}, method={HTTPRequestMethod.GET})
    public void getPageComments(HTTPRequestContext context, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!this.userQueryService.isLoggedIn(request, response)) {
            response.sendError(403);
            return;
        }
        JSONRenderer renderer = new JSONRenderer();
        context.setRenderer((AbstractHTTPResponseRenderer)renderer);
        try {
            JSONObject ret = new JSONObject();
            renderer.setJSONObject(ret);
            String requestURI = request.getRequestURI();
            String pageId = requestURI.substring((Latkes.getContextPath() + "/console/comments/page/").length());
            List<JSONObject> comments = this.commentQueryService.getComments(pageId);
            ret.put("comments", comments);
            ret.put("sc", true);
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, e.getMessage(), (Throwable)e);
            JSONObject jsonObject = QueryResults.defaultResult();
            renderer.setJSONObject(jsonObject);
            jsonObject.put("msg", (Object)this.langPropsService.get("getFailLabel"));
        }
    }
}

