/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.solo.processor;

import java.io.IOException;
import javax.inject.Inject;
import org.b3log.latke.Keys;
import org.b3log.latke.Latkes;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.mail.MailService;
import org.b3log.latke.mail.MailServiceFactory;
import org.b3log.latke.repository.Query;
import org.b3log.latke.repository.Transaction;
import org.b3log.latke.service.LangPropsService;
import org.b3log.latke.service.ServiceException;
import org.b3log.latke.servlet.HTTPRequestContext;
import org.b3log.latke.servlet.HTTPRequestMethod;
import org.b3log.latke.servlet.annotation.RequestProcessing;
import org.b3log.latke.servlet.annotation.RequestProcessor;
import org.b3log.latke.servlet.renderer.AbstractHTTPResponseRenderer;
import org.b3log.latke.servlet.renderer.TextHTMLRenderer;
import org.b3log.solo.repository.ArticleRepository;
import org.b3log.solo.repository.PreferenceRepository;
import org.b3log.solo.repository.UserRepository;
import org.b3log.solo.service.PreferenceQueryService;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@RequestProcessor
public class UpgradeProcessor {
    private static final Logger LOGGER = Logger.getLogger((String)UpgradeProcessor.class.getName());
    @Inject
    private ArticleRepository articleRepository;
    @Inject
    private UserRepository userRepository;
    @Inject
    private PreferenceRepository preferenceRepository;
    private static final int STEP = 50;
    @Inject
    private PreferenceQueryService preferenceQueryService;
    private static final MailService MAIL_SVC = MailServiceFactory.getMailService();
    private static boolean sent = false;
    @Inject
    private LangPropsService langPropsService;
    private static final String FROM_VER = "0.6.9";
    private static final String TO_VER = "1.0.0";

    @RequestProcessing(value={"/upgrade/checker.do"}, method={HTTPRequestMethod.GET})
    public void upgrade(HTTPRequestContext context) {
        TextHTMLRenderer renderer = new TextHTMLRenderer();
        context.setRenderer((AbstractHTTPResponseRenderer)renderer);
        try {
            JSONObject preference = this.preferenceRepository.get("preference");
            if (null == preference) {
                LOGGER.log(Level.INFO, "Not init yet", new Object[0]);
                renderer.setContent("Not init yet");
                return;
            }
            renderer.setContent("Upgrade successfully ;-)");
            String currentVer = preference.getString("version");
            if (TO_VER.equals(currentVer)) {
                return;
            }
            if (FROM_VER.equals(currentVer)) {
                this.upgrade();
                return;
            }
            LOGGER.log(Level.WARN, "Attempt to skip more than one version to upgrade. Expected: {0}; Actually: {1}", new Object[]{FROM_VER, currentVer});
            if (!sent) {
                this.notifyUserByEmail();
                sent = true;
            }
            renderer.setContent(this.langPropsService.get("skipVersionAlert"));
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, e.getMessage(), (Throwable)e);
            renderer.setContent("Upgrade failed [" + e.getMessage() + "], please contact the Solo developers or reports this " + "issue directly (<a href='https://github.com/b3log/solo/issues/new'>" + "https://github.com/b3log/solo/issues/new</a>) ");
        }
    }

    private void upgrade() throws Exception {
        LOGGER.log(Level.INFO, "Upgrading from version [{0}] to version [{1}]....", new Object[]{FROM_VER, TO_VER});
        Transaction transaction = null;
        try {
            transaction = this.userRepository.beginTransaction();
            JSONObject preference = this.preferenceRepository.get("preference");
            preference.put("version", (Object)TO_VER);
            this.preferenceRepository.update("preference", preference);
            transaction.commit();
            LOGGER.log(Level.TRACE, "Updated preference", new Object[0]);
        }
        catch (Exception e) {
            if (null != transaction && transaction.isActive()) {
                transaction.rollback();
            }
            LOGGER.log(Level.ERROR, "Upgrade failed!", (Throwable)e);
            throw new Exception("Upgrade failed from version [0.6.9] to version [1.0.0]");
        }
        LOGGER.log(Level.INFO, "Upgraded from version [{0}] to version [{1}] successfully :-)", new Object[]{FROM_VER, TO_VER});
    }

    private void upgradeUsers() throws Exception {
        JSONArray users = this.userRepository.get(new Query()).getJSONArray("rslts");
        for (int i = 0; i < users.length(); ++i) {
            JSONObject user = users.getJSONObject(i);
            user.put("userURL", (Object)Latkes.getServePath());
            this.userRepository.update(user.optString(Keys.OBJECT_ID), user);
            LOGGER.log(Level.INFO, "Hashed user[name={0}] password.", new Object[]{user.optString("userName")});
        }
    }

    private void upgradeArticles() throws Exception {
        LOGGER.log(Level.INFO, "Adds a property [articleEditorType] to each of articles", new Object[0]);
        JSONArray articles = this.articleRepository.get(new Query()).getJSONArray("rslts");
        if (articles.length() <= 0) {
            LOGGER.log(Level.TRACE, "No articles", new Object[0]);
            return;
        }
        Transaction transaction = null;
        try {
            for (int i = 0; i < articles.length(); ++i) {
                if (0 == i % 50 || !transaction.isActive()) {
                    transaction = this.userRepository.beginTransaction();
                }
                JSONObject article = articles.getJSONObject(i);
                String articleId = article.optString(Keys.OBJECT_ID);
                LOGGER.log(Level.INFO, "Found an article[id={0}]", new Object[]{articleId});
                article.put("articleEditorType", (Object)"tinyMCE");
                this.articleRepository.update(article.getString(Keys.OBJECT_ID), article);
                if (0 != i % 50) continue;
                transaction.commit();
                LOGGER.log(Level.TRACE, "Updated some articles", new Object[0]);
            }
            if (transaction.isActive()) {
                transaction.commit();
            }
            LOGGER.log(Level.TRACE, "Updated all articles", new Object[0]);
        }
        catch (Exception e) {
            if (transaction.isActive()) {
                transaction.rollback();
            }
            throw e;
        }
    }

    private void notifyUserByEmail() throws ServiceException, JSONException, IOException {
        String adminEmail = this.preferenceQueryService.getPreference().getString("adminEmail");
        MailService.Message message = new MailService.Message();
        message.setFrom(adminEmail);
        message.addRecipient(adminEmail);
        message.setSubject(this.langPropsService.get("skipVersionMailSubject"));
        message.setHtmlBody(this.langPropsService.get("skipVersionMailBody"));
        MAIL_SVC.send(message);
        LOGGER.info("Send an email to the user who upgrades Solo with a discontinuous version.");
    }
}

