/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.solo.processor;

import java.io.IOException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.b3log.latke.Keys;
import org.b3log.latke.Latkes;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.service.LangPropsService;
import org.b3log.latke.service.ServiceException;
import org.b3log.latke.servlet.HTTPRequestContext;
import org.b3log.latke.servlet.HTTPRequestMethod;
import org.b3log.latke.servlet.annotation.RequestProcessing;
import org.b3log.latke.servlet.annotation.RequestProcessor;
import org.b3log.latke.servlet.renderer.AbstractHTTPResponseRenderer;
import org.b3log.latke.servlet.renderer.freemarker.FreeMarkerRenderer;
import org.b3log.latke.util.Paginator;
import org.b3log.latke.util.Requests;
import org.b3log.latke.util.Strings;
import org.b3log.solo.processor.util.Filler;
import org.b3log.solo.service.ArticleQueryService;
import org.b3log.solo.service.PreferenceQueryService;
import org.b3log.solo.service.StatisticMgmtService;
import org.b3log.solo.service.TagQueryService;
import org.b3log.solo.service.UserQueryService;
import org.b3log.solo.util.Skins;
import org.b3log.solo.util.comparator.Comparators;
import org.json.JSONException;
import org.json.JSONObject;

@RequestProcessor
public class TagProcessor {
    private static final Logger LOGGER = Logger.getLogger((String)TagProcessor.class.getName());
    @Inject
    private Filler filler;
    @Inject
    private LangPropsService langPropsService;
    @Inject
    private PreferenceQueryService preferenceQueryService;
    @Inject
    private ArticleQueryService articleQueryService;
    @Inject
    private UserQueryService userQueryService;
    @Inject
    private TagQueryService tagQueryService;
    @Inject
    private StatisticMgmtService statisticMgmtService;

    @RequestProcessing(value={"/tags/**"}, method={HTTPRequestMethod.GET})
    public void showTagArticles(HTTPRequestContext context) throws IOException {
        FreeMarkerRenderer renderer = new FreeMarkerRenderer();
        context.setRenderer((AbstractHTTPResponseRenderer)renderer);
        renderer.setTemplateName("tag-articles.ftl");
        Map dataModel = renderer.getDataModel();
        HttpServletRequest request = context.getRequest();
        HttpServletResponse response = context.getResponse();
        try {
            boolean hasMultipleUsers;
            String tagTitle;
            int currentPageNum;
            String requestURI = request.getRequestURI();
            if (!requestURI.endsWith("/")) {
                requestURI = requestURI + "/";
            }
            if (-1 == (currentPageNum = TagProcessor.getCurrentPageNum(requestURI, tagTitle = TagProcessor.getTagTitle(requestURI)))) {
                response.sendError(404);
                return;
            }
            LOGGER.log(Level.DEBUG, "Tag[title={0}, currentPageNum={1}]", new Object[]{tagTitle, currentPageNum});
            tagTitle = URLDecoder.decode(tagTitle, "UTF-8");
            JSONObject result = this.tagQueryService.getTagByTitle(tagTitle);
            if (null == result) {
                response.sendError(404);
                return;
            }
            JSONObject tag = result.getJSONObject("tag");
            String tagId = tag.getString(Keys.OBJECT_ID);
            JSONObject preference = this.preferenceQueryService.getPreference();
            Skins.fillLangs(preference.optString("localeString"), (String)request.getAttribute("templateDirName"), dataModel);
            int pageSize = preference.getInt("articleListDisplayCount");
            int windowSize = preference.getInt("articleListPaginationWindowSize");
            List<JSONObject> articles = this.articleQueryService.getArticlesByTag(tagId, currentPageNum, pageSize);
            if (articles.isEmpty()) {
                try {
                    response.sendError(404);
                    return;
                }
                catch (IOException ex) {
                    LOGGER.error(ex.getMessage());
                }
            }
            if (hasMultipleUsers = this.userQueryService.hasMultipleUsers()) {
                this.filler.setArticlesExProperties(request, articles, preference);
            } else {
                JSONObject author = this.articleQueryService.getAuthor(articles.get(0));
                this.filler.setArticlesExProperties(request, articles, author, preference);
            }
            int tagArticleCount = tag.getInt("tagPublishedRefCount");
            int pageCount = (int)Math.ceil((double)tagArticleCount / (double)pageSize);
            LOGGER.log(Level.TRACE, "Paginate tag-articles[currentPageNum={0}, pageSize={1}, pageCount={2}, windowSize={3}]", new Object[]{currentPageNum, pageSize, pageCount, windowSize});
            List pageNums = Paginator.paginate((int)currentPageNum, (int)pageSize, (int)pageCount, (int)windowSize);
            LOGGER.log(Level.TRACE, "tag-articles[pageNums={0}]", new Object[]{pageNums});
            Collections.sort(articles, Comparators.ARTICLE_CREATE_DATE_COMPARATOR);
            this.fillPagination(dataModel, pageCount, currentPageNum, articles, pageNums);
            dataModel.put("path", "/tags/" + URLEncoder.encode(tagTitle, "UTF-8"));
            dataModel.put(Keys.OBJECT_ID, tagId);
            dataModel.put("tag", tag);
            this.filler.fillSide(request, dataModel, preference);
            this.filler.fillBlogHeader(request, response, dataModel, preference);
            this.filler.fillBlogFooter(request, dataModel, preference);
            this.statisticMgmtService.incBlogViewCount(request, response);
        }
        catch (ServiceException e) {
            LOGGER.log(Level.ERROR, e.getMessage(), (Throwable)e);
            try {
                response.sendError(404);
            }
            catch (IOException ex) {
                LOGGER.error(ex.getMessage());
            }
        }
        catch (JSONException e) {
            LOGGER.log(Level.ERROR, e.getMessage(), (Throwable)e);
            try {
                response.sendError(404);
            }
            catch (IOException ex) {
                LOGGER.error(ex.getMessage());
            }
        }
    }

    private void fillPagination(Map<String, Object> dataModel, int pageCount, int currentPageNum, List<JSONObject> articles, List<Integer> pageNums) {
        String previousPageNum = Integer.toString(currentPageNum > 1 ? currentPageNum - 1 : 0);
        dataModel.put("paginationPreviousPageNum", "0".equals(previousPageNum) ? "" : previousPageNum);
        if (pageCount == currentPageNum + 1) {
            dataModel.put("paginationNextPageNum", "");
        } else {
            dataModel.put("paginationNextPageNum", currentPageNum + 1);
        }
        dataModel.put("articles", articles);
        dataModel.put("paginationCurrentPageNum", currentPageNum);
        dataModel.put("paginationFirstPageNum", pageNums.get(0));
        dataModel.put("paginationLastPageNum", pageNums.get(pageNums.size() - 1));
        dataModel.put("paginationPageCount", pageCount);
        dataModel.put("paginationPageNums", pageNums);
    }

    private static int getCurrentPageNum(String requestURI, String tagTitle) {
        if (Strings.isEmptyOrNull((String)tagTitle)) {
            return -1;
        }
        String pageNumString = requestURI.substring((Latkes.getContextPath() + "/tags/" + tagTitle + "/").length());
        return Requests.getCurrentPageNum((String)pageNumString);
    }

    private static String getTagTitle(String requestURI) {
        String path = requestURI.substring((Latkes.getContextPath() + "/tags/").length());
        if (path.contains("/")) {
            return path.substring(0, path.indexOf("/"));
        }
        return path.substring(0);
    }
}

