/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.solo.processor;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.Date;
import javax.inject.Inject;
import org.apache.commons.lang.time.DateFormatUtils;
import org.b3log.latke.Latkes;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.repository.Filter;
import org.b3log.latke.repository.FilterOperator;
import org.b3log.latke.repository.PropertyFilter;
import org.b3log.latke.repository.Query;
import org.b3log.latke.repository.SortDirection;
import org.b3log.latke.servlet.HTTPRequestContext;
import org.b3log.latke.servlet.HTTPRequestMethod;
import org.b3log.latke.servlet.annotation.RequestProcessing;
import org.b3log.latke.servlet.annotation.RequestProcessor;
import org.b3log.latke.servlet.renderer.AbstractHTTPResponseRenderer;
import org.b3log.latke.servlet.renderer.TextXMLRenderer;
import org.b3log.solo.model.sitemap.Sitemap;
import org.b3log.solo.model.sitemap.URL;
import org.b3log.solo.repository.ArchiveDateRepository;
import org.b3log.solo.repository.PageRepository;
import org.b3log.solo.repository.TagRepository;
import org.b3log.solo.repository.impl.ArticleRepositoryImpl;
import org.b3log.solo.service.PreferenceQueryService;
import org.json.JSONArray;
import org.json.JSONObject;

@RequestProcessor
public class SitemapProcessor {
    private static final Logger LOGGER = Logger.getLogger((String)SitemapProcessor.class.getName());
    @Inject
    private PreferenceQueryService preferenceQueryService;
    @Inject
    private ArticleRepositoryImpl articleRepository;
    @Inject
    private PageRepository pageRepository;
    @Inject
    private TagRepository tagRepository;
    @Inject
    private ArchiveDateRepository archiveDateRepository;

    @RequestProcessing(value={"/sitemap.xml"}, method={HTTPRequestMethod.GET})
    public void sitemap(HTTPRequestContext context) {
        TextXMLRenderer renderer = new TextXMLRenderer();
        context.setRenderer((AbstractHTTPResponseRenderer)renderer);
        Sitemap sitemap = new Sitemap();
        try {
            this.addArticles(sitemap);
            this.addNavigations(sitemap);
            this.addTags(sitemap);
            this.addArchives(sitemap);
            LOGGER.log(Level.INFO, "Generating sitemap....", new Object[0]);
            String content = sitemap.toString();
            LOGGER.log(Level.INFO, "Generated sitemap", new Object[0]);
            renderer.setContent(content);
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Get blog article feed error", (Throwable)e);
            try {
                context.getResponse().sendError(503);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private void addArticles(Sitemap sitemap) throws Exception {
        Query query = new Query().setCurrentPageNum(1).setFilter((Filter)new PropertyFilter("articleIsPublished", FilterOperator.EQUAL, (Object)true)).addSort("articleCreateDate", SortDirection.DESCENDING);
        JSONObject articleResult = this.articleRepository.get(query);
        JSONArray articles = articleResult.getJSONArray("rslts");
        for (int i = 0; i < articles.length(); ++i) {
            JSONObject article = articles.getJSONObject(i);
            String permalink = article.getString("articlePermalink");
            URL url = new URL();
            url.setLoc(Latkes.getServePath() + permalink);
            Date updateDate = (Date)article.get("articleUpdateDate");
            String lastMod = DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.format(updateDate);
            url.setLastMod(lastMod);
            sitemap.addURL(url);
        }
    }

    private void addNavigations(Sitemap sitemap) throws Exception {
        JSONObject result = this.pageRepository.get(new Query());
        JSONArray pages = result.getJSONArray("rslts");
        for (int i = 0; i < pages.length(); ++i) {
            JSONObject page = pages.getJSONObject(i);
            String permalink = page.getString("pagePermalink");
            URL url = new URL();
            if (!permalink.contains("://")) {
                url.setLoc(Latkes.getServePath() + permalink);
            } else {
                url.setLoc(permalink);
            }
            sitemap.addURL(url);
        }
    }

    private void addTags(Sitemap sitemap) throws Exception {
        JSONObject result = this.tagRepository.get(new Query());
        JSONArray tags = result.getJSONArray("rslts");
        for (int i = 0; i < tags.length(); ++i) {
            JSONObject tag = tags.getJSONObject(i);
            String link = URLEncoder.encode(tag.getString("tagTitle"), "UTF-8");
            URL url = new URL();
            url.setLoc(Latkes.getServePath() + "/tags/" + link);
            sitemap.addURL(url);
        }
        URL url = new URL();
        url.setLoc(Latkes.getServePath() + "/tags.html");
        sitemap.addURL(url);
    }

    private void addArchives(Sitemap sitemap) throws Exception {
        JSONObject result = this.archiveDateRepository.get(new Query());
        JSONArray archiveDates = result.getJSONArray("rslts");
        for (int i = 0; i < archiveDates.length(); ++i) {
            JSONObject archiveDate = archiveDates.getJSONObject(i);
            long time = archiveDate.getLong("archiveTime");
            String dateString = DateFormatUtils.format((long)time, (String)"yyyy/MM");
            URL url = new URL();
            url.setLoc(Latkes.getServePath() + "/archives/" + dateString);
            sitemap.addURL(url);
        }
    }
}

