/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.solo.processor;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.b3log.latke.Keys;
import org.b3log.latke.Latkes;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.service.LangPropsService;
import org.b3log.latke.servlet.HTTPRequestContext;
import org.b3log.latke.servlet.HTTPRequestMethod;
import org.b3log.latke.servlet.annotation.RequestProcessing;
import org.b3log.latke.servlet.annotation.RequestProcessor;
import org.b3log.latke.servlet.renderer.AbstractHTTPResponseRenderer;
import org.b3log.latke.servlet.renderer.freemarker.FreeMarkerRenderer;
import org.b3log.latke.util.Stopwatchs;
import org.b3log.solo.processor.util.Filler;
import org.b3log.solo.service.CommentQueryService;
import org.b3log.solo.service.PreferenceQueryService;
import org.b3log.solo.service.StatisticMgmtService;
import org.b3log.solo.util.Markdowns;
import org.b3log.solo.util.Skins;
import org.json.JSONObject;

@RequestProcessor
public class PageProcessor {
    private static final Logger LOGGER = Logger.getLogger((String)PageProcessor.class.getName());
    @Inject
    private LangPropsService langPropsService;
    @Inject
    private Filler filler;
    @Inject
    private PreferenceQueryService preferenceQueryService;
    @Inject
    private CommentQueryService commentQueryService;
    @Inject
    private StatisticMgmtService statisticMgmtService;

    @RequestProcessing(value={"/page"}, method={HTTPRequestMethod.GET})
    public void showPage(HTTPRequestContext context) {
        FreeMarkerRenderer renderer = new FreeMarkerRenderer();
        context.setRenderer((AbstractHTTPResponseRenderer)renderer);
        renderer.setTemplateName("page.ftl");
        Map dataModel = renderer.getDataModel();
        HttpServletRequest request = context.getRequest();
        HttpServletResponse response = context.getResponse();
        try {
            JSONObject preference = this.preferenceQueryService.getPreference();
            if (null == preference) {
                response.sendError(404);
                return;
            }
            Skins.fillLangs(preference.getString("localeString"), (String)request.getAttribute("templateDirName"), dataModel);
            Map langs = this.langPropsService.getAll(Latkes.getLocale());
            JSONObject page = (JSONObject)request.getAttribute("page");
            if (null == page) {
                response.sendError(404);
                return;
            }
            String pageId = page.getString(Keys.OBJECT_ID);
            page.put("commentable", preference.getBoolean("commentable") && page.getBoolean("pageCommentable"));
            page.put("permalink", (Object)page.getString("pagePermalink"));
            dataModel.put("page", page);
            List<JSONObject> comments = this.commentQueryService.getComments(pageId);
            dataModel.put("pageComments", comments);
            if ("CodeMirror-Markdown".equals(page.optString("pageEditorType"))) {
                Stopwatchs.start((String)("Markdown Page[id=" + page.optString(Keys.OBJECT_ID) + "]"));
                String content = page.optString("pageContent");
                page.put("pageContent", (Object)Markdowns.toHTML(content));
                Stopwatchs.end();
            }
            this.filler.fillSide(request, dataModel, preference);
            this.filler.fillBlogHeader(request, response, dataModel, preference);
            this.filler.fillBlogFooter(request, dataModel, preference);
            this.statisticMgmtService.incBlogViewCount(request, response);
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, e.getMessage(), (Throwable)e);
            try {
                response.sendError(404);
            }
            catch (IOException ex) {
                LOGGER.error(ex.getMessage());
            }
        }
    }
}

