/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.solo.processor;

import java.io.IOException;
import java.util.Calendar;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.b3log.latke.Keys;
import org.b3log.latke.Latkes;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.mail.MailService;
import org.b3log.latke.mail.MailServiceFactory;
import org.b3log.latke.repository.RepositoryException;
import org.b3log.latke.repository.Transaction;
import org.b3log.latke.service.LangPropsService;
import org.b3log.latke.service.ServiceException;
import org.b3log.latke.servlet.HTTPRequestContext;
import org.b3log.latke.servlet.HTTPRequestMethod;
import org.b3log.latke.servlet.annotation.RequestProcessing;
import org.b3log.latke.servlet.annotation.RequestProcessor;
import org.b3log.latke.servlet.renderer.AbstractHTTPResponseRenderer;
import org.b3log.latke.servlet.renderer.JSONRenderer;
import org.b3log.latke.user.UserService;
import org.b3log.latke.user.UserServiceFactory;
import org.b3log.latke.util.MD5;
import org.b3log.latke.util.Requests;
import org.b3log.latke.util.Sessions;
import org.b3log.latke.util.Strings;
import org.b3log.solo.processor.renderer.ConsoleRenderer;
import org.b3log.solo.processor.util.Filler;
import org.b3log.solo.repository.OptionRepository;
import org.b3log.solo.service.OptionMgmtService;
import org.b3log.solo.service.OptionQueryService;
import org.b3log.solo.service.PreferenceQueryService;
import org.b3log.solo.service.UserMgmtService;
import org.b3log.solo.service.UserQueryService;
import org.b3log.solo.util.Randoms;
import org.json.JSONException;
import org.json.JSONObject;

@RequestProcessor
public class LoginProcessor {
    private static final Logger LOGGER = Logger.getLogger((String)LoginProcessor.class.getName());
    @Inject
    private UserQueryService userQueryService;
    private UserService userService = UserServiceFactory.getUserService();
    private MailService mailService = MailServiceFactory.getMailService();
    @Inject
    private UserMgmtService userMgmtService;
    @Inject
    private LangPropsService langPropsService;
    @Inject
    private Filler filler;
    @Inject
    private PreferenceQueryService preferenceQueryService;
    @Inject
    private OptionQueryService optionQueryService;
    @Inject
    private OptionMgmtService optionMgmtService;
    @Inject
    private OptionRepository optionRepository;

    @RequestProcessing(value={"/login"}, method={HTTPRequestMethod.GET})
    public void showLogin(HTTPRequestContext context) throws Exception {
        HttpServletRequest request = context.getRequest();
        String destinationURL = request.getParameter("goto");
        if (Strings.isEmptyOrNull((String)destinationURL)) {
            destinationURL = Latkes.getServePath() + "/admin-index.do#main";
        }
        HttpServletResponse response = context.getResponse();
        this.userMgmtService.tryLogInWithCookie(request, response);
        if (null != this.userService.getCurrentUser(request)) {
            response.sendRedirect(destinationURL);
            return;
        }
        this.renderPage(context, "login.ftl", destinationURL, request);
    }

    @RequestProcessing(value={"/login"}, method={HTTPRequestMethod.POST})
    public void login(HTTPRequestContext context) {
        HttpServletRequest request = context.getRequest();
        JSONRenderer renderer = new JSONRenderer();
        context.setRenderer((AbstractHTTPResponseRenderer)renderer);
        JSONObject jsonObject = new JSONObject();
        renderer.setJSONObject(jsonObject);
        try {
            jsonObject.put("isLoggedIn", false);
            String loginFailLabel = this.langPropsService.get("loginFailLabel");
            jsonObject.put("msg", (Object)loginFailLabel);
            JSONObject requestJSONObject = Requests.parseRequestJSONObject((HttpServletRequest)request, (HttpServletResponse)context.getResponse());
            String userEmail = requestJSONObject.getString("userEmail");
            String userPwd = requestJSONObject.getString("userPassword");
            if (Strings.isEmptyOrNull((String)userEmail) || Strings.isEmptyOrNull((String)userPwd)) {
                return;
            }
            LOGGER.log(Level.INFO, "Login[email={0}]", new Object[]{userEmail});
            JSONObject user = this.userQueryService.getUserByEmail(userEmail);
            if (null == user) {
                LOGGER.log(Level.WARN, "Not found user[email={0}]", new Object[]{userEmail});
                return;
            }
            if (MD5.hash((String)userPwd).equals(user.getString("userPassword"))) {
                Sessions.login((HttpServletRequest)request, (HttpServletResponse)context.getResponse(), (JSONObject)user);
                LOGGER.log(Level.INFO, "Logged in[email={0}]", new Object[]{userEmail});
                jsonObject.put("isLoggedIn", true);
                if ("visitorRole".equals(user.optString("userRole"))) {
                    jsonObject.put("to", (Object)Latkes.getServePath());
                } else {
                    jsonObject.put("to", (Object)(Latkes.getServePath() + "/admin-index.do#main"));
                }
                jsonObject.remove("msg");
                return;
            }
            LOGGER.log(Level.WARN, "Wrong password[{0}]", new Object[]{userPwd});
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, e.getMessage(), (Throwable)e);
        }
    }

    @RequestProcessing(value={"/logout"}, method={HTTPRequestMethod.GET})
    public void logout(HTTPRequestContext context) throws IOException {
        HttpServletRequest httpServletRequest = context.getRequest();
        Sessions.logout((HttpServletRequest)httpServletRequest, (HttpServletResponse)context.getResponse());
        String destinationURL = httpServletRequest.getParameter("goto");
        if (Strings.isEmptyOrNull((String)destinationURL)) {
            destinationURL = "/";
        }
        context.getResponse().sendRedirect(destinationURL);
    }

    @RequestProcessing(value={"/forgot"}, method={HTTPRequestMethod.GET})
    public void showForgot(HTTPRequestContext context) throws Exception {
        HttpServletRequest request = context.getRequest();
        String destinationURL = request.getParameter("goto");
        if (Strings.isEmptyOrNull((String)destinationURL)) {
            destinationURL = Latkes.getServePath() + "/admin-index.do#main";
        }
        this.renderPage(context, "reset-pwd.ftl", destinationURL, request);
    }

    @RequestProcessing(value={"/forgot"}, method={HTTPRequestMethod.POST})
    public void forgot(HTTPRequestContext context) {
        HttpServletRequest request = context.getRequest();
        JSONRenderer renderer = new JSONRenderer();
        context.setRenderer((AbstractHTTPResponseRenderer)renderer);
        JSONObject jsonObject = new JSONObject();
        renderer.setJSONObject(jsonObject);
        try {
            jsonObject.put("succeed", false);
            jsonObject.put("msg", (Object)this.langPropsService.get("resetPwdSuccessMsg"));
            JSONObject requestJSONObject = Requests.parseRequestJSONObject((HttpServletRequest)request, (HttpServletResponse)context.getResponse());
            String userEmail = requestJSONObject.getString("userEmail");
            if (Strings.isEmptyOrNull((String)userEmail)) {
                LOGGER.log(Level.WARN, "Why user's email is empty", new Object[0]);
                return;
            }
            LOGGER.log(Level.INFO, "Login[email={0}]", new Object[]{userEmail});
            JSONObject user = this.userQueryService.getUserByEmail(userEmail);
            if (null == user) {
                LOGGER.log(Level.WARN, "Not found user[email={0}]", new Object[]{userEmail});
                jsonObject.put("msg", (Object)this.langPropsService.get("userEmailNotFoundMsg"));
                return;
            }
            this.sendResetUrl(userEmail, jsonObject);
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, e.getMessage(), (Throwable)e);
        }
    }

    @RequestProcessing(value={"/reset"}, method={HTTPRequestMethod.POST})
    public void reset(HTTPRequestContext context) {
        HttpServletRequest request = context.getRequest();
        JSONRenderer renderer = new JSONRenderer();
        context.setRenderer((AbstractHTTPResponseRenderer)renderer);
        JSONObject jsonObject = new JSONObject();
        renderer.setJSONObject(jsonObject);
        try {
            JSONObject requestJSONObject = Requests.parseRequestJSONObject((HttpServletRequest)request, (HttpServletResponse)context.getResponse());
            String userEmail = requestJSONObject.getString("userEmail");
            String newPwd = requestJSONObject.getString("newPwd");
            JSONObject user = this.userQueryService.getUserByEmail(userEmail);
            user.put("userPassword", (Object)newPwd);
            this.userMgmtService.updateUser(user);
            LOGGER.log(Level.DEBUG, "[{0}]'s password updated successfully.", new Object[]{userEmail});
            jsonObject.put("succeed", true);
            jsonObject.put("to", (Object)(Latkes.getServePath() + "/login?from=reset"));
            jsonObject.put("msg", (Object)this.langPropsService.get("resetPwdSuccessMsg"));
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, e.getMessage(), (Throwable)e);
        }
    }

    private boolean isPwdExpired() {
        return false;
    }

    private void sendResetUrl(String userEmail, JSONObject jsonObject) throws JSONException, ServiceException, IOException, RepositoryException {
        JSONObject preference = this.preferenceQueryService.getPreference();
        String token = new Randoms().nextStringWithMD5();
        String adminEmail = preference.getString("adminEmail");
        String mailSubject = this.langPropsService.get("resetPwdMailSubject");
        String mailBody = this.langPropsService.get("resetPwdMailBody") + " " + Latkes.getServePath() + "/forgot?token=" + token + "&login=" + userEmail;
        MailService.Message message = new MailService.Message();
        JSONObject option = new JSONObject();
        option.put(Keys.OBJECT_ID, (Object)token);
        option.put("optionCategory", (Object)"passwordReset");
        option.put("optionValue", System.currentTimeMillis());
        Transaction transaction = this.optionRepository.beginTransaction();
        this.optionRepository.add(option);
        transaction.commit();
        message.setFrom(adminEmail);
        message.addRecipient(userEmail);
        message.setSubject(mailSubject);
        message.setHtmlBody(mailBody);
        this.mailService.send(message);
        jsonObject.put("succeed", true);
        jsonObject.put("to", (Object)(Latkes.getServePath() + "/login?from=forgot"));
        jsonObject.put("msg", (Object)this.langPropsService.get("resetPwdSuccessSend"));
        LOGGER.log(Level.DEBUG, "Sent a mail[mailSubject={0}, mailBody=[{1}] to [{2}]", new Object[]{mailSubject, mailBody, userEmail});
    }

    private void renderPage(HTTPRequestContext context, String pageTemplate, String destinationURL, HttpServletRequest request) throws JSONException, ServiceException {
        ConsoleRenderer renderer = new ConsoleRenderer();
        renderer.setTemplateName(pageTemplate);
        context.setRenderer((AbstractHTTPResponseRenderer)renderer);
        Map dataModel = renderer.getDataModel();
        Map langs = this.langPropsService.getAll(Latkes.getLocale());
        JSONObject preference = this.preferenceQueryService.getPreference();
        dataModel.putAll(langs);
        dataModel.put("goto", destinationURL);
        dataModel.put("year", String.valueOf(Calendar.getInstance().get(1)));
        dataModel.put("version", "1.0.0");
        dataModel.put("staticResourceVersion", Latkes.getStaticResourceVersion());
        dataModel.put("blogTitle", preference.getString("blogTitle"));
        String token = request.getParameter("token");
        String email = request.getParameter("login");
        JSONObject tokenObj = this.optionQueryService.getOptionById(token);
        if (tokenObj == null) {
            dataModel.put("inputType", "email");
        } else {
            dataModel.put("inputType", "password");
            dataModel.put("userEmailHidden", email);
        }
        String from = request.getParameter("from");
        if ("forgot".equals(from)) {
            dataModel.put("resetMsg", this.langPropsService.get("resetPwdSuccessSend"));
        } else if ("reset".equals(from)) {
            dataModel.put("resetMsg", this.langPropsService.get("resetPwdSuccessMsg"));
        } else {
            dataModel.put("resetMsg", "");
        }
        Keys.fillRuntime((Map)dataModel);
        this.filler.fillMinified(dataModel);
    }
}

