/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.solo.processor;

import java.util.Calendar;
import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.b3log.latke.Keys;
import org.b3log.latke.Latkes;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.service.LangPropsService;
import org.b3log.latke.servlet.HTTPRequestContext;
import org.b3log.latke.servlet.HTTPRequestMethod;
import org.b3log.latke.servlet.annotation.RequestProcessing;
import org.b3log.latke.servlet.annotation.RequestProcessor;
import org.b3log.latke.servlet.renderer.AbstractHTTPResponseRenderer;
import org.b3log.latke.servlet.renderer.JSONRenderer;
import org.b3log.latke.util.Locales;
import org.b3log.latke.util.Requests;
import org.b3log.latke.util.Sessions;
import org.b3log.latke.util.Strings;
import org.b3log.solo.processor.renderer.ConsoleRenderer;
import org.b3log.solo.processor.util.Filler;
import org.b3log.solo.service.InitService;
import org.b3log.solo.util.QueryResults;
import org.json.JSONObject;

@RequestProcessor
public class InitProcessor {
    private static final Logger LOGGER = Logger.getLogger((String)InitProcessor.class.getName());
    @Inject
    private InitService initService;
    @Inject
    private Filler filler;
    @Inject
    private LangPropsService langPropsService;
    public static final int MAX_USER_NAME_LENGTH = 20;
    public static final int MIN_USER_NAME_LENGTH = 1;

    @RequestProcessing(value={"/init"}, method={HTTPRequestMethod.GET})
    public void showInit(HTTPRequestContext context, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.initService.isInited()) {
            response.sendRedirect("/");
            return;
        }
        ConsoleRenderer renderer = new ConsoleRenderer();
        renderer.setTemplateName("init.ftl");
        context.setRenderer((AbstractHTTPResponseRenderer)renderer);
        Map dataModel = renderer.getDataModel();
        Map langs = this.langPropsService.getAll(Locales.getLocale((HttpServletRequest)request));
        dataModel.putAll(langs);
        dataModel.put("version", "1.0.0");
        dataModel.put("staticResourceVersion", Latkes.getStaticResourceVersion());
        dataModel.put("year", String.valueOf(Calendar.getInstance().get(1)));
        Keys.fillRuntime((Map)dataModel);
        this.filler.fillMinified(dataModel);
    }

    @RequestProcessing(value={"/init"}, method={HTTPRequestMethod.POST})
    public void initSolo(HTTPRequestContext context, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.initService.isInited()) {
            response.sendRedirect("/");
            return;
        }
        JSONRenderer renderer = new JSONRenderer();
        context.setRenderer((AbstractHTTPResponseRenderer)renderer);
        JSONObject ret = QueryResults.defaultResult();
        renderer.setJSONObject(ret);
        try {
            JSONObject requestJSONObject = Requests.parseRequestJSONObject((HttpServletRequest)request, (HttpServletResponse)response);
            String userName = requestJSONObject.optString("userName");
            String userEmail = requestJSONObject.optString("userEmail");
            String userPassword = requestJSONObject.optString("userPassword");
            if (Strings.isEmptyOrNull((String)userName) || Strings.isEmptyOrNull((String)userEmail) || Strings.isEmptyOrNull((String)userPassword) || !Strings.isEmail((String)userEmail)) {
                ret.put("msg", (Object)"Init failed, please check your input");
                return;
            }
            if (InitProcessor.invalidUserName(userName)) {
                ret.put("msg", (Object)"Init failed, please check your input [username: length [1, 20], content {a-z, A-Z, 0-9}]");
                return;
            }
            Locale locale = Locales.getLocale((HttpServletRequest)request);
            requestJSONObject.put("locale", (Object)locale.toString());
            this.initService.init(requestJSONObject);
            JSONObject admin = new JSONObject();
            admin.put("userName", (Object)requestJSONObject.getString("userName"));
            admin.put("userEmail", (Object)requestJSONObject.getString("userEmail"));
            admin.put("userRole", (Object)"adminRole");
            admin.put("userPassword", (Object)requestJSONObject.getString("userPassword"));
            Sessions.login((HttpServletRequest)request, (HttpServletResponse)response, (JSONObject)admin);
            ret.put("sc", true);
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, e.getMessage(), (Throwable)e);
            ret.put("msg", (Object)e.getMessage());
        }
    }

    public static boolean invalidUserName(String name) {
        int length = name.length();
        if (length < 1 || length > 20) {
            return true;
        }
        for (int i = 0; i < length; ++i) {
            char c = name.charAt(i);
            if ('a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || '0' <= c && c <= '9') continue;
            return true;
        }
        return false;
    }
}

