/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.solo.processor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringEscapeUtils;
import org.b3log.latke.Keys;
import org.b3log.latke.Latkes;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.repository.CompositeFilter;
import org.b3log.latke.repository.CompositeFilterOperator;
import org.b3log.latke.repository.Filter;
import org.b3log.latke.repository.FilterOperator;
import org.b3log.latke.repository.PropertyFilter;
import org.b3log.latke.repository.Query;
import org.b3log.latke.repository.SortDirection;
import org.b3log.latke.servlet.HTTPRequestContext;
import org.b3log.latke.servlet.HTTPRequestMethod;
import org.b3log.latke.servlet.annotation.RequestProcessing;
import org.b3log.latke.servlet.annotation.RequestProcessor;
import org.b3log.latke.servlet.renderer.AbstractHTTPResponseRenderer;
import org.b3log.latke.servlet.renderer.AtomRenderer;
import org.b3log.latke.servlet.renderer.RssRenderer;
import org.b3log.latke.util.Locales;
import org.b3log.latke.util.Strings;
import org.b3log.solo.model.feed.atom.Category;
import org.b3log.solo.model.feed.atom.Entry;
import org.b3log.solo.model.feed.atom.Feed;
import org.b3log.solo.model.feed.rss.Channel;
import org.b3log.solo.model.feed.rss.Item;
import org.b3log.solo.repository.ArticleRepository;
import org.b3log.solo.repository.TagArticleRepository;
import org.b3log.solo.repository.TagRepository;
import org.b3log.solo.service.ArticleQueryService;
import org.b3log.solo.service.PreferenceQueryService;
import org.b3log.solo.service.UserQueryService;
import org.json.JSONArray;
import org.json.JSONObject;

@RequestProcessor
public class FeedProcessor {
    private static final Logger LOGGER = Logger.getLogger((String)FeedProcessor.class.getName());
    @Inject
    private ArticleQueryService articleQueryService;
    @Inject
    private ArticleRepository articleRepository;
    @Inject
    private PreferenceQueryService preferenceQueryService;
    @Inject
    private UserQueryService userQueryService;
    @Inject
    private TagRepository tagRepository;
    @Inject
    private TagArticleRepository tagArticleRepository;

    @RequestProcessing(value={"/blog-articles-feed.do"}, method={HTTPRequestMethod.GET, HTTPRequestMethod.HEAD})
    public void blogArticlesAtom(HTTPRequestContext context) {
        AtomRenderer renderer = new AtomRenderer();
        context.setRenderer((AbstractHTTPResponseRenderer)renderer);
        Feed feed = new Feed();
        try {
            JSONObject preference = this.preferenceQueryService.getPreference();
            String blogTitle = preference.getString("blogTitle");
            String blogSubtitle = preference.getString("blogSubtitle");
            int outputCnt = preference.getInt("feedOutputCnt");
            feed.setTitle(StringEscapeUtils.escapeXml((String)blogTitle));
            feed.setSubtitle(StringEscapeUtils.escapeXml((String)blogSubtitle));
            feed.setUpdated(new Date());
            feed.setAuthor(StringEscapeUtils.escapeXml((String)blogTitle));
            feed.setLink(Latkes.getServePath() + "/blog-articles-feed.do");
            feed.setId(Latkes.getServePath() + "/");
            ArrayList<PropertyFilter> filters = new ArrayList<PropertyFilter>();
            filters.add(new PropertyFilter("articleIsPublished", FilterOperator.EQUAL, (Object)true));
            filters.add(new PropertyFilter("articleViewPwd", FilterOperator.EQUAL, (Object)""));
            Query query = new Query().setCurrentPageNum(1).setPageSize(outputCnt).setFilter((Filter)new CompositeFilter(CompositeFilterOperator.AND, filters)).addSort("articleUpdateDate", SortDirection.DESCENDING).setPageCount(1);
            boolean hasMultipleUsers = this.userQueryService.hasMultipleUsers();
            String authorName = "";
            JSONObject articleResult = this.articleRepository.get(query);
            JSONArray articles = articleResult.getJSONArray("rslts");
            if (!hasMultipleUsers && 0 != articles.length()) {
                authorName = this.articleQueryService.getAuthor(articles.getJSONObject(0)).getString("userName");
            }
            boolean isFullContent = "fullContent".equals(preference.getString("feedOutputMode"));
            for (int i = 0; i < articles.length(); ++i) {
                JSONObject article = articles.getJSONObject(i);
                Entry entry = new Entry();
                feed.addEntry(entry);
                String title = StringEscapeUtils.escapeXml((String)article.getString("articleTitle"));
                entry.setTitle(title);
                String summary = isFullContent ? StringEscapeUtils.escapeXml((String)article.getString("articleContent")) : StringEscapeUtils.escapeXml((String)article.optString("articleAbstract"));
                entry.setSummary(summary);
                Date updated = (Date)article.get("articleUpdateDate");
                entry.setUpdated(updated);
                String link = Latkes.getServePath() + article.getString("articlePermalink");
                entry.setLink(link);
                entry.setId(link);
                if (hasMultipleUsers) {
                    authorName = StringEscapeUtils.escapeXml((String)this.articleQueryService.getAuthor(article).getString("userName"));
                }
                entry.setAuthor(authorName);
                String tagsString = article.getString("articleTags");
                String[] tagStrings = tagsString.split(",");
                for (int j = 0; j < tagStrings.length; ++j) {
                    Category catetory = new Category();
                    entry.addCatetory(catetory);
                    String tag = tagStrings[j];
                    catetory.setTerm(tag);
                }
            }
            renderer.setContent(feed.toString());
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Get blog article feed error", (Throwable)e);
            try {
                context.getResponse().sendError(503);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    @RequestProcessing(value={"/tag-articles-feed.do"}, method={HTTPRequestMethod.GET, HTTPRequestMethod.HEAD})
    public void tagArticlesAtom(HTTPRequestContext context) throws IOException {
        AtomRenderer renderer = new AtomRenderer();
        context.setRenderer((AbstractHTTPResponseRenderer)renderer);
        HttpServletRequest request = context.getRequest();
        HttpServletResponse response = context.getResponse();
        String queryString = request.getQueryString();
        if (Strings.isEmptyOrNull((String)queryString)) {
            response.sendError(400);
            return;
        }
        String oIdMap = queryString.split("&")[0];
        String tagId = oIdMap.split("=")[1];
        Feed feed = new Feed();
        try {
            JSONObject tag = this.tagRepository.get(tagId);
            if (null == tag) {
                response.sendError(404);
                return;
            }
            String tagTitle = tag.getString("tagTitle");
            JSONObject preference = this.preferenceQueryService.getPreference();
            if (null == preference) {
                response.sendError(404);
                return;
            }
            String blogTitle = preference.getString("blogTitle");
            String blogSubtitle = preference.getString("blogSubtitle") + ", " + tagTitle;
            int outputCnt = preference.getInt("feedOutputCnt");
            feed.setTitle(StringEscapeUtils.escapeXml((String)blogTitle));
            feed.setSubtitle(StringEscapeUtils.escapeXml((String)blogSubtitle));
            feed.setUpdated(new Date());
            feed.setAuthor(StringEscapeUtils.escapeXml((String)blogTitle));
            feed.setLink(Latkes.getServePath() + "/tag-articles-feed.do");
            feed.setId(Latkes.getServePath() + "/");
            JSONObject tagArticleResult = this.tagArticleRepository.getByTagId(tagId, 1, outputCnt);
            JSONArray tagArticleRelations = tagArticleResult.getJSONArray("rslts");
            if (0 == tagArticleRelations.length()) {
                response.sendError(404);
                return;
            }
            ArrayList<JSONObject> articles = new ArrayList<JSONObject>();
            for (int i = 0; i < tagArticleRelations.length(); ++i) {
                JSONObject tagArticleRelation = tagArticleRelations.getJSONObject(i);
                String articleId = tagArticleRelation.getString("article_" + Keys.OBJECT_ID);
                JSONObject article = this.articleRepository.get(articleId);
                if (!article.getBoolean("articleIsPublished") || !Strings.isEmptyOrNull((String)article.optString("articleViewPwd"))) continue;
                articles.add(article);
            }
            boolean hasMultipleUsers = this.userQueryService.hasMultipleUsers();
            String authorName = "";
            if (!hasMultipleUsers && !articles.isEmpty()) {
                authorName = this.articleQueryService.getAuthor((JSONObject)articles.get(0)).getString("userName");
            }
            boolean isFullContent = "fullContent".equals(preference.getString("feedOutputMode"));
            for (int i = 0; i < articles.size(); ++i) {
                JSONObject article = (JSONObject)articles.get(i);
                Entry entry = new Entry();
                feed.addEntry(entry);
                String title = StringEscapeUtils.escapeXml((String)article.getString("articleTitle"));
                entry.setTitle(title);
                String summary = isFullContent ? StringEscapeUtils.escapeXml((String)article.getString("articleContent")) : StringEscapeUtils.escapeXml((String)article.optString("articleAbstract"));
                entry.setSummary(summary);
                Date updated = (Date)article.get("articleUpdateDate");
                entry.setUpdated(updated);
                String link = Latkes.getServePath() + article.getString("articlePermalink");
                entry.setLink(link);
                entry.setId(link);
                if (hasMultipleUsers) {
                    authorName = StringEscapeUtils.escapeXml((String)this.articleQueryService.getAuthor(article).getString("userName"));
                }
                entry.setAuthor(authorName);
                String tagsString = article.getString("articleTags");
                String[] tagStrings = tagsString.split(",");
                for (int j = 0; j < tagStrings.length; ++j) {
                    Category catetory = new Category();
                    entry.addCatetory(catetory);
                    catetory.setTerm(tagStrings[j]);
                }
            }
            renderer.setContent(feed.toString());
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Get tag article feed error", (Throwable)e);
            try {
                context.getResponse().sendError(503);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    @RequestProcessing(value={"/blog-articles-rss.do"}, method={HTTPRequestMethod.GET, HTTPRequestMethod.HEAD})
    public void blogArticlesRSS(HTTPRequestContext context) {
        HttpServletResponse response = context.getResponse();
        RssRenderer renderer = new RssRenderer();
        context.setRenderer((AbstractHTTPResponseRenderer)renderer);
        Channel channel = new Channel();
        try {
            JSONObject preference = this.preferenceQueryService.getPreference();
            if (null == preference) {
                response.sendError(404);
                return;
            }
            String blogTitle = preference.getString("blogTitle");
            String blogSubtitle = preference.getString("blogSubtitle");
            int outputCnt = preference.getInt("feedOutputCnt");
            channel.setTitle(StringEscapeUtils.escapeXml((String)blogTitle));
            channel.setLastBuildDate(new Date());
            channel.setLink(Latkes.getServePath());
            channel.setAtomLink(Latkes.getServePath() + "/blog-articles-rss.do");
            channel.setGenerator("Solo, ver 1.0.0");
            String localeString = preference.getString("localeString");
            String country = Locales.getCountry((String)localeString).toLowerCase();
            String language = Locales.getLanguage((String)localeString).toLowerCase();
            channel.setLanguage(language + '-' + country);
            channel.setDescription(blogSubtitle);
            ArrayList<PropertyFilter> filters = new ArrayList<PropertyFilter>();
            filters.add(new PropertyFilter("articleIsPublished", FilterOperator.EQUAL, (Object)true));
            filters.add(new PropertyFilter("articleViewPwd", FilterOperator.EQUAL, (Object)""));
            Query query = new Query().setCurrentPageNum(1).setPageSize(outputCnt).setFilter((Filter)new CompositeFilter(CompositeFilterOperator.AND, filters)).addSort("articleUpdateDate", SortDirection.DESCENDING).setPageCount(1);
            JSONObject articleResult = this.articleRepository.get(query);
            JSONArray articles = articleResult.getJSONArray("rslts");
            boolean hasMultipleUsers = this.userQueryService.hasMultipleUsers();
            String authorName = "";
            if (!hasMultipleUsers && 0 != articles.length()) {
                authorName = this.articleQueryService.getAuthor(articles.getJSONObject(0)).getString("userName");
            }
            boolean isFullContent = "fullContent".equals(preference.getString("feedOutputMode"));
            for (int i = 0; i < articles.length(); ++i) {
                JSONObject article = articles.getJSONObject(i);
                Item item = new Item();
                channel.addItem(item);
                String title = StringEscapeUtils.escapeXml((String)article.getString("articleTitle"));
                item.setTitle(title);
                String description = isFullContent ? StringEscapeUtils.escapeXml((String)article.getString("articleContent")) : StringEscapeUtils.escapeXml((String)article.optString("articleAbstract"));
                item.setDescription(description);
                Date pubDate = (Date)article.get("articleUpdateDate");
                item.setPubDate(pubDate);
                String link = Latkes.getServePath() + article.getString("articlePermalink");
                item.setLink(link);
                item.setGUID(link);
                String authorEmail = article.getString("articleAuthorEmail");
                if (hasMultipleUsers) {
                    authorName = StringEscapeUtils.escapeXml((String)this.articleQueryService.getAuthor(article).getString("userName"));
                }
                item.setAuthor(authorEmail + "(" + authorName + ")");
                String tagsString = article.getString("articleTags");
                String[] tagStrings = tagsString.split(",");
                for (int j = 0; j < tagStrings.length; ++j) {
                    org.b3log.solo.model.feed.rss.Category catetory = new org.b3log.solo.model.feed.rss.Category();
                    item.addCatetory(catetory);
                    String tag = tagStrings[j];
                    catetory.setTerm(tag);
                }
            }
            renderer.setContent(channel.toString());
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Get blog article rss error", (Throwable)e);
            try {
                context.getResponse().sendError(503);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    @RequestProcessing(value={"/tag-articles-rss.do"}, method={HTTPRequestMethod.GET, HTTPRequestMethod.HEAD})
    public void tagArticlesRSS(HTTPRequestContext context) throws IOException {
        HttpServletResponse response = context.getResponse();
        HttpServletRequest request = context.getRequest();
        RssRenderer renderer = new RssRenderer();
        context.setRenderer((AbstractHTTPResponseRenderer)renderer);
        String queryString = request.getQueryString();
        if (Strings.isEmptyOrNull((String)queryString)) {
            response.sendError(400);
            return;
        }
        String oIdMap = queryString.split("&")[0];
        String tagId = oIdMap.split("=")[1];
        Channel channel = new Channel();
        try {
            JSONObject tag = this.tagRepository.get(tagId);
            if (null == tag) {
                response.sendError(404);
                return;
            }
            String tagTitle = tag.getString("tagTitle");
            JSONObject preference = this.preferenceQueryService.getPreference();
            if (null == preference) {
                response.sendError(404);
                return;
            }
            String blogTitle = preference.getString("blogTitle");
            String blogSubtitle = preference.getString("blogSubtitle") + ", " + tagTitle;
            int outputCnt = preference.getInt("feedOutputCnt");
            channel.setTitle(StringEscapeUtils.escapeXml((String)blogTitle));
            channel.setLastBuildDate(new Date());
            channel.setLink(Latkes.getServePath());
            channel.setAtomLink(Latkes.getServePath() + "/tag-articles-rss.do");
            channel.setGenerator("Solo, ver 1.0.0");
            String localeString = preference.getString("localeString");
            String country = Locales.getCountry((String)localeString).toLowerCase();
            String language = Locales.getLanguage((String)localeString).toLowerCase();
            channel.setLanguage(language + '-' + country);
            channel.setDescription(blogSubtitle);
            JSONObject tagArticleResult = this.tagArticleRepository.getByTagId(tagId, 1, outputCnt);
            JSONArray tagArticleRelations = tagArticleResult.getJSONArray("rslts");
            if (0 == tagArticleRelations.length()) {
                response.sendError(404);
                return;
            }
            ArrayList<JSONObject> articles = new ArrayList<JSONObject>();
            for (int i = 0; i < tagArticleRelations.length(); ++i) {
                JSONObject tagArticleRelation = tagArticleRelations.getJSONObject(i);
                String articleId = tagArticleRelation.getString("article_" + Keys.OBJECT_ID);
                JSONObject article = this.articleRepository.get(articleId);
                if (!article.getBoolean("articleIsPublished") || !Strings.isEmptyOrNull((String)article.optString("articleViewPwd"))) continue;
                articles.add(article);
            }
            boolean hasMultipleUsers = this.userQueryService.hasMultipleUsers();
            String authorName = "";
            if (!hasMultipleUsers && !articles.isEmpty()) {
                authorName = this.articleQueryService.getAuthor((JSONObject)articles.get(0)).getString("userName");
            }
            boolean isFullContent = "fullContent".equals(preference.getString("feedOutputMode"));
            for (int i = 0; i < articles.size(); ++i) {
                JSONObject article = (JSONObject)articles.get(i);
                Item item = new Item();
                channel.addItem(item);
                String title = StringEscapeUtils.escapeXml((String)article.getString("articleTitle"));
                item.setTitle(title);
                String description = isFullContent ? StringEscapeUtils.escapeXml((String)article.getString("articleContent")) : StringEscapeUtils.escapeXml((String)article.optString("articleAbstract"));
                item.setDescription(description);
                Date pubDate = (Date)article.get("articleUpdateDate");
                item.setPubDate(pubDate);
                String link = Latkes.getServePath() + article.getString("articlePermalink");
                item.setLink(link);
                item.setGUID(link);
                String authorEmail = article.getString("articleAuthorEmail");
                if (hasMultipleUsers) {
                    authorName = StringEscapeUtils.escapeXml((String)this.articleQueryService.getAuthor(article).getString("userName"));
                }
                item.setAuthor(authorEmail + "(" + authorName + ")");
                String tagsString = article.getString("articleTags");
                String[] tagStrings = tagsString.split(",");
                for (int j = 0; j < tagStrings.length; ++j) {
                    org.b3log.solo.model.feed.rss.Category catetory = new org.b3log.solo.model.feed.rss.Category();
                    item.addCatetory(catetory);
                    catetory.setTerm(tagStrings[j]);
                }
            }
            renderer.setContent(channel.toString());
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Get tag article rss error", (Throwable)e);
            try {
                context.getResponse().sendError(503);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

