/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.solo.processor;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.service.LangPropsService;
import org.b3log.latke.servlet.HTTPRequestContext;
import org.b3log.latke.servlet.HTTPRequestMethod;
import org.b3log.latke.servlet.annotation.RequestProcessing;
import org.b3log.latke.servlet.annotation.RequestProcessor;
import org.b3log.latke.servlet.renderer.AbstractHTTPResponseRenderer;
import org.b3log.latke.user.UserService;
import org.b3log.latke.user.UserServiceFactory;
import org.b3log.latke.util.Locales;
import org.b3log.solo.processor.ArticleProcessor;
import org.b3log.solo.processor.renderer.ConsoleRenderer;
import org.b3log.solo.processor.util.Filler;
import org.b3log.solo.service.PreferenceQueryService;
import org.json.JSONObject;

@RequestProcessor
public class ErrorProcessor {
    private static final Logger LOGGER = Logger.getLogger((String)ArticleProcessor.class.getName());
    @Inject
    private Filler filler;
    @Inject
    private PreferenceQueryService preferenceQueryService;
    @Inject
    private LangPropsService langPropsService;
    private static UserService userService = UserServiceFactory.getUserService();

    @RequestProcessing(value={"/error/*.html"}, method={HTTPRequestMethod.GET})
    public void showErrorPage(HTTPRequestContext context, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String requestURI = request.getRequestURI();
        String templateName = StringUtils.substringAfterLast((String)requestURI, (String)"/");
        templateName = StringUtils.substringBefore((String)templateName, (String)".") + ".ftl";
        LOGGER.log(Level.DEBUG, "Shows error page[requestURI={0}, templateName={1}]", new Object[]{requestURI, templateName});
        ConsoleRenderer renderer = new ConsoleRenderer();
        context.setRenderer((AbstractHTTPResponseRenderer)renderer);
        renderer.setTemplateName("error" + File.separatorChar + templateName);
        Map dataModel = renderer.getDataModel();
        try {
            Map langs = this.langPropsService.getAll(Locales.getLocale((HttpServletRequest)request));
            dataModel.putAll(langs);
            JSONObject preference = this.preferenceQueryService.getPreference();
            this.filler.fillBlogHeader(request, response, dataModel, preference);
            this.filler.fillBlogFooter(request, dataModel, preference);
            dataModel.put("loginURL", userService.createLoginURL("/admin-index.do#main"));
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, e.getMessage(), (Throwable)e);
            try {
                response.sendError(404);
            }
            catch (IOException ex) {
                LOGGER.error(ex.getMessage());
            }
        }
    }
}

