/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.solo.processor;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Random;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.io.IOUtils;
import org.b3log.latke.Latkes;
import org.b3log.latke.RuntimeEnv;
import org.b3log.latke.image.Image;
import org.b3log.latke.image.ImageService;
import org.b3log.latke.image.ImageServiceFactory;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.servlet.HTTPRequestContext;
import org.b3log.latke.servlet.HTTPRequestMethod;
import org.b3log.latke.servlet.annotation.RequestProcessing;
import org.b3log.latke.servlet.annotation.RequestProcessor;
import org.b3log.latke.servlet.renderer.AbstractHTTPResponseRenderer;
import org.b3log.latke.servlet.renderer.PNGRenderer;
import org.b3log.solo.SoloServletListener;

@RequestProcessor
public class CaptchaProcessor {
    private static final Logger LOGGER = Logger.getLogger((String)CaptchaProcessor.class.getName());
    private static final ImageService IMAGE_SERVICE = ImageServiceFactory.getImageService();
    public static final String CAPTCHA = "captcha";
    private Image[] captchas;
    private static final int CAPTCHA_COUNT = 100;

    @RequestProcessing(value={"/captcha.do"}, method={HTTPRequestMethod.GET})
    public void get(HTTPRequestContext context) {
        PNGRenderer renderer = new PNGRenderer();
        context.setRenderer((AbstractHTTPResponseRenderer)renderer);
        if (null == this.captchas) {
            this.loadCaptchas();
        }
        try {
            HttpServletRequest request = context.getRequest();
            HttpServletResponse response = context.getResponse();
            Random random = new Random();
            int index = random.nextInt(100);
            Image captchaImg = this.captchas[index];
            String captcha = captchaImg.getName();
            HttpSession httpSession = request.getSession(false);
            if (null != httpSession) {
                LOGGER.log(Level.DEBUG, "Captcha[{0}] for session[id={1}]", new Object[]{captcha, httpSession.getId()});
                httpSession.setAttribute(CAPTCHA, (Object)captcha);
            }
            response.setHeader("Pragma", "no-cache");
            response.setHeader("Cache-Control", "no-cache");
            response.setDateHeader("Expires", 0L);
            renderer.setImage(captchaImg);
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, e.getMessage(), (Throwable)e);
        }
    }

    private synchronized void loadCaptchas() {
        LOGGER.info("Loading captchas....");
        try {
            ZipFile zipFile;
            this.captchas = new Image[100];
            if (RuntimeEnv.LOCAL == Latkes.getRuntimeEnv()) {
                InputStream inputStream = SoloServletListener.class.getClassLoader().getResourceAsStream("captcha_static.zip");
                File file = File.createTempFile("b3log_captcha_static", null);
                FileOutputStream outputStream = new FileOutputStream(file);
                IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
                zipFile = new ZipFile(file);
                IOUtils.closeQuietly((InputStream)inputStream);
                IOUtils.closeQuietly((OutputStream)outputStream);
            } else {
                URL captchaURL = SoloServletListener.class.getClassLoader().getResource("captcha_static.zip");
                zipFile = new ZipFile(captchaURL.getFile());
            }
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            int i = 0;
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                BufferedInputStream bufferedInputStream = new BufferedInputStream(zipFile.getInputStream(entry));
                byte[] captchaCharData = new byte[bufferedInputStream.available()];
                bufferedInputStream.read(captchaCharData);
                bufferedInputStream.close();
                Image image = IMAGE_SERVICE.makeImage(captchaCharData);
                image.setName(entry.getName().substring(0, entry.getName().lastIndexOf(46)));
                this.captchas[i] = image;
                ++i;
            }
            zipFile.close();
        }
        catch (Exception e) {
            LOGGER.error("Can not load captchs!");
            throw new IllegalStateException(e);
        }
        LOGGER.info("Loaded captch images");
    }
}

