/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.solo.processor;

import java.net.URL;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.b3log.latke.Latkes;
import org.b3log.latke.RuntimeEnv;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.servlet.HTTPRequestContext;
import org.b3log.latke.servlet.HTTPRequestMethod;
import org.b3log.latke.servlet.annotation.RequestProcessing;
import org.b3log.latke.servlet.annotation.RequestProcessor;
import org.b3log.latke.servlet.renderer.AbstractHTTPResponseRenderer;
import org.b3log.latke.servlet.renderer.JSONRenderer;
import org.b3log.latke.urlfetch.HTTPRequest;
import org.b3log.latke.urlfetch.URLFetchService;
import org.b3log.latke.urlfetch.URLFetchServiceFactory;
import org.b3log.latke.util.MD5;
import org.b3log.latke.util.Strings;
import org.b3log.solo.SoloServletListener;
import org.b3log.solo.service.ArticleQueryService;
import org.b3log.solo.service.PreferenceQueryService;
import org.b3log.solo.service.StatisticQueryService;
import org.b3log.solo.service.TagQueryService;
import org.b3log.solo.service.UserQueryService;
import org.json.JSONArray;
import org.json.JSONObject;

@RequestProcessor
public class BlogProcessor {
    private static final Logger LOGGER = Logger.getLogger((String)BlogProcessor.class.getName());
    @Inject
    private ArticleQueryService articleQueryService;
    @Inject
    private TagQueryService tagQueryService;
    @Inject
    private StatisticQueryService statisticQueryService;
    @Inject
    private UserQueryService userQueryService;
    @Inject
    private PreferenceQueryService preferenceQueryService;
    private final URLFetchService urlFetchService = URLFetchServiceFactory.getURLFetchService();

    @RequestProcessing(value={"/blog/info"}, method={HTTPRequestMethod.GET})
    public void getBlogInfo(HTTPRequestContext context) throws Exception {
        JSONRenderer renderer = new JSONRenderer();
        context.setRenderer((AbstractHTTPResponseRenderer)renderer);
        JSONObject jsonObject = new JSONObject();
        renderer.setJSONObject(jsonObject);
        jsonObject.put("recentArticleTime", this.articleQueryService.getRecentArticleTime());
        JSONObject statistic = this.statisticQueryService.getStatistic();
        jsonObject.put("articleCount", statistic.getLong("statisticPublishedBlogArticleCount"));
        jsonObject.put("commentCount", statistic.getLong("statisticPublishedBlogCommentCount"));
        jsonObject.put("tagCount", this.tagQueryService.getTagCount());
        jsonObject.put("servePath", (Object)Latkes.getServePath());
        jsonObject.put("staticServePath", (Object)Latkes.getStaticServePath());
        jsonObject.put("version", (Object)"1.0.0");
        jsonObject.put("locale", (Object)Latkes.getLocale());
        jsonObject.put("runtimeMode", (Object)Latkes.getRuntimeMode());
        RuntimeEnv runtimeEnv = Latkes.getRuntimeEnv();
        jsonObject.put("runtimeEnv", (Object)runtimeEnv);
        if (RuntimeEnv.LOCAL == runtimeEnv) {
            jsonObject.put("runtimeDatabase", (Object)Latkes.getRuntimeDatabase());
        }
    }

    @RequestProcessing(value={"/blog/symphony/user"}, method={HTTPRequestMethod.GET})
    public void syncUser(HTTPRequestContext context) throws Exception {
        JSONRenderer renderer = new JSONRenderer();
        context.setRenderer((AbstractHTTPResponseRenderer)renderer);
        JSONObject jsonObject = new JSONObject();
        renderer.setJSONObject(jsonObject);
        if (Latkes.getServePath().contains("localhost")) {
            return;
        }
        JSONObject preference = this.preferenceQueryService.getPreference();
        if (null == preference) {
            return;
        }
        HTTPRequest httpRequest = new HTTPRequest();
        httpRequest.setURL(new URL(SoloServletListener.B3LOG_SYMPHONY_SERVE_PATH + "/apis/user"));
        httpRequest.setRequestMethod(HTTPRequestMethod.POST);
        JSONObject requestJSONObject = new JSONObject();
        JSONObject admin = this.userQueryService.getAdmin();
        requestJSONObject.put("userName", (Object)admin.getString("userName"));
        requestJSONObject.put("userEmail", (Object)admin.getString("userEmail"));
        requestJSONObject.put("userPassword", (Object)admin.getString("userPassword"));
        requestJSONObject.put("userB3Key", (Object)preference.optString("keyOfSolo"));
        requestJSONObject.put("clientHost", (Object)Latkes.getServePath());
        httpRequest.setPayload(requestJSONObject.toString().getBytes("UTF-8"));
        this.urlFetchService.fetchAsync(httpRequest);
    }

    @RequestProcessing(value={"/blog/articles-tags"}, method={HTTPRequestMethod.GET})
    public void getArticlesTags(HTTPRequestContext context, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String pwd = request.getParameter("pwd");
        if (Strings.isEmptyOrNull((String)pwd)) {
            response.sendError(403);
            return;
        }
        JSONObject admin = this.userQueryService.getAdmin();
        if (!MD5.hash((String)pwd).equals(admin.getString("userPassword"))) {
            response.sendError(403);
            return;
        }
        JSONObject requestJSONObject = new JSONObject();
        requestJSONObject.put("paginationCurrentPageNum", 1);
        requestJSONObject.put("paginationPageSize", Integer.MAX_VALUE);
        requestJSONObject.put("paginationWindowSize", Integer.MAX_VALUE);
        requestJSONObject.put("articleIsPublished", true);
        JSONArray excludes = new JSONArray();
        excludes.put((Object)"articleContent");
        excludes.put((Object)"articleUpdateDate");
        excludes.put((Object)"articleCreateDate");
        excludes.put((Object)"articleAuthorEmail");
        excludes.put((Object)"articleHadBeenPublished");
        excludes.put((Object)"articleIsPublished");
        excludes.put((Object)"articleRandomDouble");
        requestJSONObject.put("excludes", (Object)excludes);
        JSONObject result = this.articleQueryService.getArticles(requestJSONObject);
        JSONArray articles = result.optJSONArray("articles");
        JSONRenderer renderer = new JSONRenderer();
        context.setRenderer((AbstractHTTPResponseRenderer)renderer);
        JSONObject ret = new JSONObject();
        renderer.setJSONObject(ret);
        JSONArray data = new JSONArray();
        ret.put("data", (Object)data);
        for (int i = 0; i < articles.length(); ++i) {
            String[] tags;
            JSONObject article = articles.optJSONObject(i);
            String tagString = article.optString("articleTags");
            JSONArray tagArray = new JSONArray();
            data.put((Object)tagArray);
            for (String tag : tags = tagString.split(",")) {
                String trim = tag.trim();
                if (Strings.isEmptyOrNull((String)trim)) continue;
                tagArray.put((Object)tag);
            }
        }
    }
}

