/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.solo.processor;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.b3log.latke.Keys;
import org.b3log.latke.Latkes;
import org.b3log.latke.event.Event;
import org.b3log.latke.event.EventException;
import org.b3log.latke.event.EventManager;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.service.LangPropsService;
import org.b3log.latke.service.ServiceException;
import org.b3log.latke.servlet.HTTPRequestContext;
import org.b3log.latke.servlet.HTTPRequestMethod;
import org.b3log.latke.servlet.URIPatternMode;
import org.b3log.latke.servlet.annotation.RequestProcessing;
import org.b3log.latke.servlet.annotation.RequestProcessor;
import org.b3log.latke.servlet.renderer.AbstractHTTPResponseRenderer;
import org.b3log.latke.servlet.renderer.JSONRenderer;
import org.b3log.latke.servlet.renderer.TextHTMLRenderer;
import org.b3log.latke.servlet.renderer.freemarker.FreeMarkerRenderer;
import org.b3log.latke.util.CollectionUtils;
import org.b3log.latke.util.Dates;
import org.b3log.latke.util.Locales;
import org.b3log.latke.util.Paginator;
import org.b3log.latke.util.Requests;
import org.b3log.latke.util.Stopwatchs;
import org.b3log.latke.util.Strings;
import org.b3log.solo.processor.renderer.ConsoleRenderer;
import org.b3log.solo.processor.util.Filler;
import org.b3log.solo.service.ArchiveDateQueryService;
import org.b3log.solo.service.ArticleMgmtService;
import org.b3log.solo.service.ArticleQueryService;
import org.b3log.solo.service.CommentQueryService;
import org.b3log.solo.service.PreferenceQueryService;
import org.b3log.solo.service.StatisticMgmtService;
import org.b3log.solo.service.TagQueryService;
import org.b3log.solo.service.UserQueryService;
import org.b3log.solo.util.Skins;
import org.b3log.solo.util.Thumbnails;
import org.b3log.solo.util.comparator.Comparators;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.jsoup.Jsoup;

@RequestProcessor
public class ArticleProcessor {
    private static final Logger LOGGER = Logger.getLogger((String)ArticleProcessor.class.getName());
    @Inject
    private ArticleQueryService articleQueryService;
    @Inject
    private TagQueryService tagQueryService;
    @Inject
    private CommentQueryService commentQueryService;
    @Inject
    private Filler filler;
    @Inject
    private LangPropsService langPropsService;
    @Inject
    private PreferenceQueryService preferenceQueryService;
    @Inject
    private ArchiveDateQueryService archiveDateQueryService;
    @Inject
    private UserQueryService userQueryService;
    @Inject
    private ArticleMgmtService articleMgmtService;
    @Inject
    private StatisticMgmtService statisticMgmtService;
    @Inject
    private EventManager eventManager;

    @RequestProcessing(value={"/console/article-pwd"}, method={HTTPRequestMethod.GET})
    public void showArticlePwdForm(HTTPRequestContext context, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String articleId = request.getParameter("articleId");
        if (Strings.isEmptyOrNull((String)articleId)) {
            response.sendError(404);
            return;
        }
        JSONObject article = this.articleQueryService.getArticleById(articleId);
        if (null == article) {
            response.sendError(404);
            return;
        }
        ConsoleRenderer renderer = new ConsoleRenderer();
        context.setRenderer((AbstractHTTPResponseRenderer)renderer);
        renderer.setTemplateName("article-pwd.ftl");
        Map dataModel = renderer.getDataModel();
        dataModel.put("articleId", articleId);
        dataModel.put("articlePermalink", article.optString("articlePermalink"));
        dataModel.put("articleTitle", article.optString("articleTitle"));
        dataModel.put("articleAbstract", article.optString("articleAbstract"));
        String msg = request.getParameter("msg");
        if (!Strings.isEmptyOrNull((String)msg)) {
            dataModel.put("msg", this.langPropsService.get("passwordNotMatchLabel"));
        }
        Map langs = this.langPropsService.getAll(Latkes.getLocale());
        dataModel.putAll(langs);
        JSONObject preference = this.preferenceQueryService.getPreference();
        dataModel.put("blogTitle", preference.getString("blogTitle"));
        dataModel.put("version", "1.0.0");
        dataModel.put("staticResourceVersion", Latkes.getStaticResourceVersion());
        dataModel.put("year", String.valueOf(Calendar.getInstance().get(1)));
        Keys.fillRuntime((Map)dataModel);
        this.filler.fillMinified(dataModel);
    }

    @RequestProcessing(value={"/console/article-pwd"}, method={HTTPRequestMethod.POST})
    public void onArticlePwdForm(HTTPRequestContext context, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            String articleId = request.getParameter("articleId");
            String pwdTyped = request.getParameter("pwdTyped");
            JSONObject article = this.articleQueryService.getArticleById(articleId);
            if (article.getString("articleViewPwd").equals(pwdTyped)) {
                HttpSession session = request.getSession(false);
                if (null != session) {
                    HashMap<String, String> viewPwds = (HashMap<String, String>)session.getAttribute("articlesViewPwd");
                    if (null == viewPwds) {
                        viewPwds = new HashMap<String, String>();
                    }
                    viewPwds.put(articleId, pwdTyped);
                    session.setAttribute("articlesViewPwd", viewPwds);
                }
                response.sendRedirect(Latkes.getServePath() + article.getString("articlePermalink"));
                return;
            }
            response.sendRedirect(Latkes.getServePath() + "/console/article-pwd?articleId=" + article.optString(Keys.OBJECT_ID) + "&msg=1");
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Processes article view password form submits failed", (Throwable)e);
            response.sendError(404);
        }
    }

    @RequestProcessing(value={"/get-random-articles.do"}, method={HTTPRequestMethod.POST})
    public void getRandomArticles(HTTPRequestContext context) throws Exception {
        JSONObject jsonObject = new JSONObject();
        JSONObject preference = this.preferenceQueryService.getPreference();
        int displayCnt = preference.getInt("randomArticlesDisplayCount");
        if (0 == displayCnt) {
            jsonObject.put("randomArticles", new ArrayList());
            JSONRenderer renderer = new JSONRenderer();
            context.setRenderer((AbstractHTTPResponseRenderer)renderer);
            renderer.setJSONObject(jsonObject);
            return;
        }
        Stopwatchs.start((String)"Get Random Articles");
        List<JSONObject> randomArticles = this.getRandomArticles(preference);
        jsonObject.put("randomArticles", randomArticles);
        JSONRenderer renderer = new JSONRenderer();
        context.setRenderer((AbstractHTTPResponseRenderer)renderer);
        renderer.setJSONObject(jsonObject);
        Stopwatchs.end();
    }

    @RequestProcessing(value={"/article/id/*/relevant/articles"}, method={HTTPRequestMethod.GET})
    public void getRelevantArticles(HTTPRequestContext context, HttpServletRequest request, HttpServletResponse response) throws Exception {
        JSONObject jsonObject = new JSONObject();
        JSONObject preference = this.preferenceQueryService.getPreference();
        int displayCnt = preference.getInt("relevantArticlesDisplayCount");
        if (0 == displayCnt) {
            jsonObject.put("randomArticles", new ArrayList());
            JSONRenderer renderer = new JSONRenderer();
            context.setRenderer((AbstractHTTPResponseRenderer)renderer);
            renderer.setJSONObject(jsonObject);
            return;
        }
        Stopwatchs.start((String)"Get Relevant Articles");
        String requestURI = request.getRequestURI();
        String articleId = StringUtils.substringBetween((String)requestURI, (String)"/article/id/", (String)"/relevant/articles");
        if (Strings.isEmptyOrNull((String)articleId)) {
            response.sendError(404);
            return;
        }
        JSONObject article = this.articleQueryService.getArticleById(articleId);
        if (null == article) {
            response.sendError(404);
            return;
        }
        List<JSONObject> relevantArticles = this.articleQueryService.getRelevantArticles(article, preference);
        jsonObject.put("relevantArticles", relevantArticles);
        JSONRenderer renderer = new JSONRenderer();
        context.setRenderer((AbstractHTTPResponseRenderer)renderer);
        renderer.setJSONObject(jsonObject);
        Stopwatchs.end();
    }

    @RequestProcessing(value={"/get-article-content"}, method={HTTPRequestMethod.GET})
    public void getArticleContent(HTTPRequestContext context, HttpServletRequest request) {
        String content;
        String articleId = request.getParameter("id");
        if (Strings.isEmptyOrNull((String)articleId)) {
            return;
        }
        TextHTMLRenderer renderer = new TextHTMLRenderer();
        context.setRenderer((AbstractHTTPResponseRenderer)renderer);
        try {
            content = this.articleQueryService.getArticleContent(request, articleId);
        }
        catch (ServiceException e) {
            LOGGER.log(Level.ERROR, "Can not get article content", (Throwable)e);
            return;
        }
        if (null == content) {
            return;
        }
        renderer.setContent(content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestProcessing(value={"/articles/\\d+"}, uriPatternsMode=URIPatternMode.REGEX, method={HTTPRequestMethod.GET})
    public void getArticlesByPage(HTTPRequestContext context, HttpServletRequest request) {
        JSONObject jsonObject = new JSONObject();
        int currentPageNum = ArticleProcessor.getArticlesPagedCurrentPageNum(request.getRequestURI());
        Stopwatchs.start((String)("Get Articles Paged[pageNum=" + currentPageNum + ']'));
        try {
            jsonObject.put("sc", true);
            JSONObject preference = this.preferenceQueryService.getPreference();
            int pageSize = preference.getInt("articleListDisplayCount");
            int windowSize = preference.getInt("articleListPaginationWindowSize");
            StringBuilder pathBuilder = new StringBuilder();
            pathBuilder.append(currentPageNum).append('/').append(pageSize).append('/').append(windowSize);
            JSONObject requestJSONObject = Requests.buildPaginationRequest((String)pathBuilder.toString());
            requestJSONObject.put("articleIsPublished", true);
            JSONObject result = this.articleQueryService.getArticles(requestJSONObject);
            List articles = CollectionUtils.jsonArrayToList((JSONArray)result.getJSONArray("articles"));
            boolean hasMultipleUsers = this.userQueryService.hasMultipleUsers();
            if (hasMultipleUsers) {
                this.filler.setArticlesExProperties(request, articles, preference);
            } else if (!articles.isEmpty()) {
                JSONObject author = this.articleQueryService.getAuthor((JSONObject)articles.get(0));
                this.filler.setArticlesExProperties(request, articles, author, preference);
            }
            jsonObject.put("rslts", (Object)result);
        }
        catch (Exception e) {
            jsonObject.put("sc", false);
            LOGGER.log(Level.ERROR, "Gets article paged failed", (Throwable)e);
        }
        finally {
            Stopwatchs.end();
        }
        JSONRenderer renderer = new JSONRenderer();
        context.setRenderer((AbstractHTTPResponseRenderer)renderer);
        renderer.setJSONObject(jsonObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestProcessing(value={"/articles/tags/.+/\\d+"}, uriPatternsMode=URIPatternMode.REGEX, method={HTTPRequestMethod.GET})
    public void getTagArticlesByPage(HTTPRequestContext context, HttpServletRequest request) {
        JSONObject jsonObject = new JSONObject();
        String tagTitle = ArticleProcessor.getTagArticlesPagedTag(request.getRequestURI());
        try {
            tagTitle = URLDecoder.decode(tagTitle, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.log(Level.ERROR, "Gets tag title failed[requestURI=" + request.getRequestURI() + ']', (Throwable)e);
            tagTitle = "";
        }
        int currentPageNum = ArticleProcessor.getTagArticlesPagedCurrentPageNum(request.getRequestURI());
        Stopwatchs.start((String)("Get Tag-Articles Paged[tagTitle=" + tagTitle + ", pageNum=" + currentPageNum + ']'));
        try {
            jsonObject.put("sc", true);
            JSONObject preference = this.preferenceQueryService.getPreference();
            int pageSize = preference.getInt("articleListDisplayCount");
            JSONObject tagQueryResult = this.tagQueryService.getTagByTitle(tagTitle);
            if (null == tagQueryResult) {
                throw new Exception("Can not foud tag[title=" + tagTitle + "]");
            }
            JSONObject tag = tagQueryResult.getJSONObject("tag");
            String tagId = tag.getString(Keys.OBJECT_ID);
            List<JSONObject> articles = this.articleQueryService.getArticlesByTag(tagId, currentPageNum, pageSize);
            int tagArticleCount = tag.getInt("tagPublishedRefCount");
            int pageCount = (int)Math.ceil((double)tagArticleCount / (double)pageSize);
            boolean hasMultipleUsers = this.userQueryService.hasMultipleUsers();
            if (hasMultipleUsers) {
                this.filler.setArticlesExProperties(request, articles, preference);
            } else if (!articles.isEmpty()) {
                JSONObject author = this.articleQueryService.getAuthor(articles.get(0));
                this.filler.setArticlesExProperties(request, articles, author, preference);
            }
            Collections.sort(articles, Comparators.ARTICLE_CREATE_DATE_COMPARATOR);
            JSONObject result = new JSONObject();
            JSONObject pagination = new JSONObject();
            pagination.put("paginationPageCount", pageCount);
            result.put("pagination", (Object)pagination);
            result.put("articles", articles);
            jsonObject.put("rslts", (Object)result);
        }
        catch (Exception e) {
            jsonObject.put("sc", false);
            LOGGER.log(Level.ERROR, "Gets article paged failed", (Throwable)e);
        }
        finally {
            Stopwatchs.end();
        }
        JSONRenderer renderer = new JSONRenderer();
        context.setRenderer((AbstractHTTPResponseRenderer)renderer);
        renderer.setJSONObject(jsonObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestProcessing(value={"/articles/archives/.+/\\d+"}, uriPatternsMode=URIPatternMode.REGEX, method={HTTPRequestMethod.GET})
    public void getArchivesArticlesByPage(HTTPRequestContext context, HttpServletRequest request) {
        JSONObject jsonObject = new JSONObject();
        String archiveDateString = ArticleProcessor.getArchivesArticlesPagedArchive(request.getRequestURI());
        int currentPageNum = ArticleProcessor.getArchivesArticlesPagedCurrentPageNum(request.getRequestURI());
        Stopwatchs.start((String)("Get Archive-Articles Paged[archive=" + archiveDateString + ", pageNum=" + currentPageNum + ']'));
        try {
            jsonObject.put("sc", true);
            JSONObject preference = this.preferenceQueryService.getPreference();
            int pageSize = preference.getInt("articleListDisplayCount");
            JSONObject archiveQueryResult = this.archiveDateQueryService.getByArchiveDateString(archiveDateString);
            if (null == archiveQueryResult) {
                throw new Exception("Can not found archive[archiveDate=" + archiveDateString + "]");
            }
            JSONObject archiveDate = archiveQueryResult.getJSONObject("archiveDate");
            String archiveDateId = archiveDate.getString(Keys.OBJECT_ID);
            int articleCount = archiveDate.getInt("archiveDatePublishedArticleCount");
            int pageCount = (int)Math.ceil((double)articleCount / (double)pageSize);
            List<JSONObject> articles = this.articleQueryService.getArticlesByArchiveDate(archiveDateId, currentPageNum, pageSize);
            boolean hasMultipleUsers = this.userQueryService.hasMultipleUsers();
            if (hasMultipleUsers) {
                this.filler.setArticlesExProperties(request, articles, preference);
            } else if (!articles.isEmpty()) {
                JSONObject author = this.articleQueryService.getAuthor(articles.get(0));
                this.filler.setArticlesExProperties(request, articles, author, preference);
            }
            Collections.sort(articles, Comparators.ARTICLE_CREATE_DATE_COMPARATOR);
            JSONObject result = new JSONObject();
            JSONObject pagination = new JSONObject();
            pagination.put("paginationPageCount", pageCount);
            result.put("pagination", (Object)pagination);
            result.put("articles", articles);
            jsonObject.put("rslts", (Object)result);
        }
        catch (Exception e) {
            jsonObject.put("sc", false);
            LOGGER.log(Level.ERROR, "Gets article paged failed", (Throwable)e);
        }
        finally {
            Stopwatchs.end();
        }
        JSONRenderer renderer = new JSONRenderer();
        context.setRenderer((AbstractHTTPResponseRenderer)renderer);
        renderer.setJSONObject(jsonObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestProcessing(value={"/articles/authors/\\d+/\\d+"}, uriPatternsMode=URIPatternMode.REGEX, method={HTTPRequestMethod.GET})
    public void getAuthorsArticlesByPage(HTTPRequestContext context, HttpServletRequest request) {
        JSONObject jsonObject = new JSONObject();
        String authorId = ArticleProcessor.getAuthorsArticlesPagedAuthorId(request.getRequestURI());
        int currentPageNum = ArticleProcessor.getAuthorsArticlesPagedCurrentPageNum(request.getRequestURI());
        Stopwatchs.start((String)("Get Author-Articles Paged[authorId=" + authorId + ", pageNum=" + currentPageNum + ']'));
        try {
            jsonObject.put("sc", true);
            JSONObject preference = this.preferenceQueryService.getPreference();
            int pageSize = preference.getInt("articleListDisplayCount");
            JSONObject authorRet = this.userQueryService.getUser(authorId);
            if (null == authorRet) {
                context.getResponse().sendError(404);
                return;
            }
            JSONObject author = authorRet.getJSONObject("user");
            String authorEmail = author.optString("userEmail");
            List<JSONObject> articles = this.articleQueryService.getArticlesByAuthorEmail(authorEmail, currentPageNum, pageSize);
            if (!articles.isEmpty()) {
                this.filler.setArticlesExProperties(request, articles, author, preference);
            }
            int articleCount = author.getInt("userPublishedArticleCount");
            int pageCount = (int)Math.ceil((double)articleCount / (double)pageSize);
            JSONObject result = new JSONObject();
            JSONObject pagination = new JSONObject();
            pagination.put("paginationPageCount", pageCount);
            result.put("pagination", (Object)pagination);
            result.put("articles", articles);
            jsonObject.put("rslts", (Object)result);
        }
        catch (Exception e) {
            jsonObject.put("sc", false);
            LOGGER.log(Level.ERROR, "Gets article paged failed", (Throwable)e);
        }
        finally {
            Stopwatchs.end();
        }
        JSONRenderer renderer = new JSONRenderer();
        context.setRenderer((AbstractHTTPResponseRenderer)renderer);
        renderer.setJSONObject(jsonObject);
    }

    @RequestProcessing(value={"/authors/**"}, method={HTTPRequestMethod.GET})
    public void showAuthorArticles(HTTPRequestContext context, HttpServletRequest request, HttpServletResponse response) throws IOException, JSONException {
        FreeMarkerRenderer renderer = new FreeMarkerRenderer();
        context.setRenderer((AbstractHTTPResponseRenderer)renderer);
        renderer.setTemplateName("author-articles.ftl");
        try {
            String requestURI = request.getRequestURI();
            if (!requestURI.endsWith("/")) {
                requestURI = requestURI + "/";
            }
            String authorId = ArticleProcessor.getAuthorId(requestURI);
            LOGGER.log(Level.DEBUG, "Request author articles[requestURI={0}, authorId={1}]", new Object[]{requestURI, authorId});
            int currentPageNum = ArticleProcessor.getAuthorCurrentPageNum(requestURI, authorId);
            if (-1 == currentPageNum) {
                response.sendError(404);
                return;
            }
            LOGGER.log(Level.DEBUG, "Request author articles[authorId={0}, currentPageNum={1}]", new Object[]{authorId, currentPageNum});
            JSONObject preference = this.preferenceQueryService.getPreference();
            if (null == preference) {
                response.sendError(404);
                return;
            }
            int pageSize = preference.getInt("articleListDisplayCount");
            int windowSize = preference.getInt("articleListPaginationWindowSize");
            JSONObject result = this.userQueryService.getUser(authorId);
            if (null == result) {
                response.sendError(404);
                return;
            }
            JSONObject author = result.getJSONObject("user");
            String authorEmail = author.getString("userEmail");
            List<JSONObject> articles = this.articleQueryService.getArticlesByAuthorEmail(authorEmail, currentPageNum, pageSize);
            if (articles.isEmpty()) {
                try {
                    response.sendError(404);
                    return;
                }
                catch (IOException ex) {
                    LOGGER.error(ex.getMessage());
                }
            }
            this.filler.setArticlesExProperties(request, articles, author, preference);
            if (preference.optBoolean("enableArticleUpdateHint")) {
                Collections.sort(articles, Comparators.ARTICLE_UPDATE_DATE_COMPARATOR);
            } else {
                Collections.sort(articles, Comparators.ARTICLE_CREATE_DATE_COMPARATOR);
            }
            int articleCount = author.getInt("userPublishedArticleCount");
            int pageCount = (int)Math.ceil((double)articleCount / (double)pageSize);
            List pageNums = Paginator.paginate((int)currentPageNum, (int)pageSize, (int)pageCount, (int)windowSize);
            Map dataModel = renderer.getDataModel();
            this.prepareShowAuthorArticles(pageNums, dataModel, pageCount, currentPageNum, articles, author);
            this.filler.fillBlogHeader(request, response, dataModel, preference);
            this.filler.fillBlogFooter(request, dataModel, preference);
            this.filler.fillSide(request, dataModel, preference);
            Skins.fillLangs(preference.optString("localeString"), (String)request.getAttribute("templateDirName"), dataModel);
            this.statisticMgmtService.incBlogViewCount(request, response);
        }
        catch (ServiceException e) {
            LOGGER.log(Level.ERROR, e.getMessage(), (Throwable)e);
            try {
                response.sendError(404);
            }
            catch (IOException ex) {
                LOGGER.error(ex.getMessage());
            }
        }
    }

    @RequestProcessing(value={"/archives/**"}, method={HTTPRequestMethod.GET})
    public void showArchiveArticles(HTTPRequestContext context, HttpServletRequest request, HttpServletResponse response) {
        FreeMarkerRenderer renderer = new FreeMarkerRenderer();
        context.setRenderer((AbstractHTTPResponseRenderer)renderer);
        renderer.setTemplateName("archive-articles.ftl");
        try {
            boolean hasMultipleUsers;
            String requestURI = request.getRequestURI();
            if (!requestURI.endsWith("/")) {
                requestURI = requestURI + "/";
            }
            String archiveDateString = ArticleProcessor.getArchiveDate(requestURI);
            int currentPageNum = ArticleProcessor.getArchiveCurrentPageNum(requestURI);
            if (-1 == currentPageNum) {
                response.sendError(404);
                return;
            }
            LOGGER.log(Level.DEBUG, "Request archive date[string={0}, currentPageNum={1}]", new Object[]{archiveDateString, currentPageNum});
            JSONObject result = this.archiveDateQueryService.getByArchiveDateString(archiveDateString);
            if (null == result) {
                LOGGER.log(Level.WARN, "Can not find articles for the specified archive date[string={0}]", new Object[]{archiveDateString});
                response.sendError(404);
                return;
            }
            JSONObject archiveDate = result.getJSONObject("archiveDate");
            String archiveDateId = archiveDate.getString(Keys.OBJECT_ID);
            JSONObject preference = this.preferenceQueryService.getPreference();
            int pageSize = preference.getInt("articleListDisplayCount");
            int articleCount = archiveDate.getInt("archiveDatePublishedArticleCount");
            int pageCount = (int)Math.ceil((double)articleCount / (double)pageSize);
            List<JSONObject> articles = this.articleQueryService.getArticlesByArchiveDate(archiveDateId, currentPageNum, pageSize);
            if (articles.isEmpty()) {
                try {
                    response.sendError(404);
                    return;
                }
                catch (IOException ex) {
                    LOGGER.error(ex.getMessage());
                }
            }
            if (hasMultipleUsers = this.userQueryService.hasMultipleUsers()) {
                this.filler.setArticlesExProperties(request, articles, preference);
            } else if (!articles.isEmpty()) {
                JSONObject author = this.articleQueryService.getAuthor(articles.get(0));
                this.filler.setArticlesExProperties(request, articles, author, preference);
            }
            this.sort(preference, articles);
            Map dataModel = renderer.getDataModel();
            Skins.fillLangs(preference.optString("localeString"), (String)request.getAttribute("templateDirName"), dataModel);
            this.prepareShowArchiveArticles(preference, dataModel, articles, currentPageNum, pageCount, archiveDateString, archiveDate);
            this.filler.fillBlogHeader(request, response, dataModel, preference);
            this.filler.fillBlogFooter(request, dataModel, preference);
            this.filler.fillSide(request, dataModel, preference);
            this.statisticMgmtService.incBlogViewCount(request, response);
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, e.getMessage(), (Throwable)e);
            try {
                response.sendError(404);
            }
            catch (IOException ex) {
                LOGGER.error(ex.getMessage());
            }
        }
    }

    @RequestProcessing(value={"/article-random-double-gen.do"}, method={HTTPRequestMethod.GET})
    public void updateArticlesRandomValue(HttpServletRequest request) {
    }

    @RequestProcessing(value={"/article"}, method={HTTPRequestMethod.GET})
    public void showArticle(HTTPRequestContext context, HttpServletRequest request, HttpServletResponse response) throws IOException {
        JSONObject article = (JSONObject)request.getAttribute("article");
        if (null == article) {
            response.sendError(404);
            return;
        }
        String articleId = article.optString(Keys.OBJECT_ID);
        LOGGER.log(Level.DEBUG, "Article[id={0}]", new Object[]{articleId});
        FreeMarkerRenderer renderer = new FreeMarkerRenderer();
        context.setRenderer((AbstractHTTPResponseRenderer)renderer);
        renderer.setTemplateName("article.ftl");
        try {
            JSONObject preference = this.preferenceQueryService.getPreference();
            boolean allowVisitDraftViaPermalink = preference.getBoolean("allowVisitDraftViaPermalink");
            if (!article.optBoolean("articleIsPublished") && !allowVisitDraftViaPermalink) {
                response.sendError(404);
                return;
            }
            LOGGER.log(Level.TRACE, "Article[title={0}]", new Object[]{article.getString("articleTitle")});
            this.articleQueryService.markdown(article);
            String metaDescription = Jsoup.parse((String)article.optString("articleAbstract")).text();
            article.put("articleAbstract", (Object)metaDescription);
            if (preference.getBoolean("enableArticleUpdateHint")) {
                article.put("hasUpdated", this.articleQueryService.hasUpdated(article));
            } else {
                article.put("hasUpdated", false);
            }
            JSONObject author = this.articleQueryService.getAuthor(article);
            String authorName = author.getString("userName");
            article.put("authorName", (Object)authorName);
            String authorId = author.getString(Keys.OBJECT_ID);
            article.put("authorId", (Object)authorId);
            article.put("authorRole", (Object)author.getString("userRole"));
            String thumbnailURL = Thumbnails.getGravatarURL(author.optString("userEmail"), "60");
            article.put("authorThumbnailURL", (Object)thumbnailURL);
            Map dataModel = renderer.getDataModel();
            this.prepareShowArticle(preference, dataModel, article);
            this.filler.fillBlogHeader(request, response, dataModel, preference);
            this.filler.fillBlogFooter(request, dataModel, preference);
            this.filler.fillSide(request, dataModel, preference);
            Skins.fillLangs(preference.optString("localeString"), (String)request.getAttribute("templateDirName"), dataModel);
            if (!Requests.hasBeenServed((HttpServletRequest)request, (HttpServletResponse)response)) {
                this.articleMgmtService.incViewCount(articleId);
            }
            this.statisticMgmtService.incBlogViewCount(request, response);
            JSONObject eventData = new JSONObject();
            eventData.put("article", (Object)article);
            try {
                this.eventManager.fireEventSynchronously(new Event("Before Render Article", (Object)eventData));
            }
            catch (EventException e) {
                LOGGER.log(Level.ERROR, "Fires [Before Render Article] event failed", (Throwable)e);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, e.getMessage(), (Throwable)e);
            try {
                response.sendError(404);
            }
            catch (IOException ex) {
                LOGGER.error(ex.getMessage());
            }
        }
    }

    private void sort(JSONObject preference, List<JSONObject> articles) throws JSONException {
        Collections.sort(articles, Comparators.ARTICLE_CREATE_DATE_COMPARATOR);
    }

    private static String getArchiveDate(String requestURI) {
        String path = requestURI.substring((Latkes.getContextPath() + "/archives/").length());
        return path.substring(0, "yyyy/MM".length());
    }

    private static int getArchiveCurrentPageNum(String requestURI) {
        String pageNumString = requestURI.substring((Latkes.getContextPath() + "/archives/yyyy/MM/").length());
        return Requests.getCurrentPageNum((String)pageNumString);
    }

    private static String getAuthorId(String requestURI) {
        String path = requestURI.substring((Latkes.getContextPath() + "/authors/").length());
        int idx = path.indexOf("/");
        if (-1 == idx) {
            return path.substring(0);
        }
        return path.substring(0, idx);
    }

    private static int getArticlesPagedCurrentPageNum(String requestURI) {
        String pageNumString = requestURI.substring((Latkes.getContextPath() + "/articles/").length());
        return Requests.getCurrentPageNum((String)pageNumString);
    }

    private static int getTagArticlesPagedCurrentPageNum(String requestURI) {
        return Requests.getCurrentPageNum((String)StringUtils.substringAfterLast((String)requestURI, (String)"/"));
    }

    private static String getTagArticlesPagedTag(String requestURI) {
        String tagAndPageNum = requestURI.substring((Latkes.getContextPath() + "/articles/tags/").length());
        if (tagAndPageNum.endsWith("/")) {
            tagAndPageNum = StringUtils.removeEnd((String)tagAndPageNum, (String)"/");
        }
        return StringUtils.substringBefore((String)tagAndPageNum, (String)"/");
    }

    private static int getArchivesArticlesPagedCurrentPageNum(String requestURI) {
        return Requests.getCurrentPageNum((String)StringUtils.substringAfterLast((String)requestURI, (String)"/"));
    }

    private static String getArchivesArticlesPagedArchive(String requestURI) {
        String archiveAndPageNum = requestURI.substring((Latkes.getContextPath() + "/articles/archives/").length());
        if (archiveAndPageNum.endsWith("/")) {
            archiveAndPageNum = StringUtils.removeEnd((String)archiveAndPageNum, (String)"/");
        }
        return StringUtils.substringBeforeLast((String)archiveAndPageNum, (String)"/");
    }

    private static int getAuthorsArticlesPagedCurrentPageNum(String requestURI) {
        return Requests.getCurrentPageNum((String)StringUtils.substringAfterLast((String)requestURI, (String)"/"));
    }

    private static String getAuthorsArticlesPagedAuthorId(String requestURI) {
        String authorIdAndPageNum = requestURI.substring((Latkes.getContextPath() + "/articles/authors/").length());
        if (authorIdAndPageNum.endsWith("/")) {
            authorIdAndPageNum = StringUtils.removeEnd((String)authorIdAndPageNum, (String)"/");
        }
        return StringUtils.substringBefore((String)authorIdAndPageNum, (String)"/");
    }

    private static int getAuthorCurrentPageNum(String requestURI, String authorId) {
        String pageNumString = requestURI.substring((Latkes.getContextPath() + "/authors/" + authorId + "/").length());
        return Requests.getCurrentPageNum((String)pageNumString);
    }

    private List<JSONObject> getRandomArticles(JSONObject preference) {
        try {
            int displayCnt = preference.getInt("randomArticlesDisplayCount");
            List<JSONObject> ret = this.articleQueryService.getArticlesRandomly(displayCnt);
            return ret;
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    private void prepareShowAuthorArticles(List<Integer> pageNums, Map<String, Object> dataModel, int pageCount, int currentPageNum, List<JSONObject> articles, JSONObject author) throws ServiceException {
        if (0 != pageNums.size()) {
            dataModel.put("paginationFirstPageNum", pageNums.get(0));
            dataModel.put("paginationLastPageNum", pageNums.get(pageNums.size() - 1));
        }
        dataModel.put("paginationPageCount", pageCount);
        dataModel.put("paginationPageNums", pageNums);
        dataModel.put("paginationCurrentPageNum", currentPageNum);
        String previousPageNum = Integer.toString(currentPageNum > 1 ? currentPageNum - 1 : 0);
        dataModel.put("paginationPreviousPageNum", "0".equals(previousPageNum) ? "" : previousPageNum);
        if (pageCount == currentPageNum + 1) {
            dataModel.put("paginationNextPageNum", "");
        } else {
            dataModel.put("paginationNextPageNum", currentPageNum + 1);
        }
        dataModel.put("articles", articles);
        String authorId = author.optString(Keys.OBJECT_ID);
        dataModel.put("path", "/authors/" + authorId);
        dataModel.put(Keys.OBJECT_ID, authorId);
        dataModel.put("authorName", author.optString("userName"));
        String thumbnailURL = Thumbnails.getGravatarURL(author.optString("userEmail"), "60");
        dataModel.put("authorThumbnailURL", thumbnailURL);
        dataModel.put("paginationCurrentPageNum", currentPageNum);
    }

    private String prepareShowArchiveArticles(JSONObject preference, Map<String, Object> dataModel, List<JSONObject> articles, int currentPageNum, int pageCount, String archiveDateString, JSONObject archiveDate) throws Exception {
        String ret;
        int pageSize = preference.getInt("articleListDisplayCount");
        int windowSize = preference.getInt("articleListPaginationWindowSize");
        List pageNums = Paginator.paginate((int)currentPageNum, (int)pageSize, (int)pageCount, (int)windowSize);
        dataModel.put("articles", articles);
        String previousPageNum = Integer.toString(currentPageNum > 1 ? currentPageNum - 1 : 0);
        dataModel.put("paginationPreviousPageNum", "0".equals(previousPageNum) ? "" : previousPageNum);
        if (pageCount == currentPageNum + 1) {
            dataModel.put("paginationNextPageNum", "");
        } else {
            dataModel.put("paginationNextPageNum", currentPageNum + 1);
        }
        dataModel.put("paginationCurrentPageNum", currentPageNum);
        dataModel.put("paginationFirstPageNum", pageNums.get(0));
        dataModel.put("paginationLastPageNum", pageNums.get(pageNums.size() - 1));
        dataModel.put("paginationPageCount", pageCount);
        dataModel.put("paginationPageNums", pageNums);
        dataModel.put("path", "/archives/" + archiveDateString);
        dataModel.put(Keys.OBJECT_ID, archiveDate.getString(Keys.OBJECT_ID));
        long time = archiveDate.getLong("archiveTime");
        String dateString = DateFormatUtils.format((long)time, (String)"yyyy/MM");
        String[] dateStrings = dateString.split("/");
        String year = dateStrings[0];
        String month = dateStrings[1];
        archiveDate.put("archiveDateYear", (Object)year);
        String language = Locales.getLanguage((String)preference.getString("localeString"));
        if ("en".equals(language)) {
            archiveDate.put("archiveDateMonth", Dates.EN_MONTHS.get(month));
            ret = (String)Dates.EN_MONTHS.get(month) + " " + year;
        } else {
            archiveDate.put("archiveDateMonth", (Object)month);
            ret = year + " " + dataModel.get("yearLabel") + " " + month + " " + dataModel.get("monthLabel");
        }
        dataModel.put("archiveDate", archiveDate);
        return ret;
    }

    private void prepareShowArticle(JSONObject preference, Map<String, Object> dataModel, JSONObject article) throws Exception {
        article.put("commentable", preference.getBoolean("commentable") && article.getBoolean("articleCommentable"));
        article.put("permalink", (Object)article.getString("articlePermalink"));
        dataModel.put("article", article);
        String articleId = article.getString(Keys.OBJECT_ID);
        Stopwatchs.start((String)"Get Article Sign");
        LOGGER.debug("Getting article sign....");
        article.put("articleSign", (Object)this.articleQueryService.getSign(article.getString("articleSignId"), preference));
        LOGGER.debug("Got article sign");
        Stopwatchs.end();
        Stopwatchs.start((String)"Get Next Article");
        LOGGER.debug("Getting the next article....");
        JSONObject nextArticle = this.articleQueryService.getNextArticle(articleId);
        if (null != nextArticle) {
            dataModel.put("nextArticlePermalink", nextArticle.getString("articlePermalink"));
            dataModel.put("nextArticleTitle", nextArticle.getString("articleTitle"));
            dataModel.put("nextArticleAbstract", nextArticle.getString("articleAbstract"));
            LOGGER.debug("Got the next article");
        }
        Stopwatchs.end();
        Stopwatchs.start((String)"Get Previous Article");
        LOGGER.debug("Getting the previous article....");
        JSONObject previousArticle = this.articleQueryService.getPreviousArticle(articleId);
        if (null != previousArticle) {
            dataModel.put("previousArticlePermalink", previousArticle.getString("articlePermalink"));
            dataModel.put("previousArticleTitle", previousArticle.getString("articleTitle"));
            dataModel.put("previousArticleAbstract", previousArticle.getString("articleAbstract"));
            LOGGER.debug("Got the previous article");
        }
        Stopwatchs.end();
        Stopwatchs.start((String)"Get Article CMTs");
        LOGGER.debug("Getting article's comments....");
        int cmtCount = article.getInt("articleCommentCount");
        if (0 != cmtCount) {
            List<JSONObject> articleComments = this.commentQueryService.getComments(articleId);
            dataModel.put("articleComments", articleComments);
        } else {
            dataModel.put("articleComments", Collections.emptyList());
        }
        LOGGER.debug("Got article's comments");
        Stopwatchs.end();
        dataModel.put("externalRelevantArticlesDisplayCount", preference.getInt("externalRelevantArticlesDisplayCount"));
        dataModel.put("randomArticlesDisplayCount", preference.getInt("randomArticlesDisplayCount"));
        dataModel.put("relevantArticlesDisplayCount", preference.getInt("relevantArticlesDisplayCount"));
    }
}

