/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.solo.plugin.broadcast;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.Future;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.b3log.latke.Keys;
import org.b3log.latke.Latkes;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.servlet.HTTPRequestContext;
import org.b3log.latke.servlet.HTTPRequestMethod;
import org.b3log.latke.servlet.annotation.RequestProcessing;
import org.b3log.latke.servlet.annotation.RequestProcessor;
import org.b3log.latke.servlet.renderer.AbstractHTTPResponseRenderer;
import org.b3log.latke.servlet.renderer.JSONRenderer;
import org.b3log.latke.urlfetch.HTTPRequest;
import org.b3log.latke.urlfetch.HTTPResponse;
import org.b3log.latke.urlfetch.URLFetchService;
import org.b3log.latke.urlfetch.URLFetchServiceFactory;
import org.b3log.latke.util.Requests;
import org.b3log.latke.util.Strings;
import org.b3log.solo.SoloServletListener;
import org.b3log.solo.service.OptionMgmtService;
import org.b3log.solo.service.OptionQueryService;
import org.b3log.solo.service.PreferenceQueryService;
import org.b3log.solo.service.UserQueryService;
import org.b3log.solo.util.QueryResults;
import org.json.JSONObject;

@RequestProcessor
public class ChanceProcessor {
    private static final Logger LOGGER = Logger.getLogger((String)ChanceProcessor.class.getName());
    @Inject
    private OptionMgmtService optionMgmtService;
    @Inject
    private OptionQueryService optionQueryService;
    private final URLFetchService urlFetchService = URLFetchServiceFactory.getURLFetchService();
    @Inject
    private UserQueryService userQueryService;
    @Inject
    private PreferenceQueryService preferenceQueryService;
    private static final URL ADD_BROADCAST_URL;

    @RequestProcessing(value={"/console/plugins/b3log-broadcast/chance"}, method={HTTPRequestMethod.POST})
    public void addChance(HTTPRequestContext context, HttpServletRequest request, HttpServletResponse response) throws Exception {
        JSONRenderer renderer = new JSONRenderer();
        context.setRenderer((AbstractHTTPResponseRenderer)renderer);
        JSONObject ret = new JSONObject();
        renderer.setJSONObject(ret);
        try {
            String time = request.getParameter("time");
            if (Strings.isEmptyOrNull((String)time)) {
                ret.put("sc", false);
                return;
            }
            long expirationTime = Long.valueOf(time);
            JSONObject option = new JSONObject();
            option.put(Keys.OBJECT_ID, (Object)"broadcastChanceExpirationTime");
            option.put("optionValue", expirationTime);
            option.put("optionCategory", (Object)"broadcast");
            this.optionMgmtService.addOrUpdateOption(option);
            ret.put("sc", true);
        }
        catch (Exception e) {
            String msg = "Broadcast plugin exception";
            LOGGER.log(Level.ERROR, "Broadcast plugin exception", (Throwable)e);
            JSONObject jsonObject = QueryResults.defaultResult();
            renderer.setJSONObject(jsonObject);
            jsonObject.put("msg", (Object)"Broadcast plugin exception");
        }
    }

    @RequestProcessing(value={"/console/plugins/b3log-broadcast/chance"}, method={HTTPRequestMethod.GET})
    public void hasChance(HTTPRequestContext context, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!this.userQueryService.isLoggedIn(request, response)) {
            response.sendError(403);
            return;
        }
        JSONRenderer renderer = new JSONRenderer();
        context.setRenderer((AbstractHTTPResponseRenderer)renderer);
        JSONObject ret = new JSONObject();
        renderer.setJSONObject(ret);
        if (!this.userQueryService.isAdminLoggedIn(request)) {
            ret.put("broadcastChanceExpirationTime", 0L);
            ret.put("sc", false);
            return;
        }
        try {
            JSONObject option = this.optionQueryService.getOptionById("broadcastChanceExpirationTime");
            if (null == option) {
                ret.put("broadcastChanceExpirationTime", 0L);
                ret.put("sc", false);
                return;
            }
            ret.put("broadcastChanceExpirationTime", option.getLong("optionValue"));
            ret.put("sc", true);
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Broadcast plugin exception", (Throwable)e);
            JSONObject jsonObject = QueryResults.defaultResult();
            renderer.setJSONObject(jsonObject);
        }
    }

    @RequestProcessing(value={"/console/plugins/b3log-broadcast"}, method={HTTPRequestMethod.POST})
    public void submitBroadcast(HTTPRequestContext context, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!this.userQueryService.isAdminLoggedIn(request)) {
            response.sendError(403);
            return;
        }
        JSONRenderer renderer = new JSONRenderer();
        context.setRenderer((AbstractHTTPResponseRenderer)renderer);
        JSONObject ret = new JSONObject();
        renderer.setJSONObject(ret);
        try {
            JSONObject requestJSONObject = Requests.parseRequestJSONObject((HttpServletRequest)request, (HttpServletResponse)response);
            JSONObject broadcast = requestJSONObject.getJSONObject("broadcast");
            JSONObject preference = this.preferenceQueryService.getPreference();
            String b3logKey = preference.getString("keyOfSolo");
            String email = preference.getString("adminEmail");
            String clientName = "B3log Solo";
            String clientVersion = "1.0.0";
            String clientTitle = preference.getString("blogTitle");
            String clientRuntimeEnv = Latkes.getRuntimeEnv().name();
            JSONObject broadcastRequest = new JSONObject();
            broadcastRequest.put("b3logKey", (Object)b3logKey);
            broadcastRequest.put("email", (Object)email);
            broadcastRequest.put("broadcast", (Object)broadcast);
            broadcastRequest.put("clientRuntimeEnv", (Object)clientRuntimeEnv);
            broadcastRequest.put("clientTitle", (Object)clientTitle);
            broadcastRequest.put("clientVersion", (Object)"1.0.0");
            broadcastRequest.put("clientName", (Object)"B3log Solo");
            broadcastRequest.put("clientHost", (Object)Latkes.getServePath());
            HTTPRequest httpRequest = new HTTPRequest();
            httpRequest.setURL(ADD_BROADCAST_URL);
            httpRequest.setRequestMethod(HTTPRequestMethod.POST);
            httpRequest.setPayload(broadcastRequest.toString().getBytes("UTF-8"));
            Future future = this.urlFetchService.fetchAsync(httpRequest);
            HTTPResponse result = (HTTPResponse)future.get();
            if (200 == result.getResponseCode()) {
                ret.put("sc", true);
                this.optionMgmtService.removeOption("broadcastChanceExpirationTime");
                LOGGER.info("Submits broadcast successfully");
                return;
            }
            ret.put("sc", false);
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Submits broadcast failed", (Throwable)e);
            JSONObject jsonObject = QueryResults.defaultResult();
            renderer.setJSONObject(jsonObject);
            jsonObject.put("msg", (Object)e.getMessage());
        }
    }

    static {
        try {
            ADD_BROADCAST_URL = new URL(SoloServletListener.B3LOG_RHYTHM_SERVE_PATH + "/broadcast");
        }
        catch (MalformedURLException e) {
            LOGGER.log(Level.ERROR, "Creates remote service address[rhythm add broadcast] error!", new Object[0]);
            throw new IllegalStateException(e);
        }
    }
}

