/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.solo.model.feed.rss;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.time.DateFormatUtils;
import org.b3log.solo.model.feed.rss.Item;

public final class Channel {
    private String title;
    private String link;
    private String atomLink;
    private String description;
    private String generator;
    private Date lastBuildDate;
    private String language;
    private List<Item> items = new ArrayList<Item>();
    public static final String TIME_ZONE_ID = "Asia/Shanghai";
    private static final String START = "<?xml version='1.0' encoding='UTF-8'?><rss version=\"2.0\" xmlns:atom=\"http://www.w3.org/2005/Atom\"><channel>";
    private static final String END = "</channel></rss>";
    private static final String START_TITLE_ELEMENT = "<title>";
    private static final String END_TITLE_ELEMENT = "</title>";
    private static final String START_LINK_ELEMENT = "<link>";
    private static final String ATOM_LINK_VARIABLE = "${atomLink}";
    private static final String END_LINK_ELEMENT = "</link>";
    private static final String ATOM_LINK_ELEMENT = "<atom:link href=\"${atomLink}\" rel=\"self\" type=\"application/rss+xml\" />";
    private static final String START_DESCRIPTION_ELEMENT = "<description>";
    private static final String END_DESCRIPTION_ELEMENT = "</description>";
    private static final String START_GENERATOR_ELEMENT = "<generator>";
    private static final String END_GENERATOR_ELEMENT = "</generator>";
    private static final String START_LANGUAGE_ELEMENT = "<language>";
    private static final String END_LANGUAGE_ELEMENT = "</language>";
    private static final String START_LAST_BUILD_DATE_ELEMENT = "<lastBuildDate>";
    private static final String END_LAST_BUILD_DATE_ELEMENT = "</lastBuildDate>";

    public void setAtomLink(String atomLink) {
        this.atomLink = atomLink;
    }

    public String getAtomLink() {
        return this.atomLink;
    }

    public Date getLastBuildDate() {
        return this.lastBuildDate;
    }

    public void setLastBuildDate(Date lastBuildDate) {
        this.lastBuildDate = lastBuildDate;
    }

    public String getGenerator() {
        return this.generator;
    }

    public void setGenerator(String generator) {
        this.generator = generator;
    }

    public String getLink() {
        return this.link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void addItem(Item item) {
        this.items.add(item);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(START);
        stringBuilder.append(START_TITLE_ELEMENT);
        stringBuilder.append(this.title);
        stringBuilder.append(END_TITLE_ELEMENT);
        stringBuilder.append(START_LINK_ELEMENT);
        stringBuilder.append(this.link);
        stringBuilder.append(END_LINK_ELEMENT);
        stringBuilder.append(ATOM_LINK_ELEMENT.replace(ATOM_LINK_VARIABLE, this.atomLink));
        stringBuilder.append(START_DESCRIPTION_ELEMENT);
        stringBuilder.append(this.description);
        stringBuilder.append(END_DESCRIPTION_ELEMENT);
        stringBuilder.append(START_GENERATOR_ELEMENT);
        stringBuilder.append(this.generator);
        stringBuilder.append(END_GENERATOR_ELEMENT);
        stringBuilder.append(START_LAST_BUILD_DATE_ELEMENT);
        stringBuilder.append(DateFormatUtils.SMTP_DATETIME_FORMAT.format(this.lastBuildDate));
        stringBuilder.append(END_LAST_BUILD_DATE_ELEMENT);
        stringBuilder.append(START_LANGUAGE_ELEMENT);
        stringBuilder.append(this.language);
        stringBuilder.append(END_LANGUAGE_ELEMENT);
        for (Item item : this.items) {
            stringBuilder.append(item.toString());
        }
        stringBuilder.append(END);
        return stringBuilder.toString();
    }
}

