/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.solo.model.feed.atom;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.apache.commons.lang.time.DateFormatUtils;
import org.b3log.solo.model.feed.atom.Entry;

public final class Feed {
    private String id;
    private String title;
    private String subtitle;
    private Date updated;
    private String author;
    private String link;
    private List<Entry> entries = new ArrayList<Entry>();
    private static final String LINK_VARIABLE = "${link}";
    public static final String TIME_ZONE_ID = "Asia/Shanghai";
    private static final String START_DOCUMENT = "<?xml version=\"1.0\"?>";
    private static final String START_FEED_ELEMENT = "<feed xmlns=\"http://www.w3.org/2005/Atom\">";
    private static final String END_FEED_ELEMENT = "</feed>";
    private static final String START_ID_ELEMENT = "<id>";
    private static final String END_ID_ELEMENT = "</id>";
    private static final String START_TITLE_ELEMENT = "<title type=\"text\">";
    private static final String END_TITLE_ELEMENT = "</title>";
    private static final String START_SUBTITLE_ELEMENT = "<subtitle type=\"text\"> ";
    private static final String END_SUBTITLE_ELEMENT = "</subtitle>";
    private static final String START_UPDATED_ELEMENT = "<updated>";
    private static final String END_UPDATED_ELEMENT = "</updated>";
    private static final String START_AUTHOR_ELEMENT = "<author>";
    private static final String END_AUTHOR_ELEMENT = "</author>";
    private static final String START_NAME_ELEMENT = "<name>";
    private static final String END_NAME_ELEMENT = "</name>";
    private static final String LINK_ELEMENT = "<link href=\"${link}\" rel=\"self\" type=\"application/atom+xml\" />";

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getLink() {
        return this.link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getSubtitle() {
        return this.subtitle;
    }

    public void setSubtitle(String subtitle) {
        this.subtitle = subtitle;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public Date getUpdated() {
        return this.updated;
    }

    public void setUpdated(Date updated) {
        this.updated = updated;
    }

    public void addEntry(Entry entry) {
        this.entries.add(entry);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(START_DOCUMENT);
        stringBuilder.append(START_FEED_ELEMENT);
        stringBuilder.append(START_ID_ELEMENT);
        stringBuilder.append(this.id);
        stringBuilder.append(END_ID_ELEMENT);
        stringBuilder.append(START_TITLE_ELEMENT);
        stringBuilder.append(this.title);
        stringBuilder.append(END_TITLE_ELEMENT);
        stringBuilder.append(START_SUBTITLE_ELEMENT);
        stringBuilder.append(this.subtitle);
        stringBuilder.append(END_SUBTITLE_ELEMENT);
        stringBuilder.append(START_UPDATED_ELEMENT);
        stringBuilder.append(DateFormatUtils.format((Date)this.updated, (String)DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.getPattern(), (TimeZone)TimeZone.getTimeZone(TIME_ZONE_ID)));
        stringBuilder.append(END_UPDATED_ELEMENT);
        stringBuilder.append(START_AUTHOR_ELEMENT);
        stringBuilder.append(START_NAME_ELEMENT);
        stringBuilder.append(this.author);
        stringBuilder.append(END_NAME_ELEMENT);
        stringBuilder.append(END_AUTHOR_ELEMENT);
        stringBuilder.append(LINK_ELEMENT.replace(LINK_VARIABLE, this.link));
        for (Entry entry : this.entries) {
            stringBuilder.append(entry.toString());
        }
        stringBuilder.append(END_FEED_ELEMENT);
        return stringBuilder.toString();
    }
}

