/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.solo.model.feed.atom;

import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.TimeZone;
import org.apache.commons.lang.time.DateFormatUtils;
import org.b3log.solo.model.feed.atom.Category;

public final class Entry {
    private static final String LINK_VARIABLE = "${link}";
    private static final String START_TITLE_ELEMENT = "<title type=\"text\">";
    private static final String END_TITLE_ELEMENT = "</title>";
    private static final String START_AUTHOR_ELEMENT = "<author>";
    private static final String END_AUTHOR_ELEMENT = "</author>";
    private static final String START_NAME_ELEMENT = "<name>";
    private static final String END_NAME_ELEMENT = "</name>";
    private static final String START_URI_ELEMENT = "<uri>";
    private static final String END_URI_ELEMENT = "</uri>";
    private static final String START_ENTRY_ELEMENT = "<entry>";
    private static final String END_ENTRY_ELEMENT = "</entry>";
    private static final String START_ID_ELEMENT = "<id>";
    private static final String END_ID_ELEMENT = "</id>";
    private static final String START_SUMMARY_ELEMENT = "<summary type=\"html\">";
    private static final String END_SUMMARY_ELEMENT = "</summary>";
    private static final String LINK_ELEMENT = "<link href=\"${link}\" />";
    private static final String START_UPDATED_ELEMENT = "<updated>";
    private static final String END_UPDATED_ELEMENT = "</updated>";
    private String id;
    private Date updated;
    private String title;
    private String summary;
    private String link;
    private String author;
    private String uri;
    private Set<Category> categories = new HashSet<Category>();

    public String getURI() {
        return this.uri;
    }

    public void setURI(String uri) {
        this.uri = uri;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getLink() {
        return this.link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Date getUpdated() {
        return this.updated;
    }

    public void setUpdated(Date updated) {
        this.updated = updated;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public Set<Category> getCatetories() {
        return Collections.unmodifiableSet(this.categories);
    }

    public void addCatetory(Category category) {
        this.categories.add(category);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(START_ENTRY_ELEMENT).append(START_TITLE_ELEMENT);
        stringBuilder.append(this.title);
        stringBuilder.append(END_TITLE_ELEMENT);
        stringBuilder.append(START_AUTHOR_ELEMENT);
        stringBuilder.append(START_NAME_ELEMENT);
        stringBuilder.append(this.author);
        stringBuilder.append(END_NAME_ELEMENT);
        stringBuilder.append(START_URI_ELEMENT);
        stringBuilder.append(this.uri);
        stringBuilder.append(END_URI_ELEMENT);
        stringBuilder.append(END_AUTHOR_ELEMENT);
        for (Category category : this.categories) {
            stringBuilder.append(category.toString());
        }
        stringBuilder.append(LINK_ELEMENT.replace(LINK_VARIABLE, this.link));
        stringBuilder.append(START_ID_ELEMENT);
        stringBuilder.append(this.id);
        stringBuilder.append(END_ID_ELEMENT);
        stringBuilder.append(START_UPDATED_ELEMENT);
        stringBuilder.append(DateFormatUtils.format((Date)this.updated, (String)DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.getPattern(), (TimeZone)TimeZone.getTimeZone("Asia/Shanghai")));
        stringBuilder.append(END_UPDATED_ELEMENT);
        stringBuilder.append(START_SUMMARY_ELEMENT);
        stringBuilder.append(this.summary);
        stringBuilder.append(END_SUMMARY_ELEMENT);
        stringBuilder.append(END_ENTRY_ELEMENT);
        return stringBuilder.toString();
    }
}

