/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.solo.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.b3log.latke.ioc.LatkeBeanManager;
import org.b3log.latke.ioc.Lifecycle;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.solo.service.UserMgmtService;
import org.b3log.solo.service.UserQueryService;
import org.json.JSONObject;

public final class AuthFilter
implements Filter {
    private static final Logger LOGGER = Logger.getLogger((String)AuthFilter.class.getName());

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        LatkeBeanManager beanManager = Lifecycle.getBeanManager();
        UserMgmtService userMgmtService = (UserMgmtService)beanManager.getReference(UserMgmtService.class);
        UserQueryService userQueryService = (UserQueryService)beanManager.getReference(UserQueryService.class);
        try {
            userMgmtService.tryLogInWithCookie(httpServletRequest, httpServletResponse);
            JSONObject currentUser = userQueryService.getCurrentUser(httpServletRequest);
            if (null == currentUser) {
                LOGGER.warn("The request has been forbidden");
                httpServletResponse.sendError(403);
                return;
            }
            String userRole = currentUser.optString("userRole");
            if ("visitorRole".equals(userRole)) {
                LOGGER.warn("The request [Visitor] has been forbidden");
                httpServletResponse.sendError(403);
                return;
            }
            chain.doFilter(request, response);
        }
        catch (IOException e) {
            LOGGER.log(Level.ERROR, "Auth filter failed", (Throwable)e);
            httpServletResponse.sendError(404);
        }
    }

    public void destroy() {
    }
}

