/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.solo.event.rhythm;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import org.b3log.latke.Keys;
import org.b3log.latke.Latkes;
import org.b3log.latke.event.AbstractEventListener;
import org.b3log.latke.event.Event;
import org.b3log.latke.event.EventException;
import org.b3log.latke.ioc.LatkeBeanManager;
import org.b3log.latke.ioc.Lifecycle;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.servlet.HTTPRequestMethod;
import org.b3log.latke.urlfetch.HTTPRequest;
import org.b3log.latke.urlfetch.URLFetchService;
import org.b3log.latke.urlfetch.URLFetchServiceFactory;
import org.b3log.latke.util.Strings;
import org.b3log.solo.SoloServletListener;
import org.b3log.solo.service.PreferenceQueryService;
import org.json.JSONObject;

public final class ArticleSender
extends AbstractEventListener<JSONObject> {
    private static final Logger LOGGER = Logger.getLogger((String)ArticleSender.class.getName());
    private final URLFetchService urlFetchService = URLFetchServiceFactory.getURLFetchService();
    private static final URL ADD_ARTICLE_URL;

    public void action(Event<JSONObject> event) throws EventException {
        JSONObject data = (JSONObject)event.getData();
        LOGGER.log(Level.DEBUG, "Processing an event[type={0}, data={1}] in listener[className={2}]", new Object[]{event.getType(), data, ArticleSender.class.getName()});
        try {
            JSONObject originalArticle = data.getJSONObject("article");
            if (!originalArticle.getBoolean("articleIsPublished")) {
                LOGGER.log(Level.DEBUG, "Ignores post article[title={0}] to Rhythm", new Object[]{originalArticle.getString("articleTitle")});
                return;
            }
            LatkeBeanManager beanManager = Lifecycle.getBeanManager();
            PreferenceQueryService preferenceQueryService = (PreferenceQueryService)beanManager.getReference(PreferenceQueryService.class);
            JSONObject preference = preferenceQueryService.getPreference();
            if (null == preference) {
                throw new EventException("Not found preference");
            }
            if (!Strings.isEmptyOrNull((String)originalArticle.optString("articleViewPwd"))) {
                return;
            }
            if (Latkes.getServePath().contains("localhost")) {
                LOGGER.log(Level.INFO, "Solo runs on local server, so should not send this article[id={0}, title={1}] to Rhythm", new Object[]{originalArticle.getString(Keys.OBJECT_ID), originalArticle.getString("articleTitle")});
                return;
            }
            HTTPRequest httpRequest = new HTTPRequest();
            httpRequest.setURL(ADD_ARTICLE_URL);
            httpRequest.setRequestMethod(HTTPRequestMethod.POST);
            JSONObject requestJSONObject = new JSONObject();
            JSONObject article = new JSONObject();
            article.put(Keys.OBJECT_ID, (Object)originalArticle.getString(Keys.OBJECT_ID));
            article.put("articleTitle", (Object)originalArticle.getString("articleTitle"));
            article.put("articlePermalink", (Object)originalArticle.getString("articlePermalink"));
            article.put("articleTags", (Object)originalArticle.getString("articleTags"));
            article.put("articleAuthorEmail", (Object)originalArticle.getString("articleAuthorEmail"));
            article.put("articleContent", (Object)originalArticle.getString("articleContent"));
            article.put("articleCreateDate", ((Date)originalArticle.get("articleCreateDate")).getTime());
            article.put("postToCommunity", originalArticle.getBoolean("postToCommunity"));
            originalArticle.remove("postToCommunity");
            requestJSONObject.put("article", (Object)article);
            requestJSONObject.put("blogVersion", (Object)"1.0.0");
            requestJSONObject.put("blog", (Object)"B3log Solo");
            requestJSONObject.put("blogTitle", (Object)preference.getString("blogTitle"));
            requestJSONObject.put("blogHost", (Object)Latkes.getServePath());
            requestJSONObject.put("userB3Key", (Object)preference.optString("keyOfSolo"));
            requestJSONObject.put("clientAdminEmail", (Object)preference.optString("adminEmail"));
            requestJSONObject.put("clientRuntimeEnv", (Object)Latkes.getRuntimeEnv().name());
            httpRequest.setPayload(requestJSONObject.toString().getBytes("UTF-8"));
            this.urlFetchService.fetchAsync(httpRequest);
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Sends an article to Rhythm error: {0}", new Object[]{e.getMessage()});
        }
        LOGGER.log(Level.DEBUG, "Sent an article to Rhythm", new Object[0]);
    }

    public String getEventType() {
        return "Add Article";
    }

    static {
        try {
            ADD_ARTICLE_URL = new URL(SoloServletListener.B3LOG_RHYTHM_SERVE_PATH + "/article");
        }
        catch (MalformedURLException e) {
            LOGGER.log(Level.ERROR, "Creates remote service address[rhythm add article] error!", new Object[0]);
            throw new IllegalStateException(e);
        }
    }
}

