/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.solo.event.plugin;

import java.util.List;
import org.b3log.latke.event.AbstractEventListener;
import org.b3log.latke.event.Event;
import org.b3log.latke.event.EventException;
import org.b3log.latke.ioc.LatkeBeanManager;
import org.b3log.latke.ioc.Lifecycle;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.plugin.AbstractPlugin;
import org.b3log.latke.repository.Transaction;
import org.b3log.solo.repository.PluginRepository;
import org.b3log.solo.repository.impl.PluginRepositoryImpl;
import org.b3log.solo.service.PluginMgmtService;

public final class PluginRefresher
extends AbstractEventListener<List<AbstractPlugin>> {
    private static final Logger LOGGER = Logger.getLogger((String)PluginRefresher.class.getName());

    public void action(Event<List<AbstractPlugin>> event) throws EventException {
        List plugins = (List)event.getData();
        LOGGER.log(Level.DEBUG, "Processing an event[type={0}, data={1}] in listener[className={2}]", new Object[]{event.getType(), plugins, PluginRefresher.class.getName()});
        LatkeBeanManager beanManager = Lifecycle.getBeanManager();
        PluginRepository pluginRepository = (PluginRepository)beanManager.getReference(PluginRepositoryImpl.class);
        Transaction transaction = pluginRepository.beginTransaction();
        try {
            PluginMgmtService pluginMgmtService = (PluginMgmtService)beanManager.getReference(PluginMgmtService.class);
            pluginMgmtService.refresh(plugins);
            transaction.commit();
        }
        catch (Exception e) {
            if (transaction.isActive()) {
                transaction.rollback();
            }
            LOGGER.log(Level.ERROR, "Processing plugin loaded event error", (Throwable)e);
            throw new EventException((Throwable)e);
        }
    }

    public String getEventType() {
        return "pluginLoadedEvt";
    }
}

