/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.solo.event.ping;

import java.net.URL;
import java.net.URLEncoder;
import org.b3log.latke.Latkes;
import org.b3log.latke.event.AbstractEventListener;
import org.b3log.latke.event.Event;
import org.b3log.latke.event.EventException;
import org.b3log.latke.ioc.LatkeBeanManager;
import org.b3log.latke.ioc.Lifecycle;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.urlfetch.HTTPRequest;
import org.b3log.latke.urlfetch.URLFetchService;
import org.b3log.latke.urlfetch.URLFetchServiceFactory;
import org.b3log.solo.service.PreferenceQueryService;
import org.json.JSONObject;

public final class UpdateArticleGoogleBlogSearchPinger
extends AbstractEventListener<JSONObject> {
    private static final Logger LOGGER = Logger.getLogger((String)UpdateArticleGoogleBlogSearchPinger.class.getName());
    private static final URLFetchService URL_FETCH_SERVICE = URLFetchServiceFactory.getURLFetchService();

    public String getEventType() {
        return "Update Article";
    }

    public void action(Event<JSONObject> event) throws EventException {
        JSONObject eventData = (JSONObject)event.getData();
        String articleTitle = null;
        LatkeBeanManager beanManager = Lifecycle.getBeanManager();
        PreferenceQueryService preferenceQueryService = (PreferenceQueryService)beanManager.getReference(PreferenceQueryService.class);
        try {
            JSONObject article = eventData.getJSONObject("article");
            articleTitle = article.getString("articleTitle");
            JSONObject preference = preferenceQueryService.getPreference();
            String blogTitle = preference.getString("blogTitle");
            if (Latkes.getServePath().contains("localhost")) {
                LOGGER.log(Level.INFO, "Blog Solo runs on local server, so should not ping Google Blog Search Service for the article[title={0}]", new Object[]{article.getString("articleTitle")});
                return;
            }
            String articlePermalink = Latkes.getServePath() + article.getString("articlePermalink");
            String spec = "http://blogsearch.google.com/ping?name=" + URLEncoder.encode(blogTitle, "UTF-8") + "&url=" + URLEncoder.encode(Latkes.getServePath(), "UTF-8") + "&changesURL=" + URLEncoder.encode(articlePermalink, "UTF-8");
            LOGGER.log(Level.DEBUG, "Request Google Blog Search Service API[{0}] while updateing an article[title=" + articleTitle + "]", new Object[]{spec});
            HTTPRequest request = new HTTPRequest();
            request.setURL(new URL(spec));
            URL_FETCH_SERVICE.fetchAsync(request);
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Ping Google Blog Search Service fail while updating an article[title=" + articleTitle + "]", (Throwable)e);
        }
    }
}

