/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.solo.api.symphony;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.time.DateFormatUtils;
import org.b3log.latke.Keys;
import org.b3log.latke.event.Event;
import org.b3log.latke.event.EventManager;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.repository.Transaction;
import org.b3log.latke.service.ServiceException;
import org.b3log.latke.servlet.HTTPRequestContext;
import org.b3log.latke.servlet.HTTPRequestMethod;
import org.b3log.latke.servlet.annotation.RequestProcessing;
import org.b3log.latke.servlet.annotation.RequestProcessor;
import org.b3log.latke.servlet.renderer.AbstractHTTPResponseRenderer;
import org.b3log.latke.servlet.renderer.JSONRenderer;
import org.b3log.latke.urlfetch.URLFetchService;
import org.b3log.latke.urlfetch.URLFetchServiceFactory;
import org.b3log.latke.util.Requests;
import org.b3log.latke.util.Strings;
import org.b3log.solo.SoloServletListener;
import org.b3log.solo.repository.ArticleRepository;
import org.b3log.solo.repository.CommentRepository;
import org.b3log.solo.service.ArticleMgmtService;
import org.b3log.solo.service.CommentMgmtService;
import org.b3log.solo.service.PreferenceQueryService;
import org.b3log.solo.service.StatisticMgmtService;
import org.b3log.solo.util.Comments;
import org.b3log.solo.util.QueryResults;
import org.json.JSONObject;

@RequestProcessor
public class CommentReceiver {
    private static final Logger LOGGER = Logger.getLogger((String)CommentReceiver.class.getName());
    @Inject
    private CommentMgmtService commentMgmtService;
    @Inject
    private static CommentRepository commentRepository;
    @Inject
    private PreferenceQueryService preferenceQueryService;
    @Inject
    private ArticleMgmtService articleMgmtService;
    @Inject
    private ArticleRepository articleRepository;
    private static final String DEFAULT_USER_THUMBNAIL = "default-user-thumbnail.png";
    private static URLFetchService urlFetchService;
    @Inject
    private static EventManager eventManager;
    @Inject
    private StatisticMgmtService statisticMgmtService;

    @RequestProcessing(value={"/apis/symphony/comment"}, method={HTTPRequestMethod.PUT})
    public void addComment(HttpServletRequest request, HttpServletResponse response, HTTPRequestContext context) throws Exception {
        JSONRenderer renderer = new JSONRenderer();
        context.setRenderer((AbstractHTTPResponseRenderer)renderer);
        JSONObject ret = new JSONObject();
        renderer.setJSONObject(ret);
        Transaction transaction = commentRepository.beginTransaction();
        try {
            JSONObject requestJSONObject = Requests.parseRequestJSONObject((HttpServletRequest)request, (HttpServletResponse)response);
            JSONObject symphonyCmt = requestJSONObject.optJSONObject("comment");
            JSONObject preference = this.preferenceQueryService.getPreference();
            String keyOfSolo = preference.optString("keyOfSolo");
            String key = symphonyCmt.optString("userB3Key");
            if (Strings.isEmptyOrNull((String)keyOfSolo) || !keyOfSolo.equals(key)) {
                ret.put("sc", 403);
                ret.put("msg", (Object)"Wrong key");
                return;
            }
            String articleId = symphonyCmt.getString("commentOnArticleId");
            JSONObject article = this.articleRepository.get(articleId);
            if (null == article) {
                ret.put("sc", 404);
                ret.put("msg", (Object)("Not found the specified article[id=" + articleId + "]"));
                return;
            }
            String commentName = symphonyCmt.getString("commentAuthorName");
            String commentEmail = symphonyCmt.getString("commentAuthorEmail").trim().toLowerCase();
            String commentURL = symphonyCmt.optString("commentAuthorURL");
            if (!commentURL.contains("://")) {
                commentURL = "http://" + commentURL;
            }
            try {
                new URL(commentURL);
            }
            catch (MalformedURLException e) {
                LOGGER.log(Level.WARN, "The comment URL is invalid [{0}]", new Object[]{commentURL});
                commentURL = "";
            }
            String commentId = symphonyCmt.optString(Keys.OBJECT_ID);
            String commentContent = symphonyCmt.getString("commentContent");
            commentContent = commentContent + "<p class='cmtFromSym'><i>\u8be5\u8bc4\u8bba\u540c\u6b65\u81ea <a href='" + SoloServletListener.B3LOG_SYMPHONY_SERVE_PATH + "/article/" + symphonyCmt.optString("commentSymphonyArticleId") + "#" + commentId + "' target='_blank'>\u9ed1\u5ba2\u6d3e</a></i></p>";
            String originalCommentId = symphonyCmt.optString("commentOriginalCommentId");
            JSONObject comment = new JSONObject();
            JSONObject originalComment = null;
            comment.put(Keys.OBJECT_ID, (Object)commentId);
            comment.put("commentName", (Object)commentName);
            comment.put("commentEmail", (Object)commentEmail);
            comment.put("commentURL", (Object)commentURL);
            comment.put("commentContent", (Object)commentContent);
            Date date = new Date();
            comment.put("commentDate", (Object)date);
            ret.put("commentDate", (Object)DateFormatUtils.format((Date)date, (String)"yyyy-MM-dd hh:mm:ss"));
            if (!Strings.isEmptyOrNull((String)originalCommentId)) {
                originalComment = commentRepository.get(originalCommentId);
                if (null != originalComment) {
                    comment.put("commentOriginalCommentId", (Object)originalCommentId);
                    String originalCommentName = originalComment.getString("commentName");
                    comment.put("commentOriginalCommentName", (Object)originalCommentName);
                    ret.put("commentOriginalCommentName", (Object)originalCommentName);
                } else {
                    comment.put("commentOriginalCommentId", (Object)"");
                    comment.put("commentOriginalCommentName", (Object)"");
                    LOGGER.log(Level.WARN, "Not found orginal comment[id={0}] of reply[name={1}, content={2}]", (Object[])new String[]{originalCommentId, commentName, commentContent});
                }
            } else {
                comment.put("commentOriginalCommentId", (Object)"");
                comment.put("commentOriginalCommentName", (Object)"");
            }
            CommentMgmtService.setCommentThumbnailURL(comment);
            ret.put("commentThumbnailURL", (Object)comment.getString("commentThumbnailURL"));
            comment.put("commentOnId", (Object)articleId);
            comment.put("commentOnType", (Object)"article");
            String commentSharpURL = Comments.getCommentSharpURLForArticle(article, commentId);
            comment.put("commentSharpURL", (Object)commentSharpURL);
            commentRepository.add(comment);
            this.articleMgmtService.incArticleCommentCount(articleId);
            this.statisticMgmtService.incBlogCommentCount();
            this.statisticMgmtService.incPublishedBlogCommentCount();
            try {
                this.commentMgmtService.sendNotificationMail(article, comment, originalComment, preference);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARN, "Send mail failed", (Throwable)e);
            }
            JSONObject eventData = new JSONObject();
            eventData.put("comment", (Object)comment);
            eventData.put("article", (Object)article);
            eventManager.fireEventSynchronously(new Event("Add Comment To Article From Symphony", (Object)eventData));
            transaction.commit();
            ret.put("sc", true);
            ret.put(Keys.OBJECT_ID, (Object)commentId);
            ret.put(Keys.OBJECT_ID, (Object)articleId);
            ret.put("msg", (Object)"add a comment to an article from symphony succ");
            ret.put("sc", true);
            renderer.setJSONObject(ret);
        }
        catch (ServiceException e) {
            LOGGER.log(Level.ERROR, e.getMessage(), (Throwable)e);
            JSONObject jsonObject = QueryResults.defaultResult();
            renderer.setJSONObject(jsonObject);
            jsonObject.put("msg", (Object)e.getMessage());
        }
    }

    static {
        urlFetchService = URLFetchServiceFactory.getURLFetchService();
    }
}

