/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.solo.api.symphony;

import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.b3log.latke.Keys;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.service.ServiceException;
import org.b3log.latke.servlet.HTTPRequestContext;
import org.b3log.latke.servlet.HTTPRequestMethod;
import org.b3log.latke.servlet.annotation.RequestProcessing;
import org.b3log.latke.servlet.annotation.RequestProcessor;
import org.b3log.latke.servlet.renderer.AbstractHTTPResponseRenderer;
import org.b3log.latke.servlet.renderer.JSONRenderer;
import org.b3log.latke.util.Requests;
import org.b3log.solo.service.ArticleMgmtService;
import org.b3log.solo.service.ArticleQueryService;
import org.b3log.solo.service.PreferenceQueryService;
import org.b3log.solo.service.UserQueryService;
import org.b3log.solo.util.QueryResults;
import org.json.JSONObject;
import org.jsoup.Jsoup;

@RequestProcessor
public class ArticleReceiver {
    private static final Logger LOGGER = Logger.getLogger((String)ArticleReceiver.class.getName());
    @Inject
    private PreferenceQueryService preferenceQueryService;
    @Inject
    private ArticleMgmtService articleMgmtService;
    @Inject
    private ArticleQueryService articleQueryService;
    @Inject
    private UserQueryService userQueryService;
    private static final int ARTICLE_ABSTRACT_LENGTH = 500;

    @RequestProcessing(value={"/apis/symphony/article"}, method={HTTPRequestMethod.POST})
    public void addArticle(HttpServletRequest request, HttpServletResponse response, HTTPRequestContext context) throws Exception {
        JSONRenderer renderer = new JSONRenderer();
        context.setRenderer((AbstractHTTPResponseRenderer)renderer);
        JSONObject ret = new JSONObject();
        try {
            JSONObject requestJSONObject = Requests.parseRequestJSONObject((HttpServletRequest)request, (HttpServletResponse)response);
            JSONObject article = requestJSONObject.optJSONObject("article");
            String userB3Key = article.optString("userB3Key");
            JSONObject preference = this.preferenceQueryService.getPreference();
            if (!userB3Key.equals(preference.optString("keyOfSolo"))) {
                LOGGER.log(Level.WARN, "B3 key not match, ignored add article", new Object[0]);
                return;
            }
            article.remove("userB3Key");
            JSONObject admin = this.userQueryService.getAdmin();
            article.put("articleAuthorEmail", (Object)admin.getString("userEmail"));
            String plainTextContent = Jsoup.parse((String)article.optString("articleContent")).text();
            if (plainTextContent.length() > 500) {
                article.put("articleAbstract", (Object)(plainTextContent.substring(0, 500) + "...."));
            } else {
                article.put("articleAbstract", (Object)plainTextContent);
            }
            article.put("articleIsPublished", true);
            article.put("postToCommunity", false);
            article.put("articleCommentable", true);
            article.put("articleViewPwd", (Object)"");
            String content = article.getString("articleContent");
            String articleId = article.getString(Keys.OBJECT_ID);
            content = content + "<br/><br/><p style='font-size: 12px;'><i>\u8be5\u6587\u7ae0\u540c\u6b65\u81ea <a href='http://hacpai.com/article/" + articleId + "' target='_blank'>\u9ed1\u5ba2\u6d3e</a></i></p>";
            article.put("articleContent", (Object)content);
            this.articleMgmtService.addArticle(requestJSONObject);
            ret.put(Keys.OBJECT_ID, (Object)articleId);
            ret.put("msg", (Object)"add article succ");
            ret.put("sc", true);
            renderer.setJSONObject(ret);
        }
        catch (ServiceException e) {
            LOGGER.log(Level.ERROR, e.getMessage(), (Throwable)e);
            JSONObject jsonObject = QueryResults.defaultResult();
            renderer.setJSONObject(jsonObject);
            jsonObject.put("msg", (Object)e.getMessage());
        }
    }

    @RequestProcessing(value={"/apis/symphony/article"}, method={HTTPRequestMethod.PUT})
    public void updateArticle(HttpServletRequest request, HttpServletResponse response, HTTPRequestContext context) throws Exception {
        JSONRenderer renderer = new JSONRenderer();
        context.setRenderer((AbstractHTTPResponseRenderer)renderer);
        JSONObject ret = new JSONObject();
        renderer.setJSONObject(ret);
        try {
            JSONObject requestJSONObject = Requests.parseRequestJSONObject((HttpServletRequest)request, (HttpServletResponse)response);
            JSONObject article = requestJSONObject.optJSONObject("article");
            String userB3Key = article.optString("userB3Key");
            JSONObject preference = this.preferenceQueryService.getPreference();
            if (!userB3Key.equals(preference.optString("keyOfSolo"))) {
                LOGGER.log(Level.WARN, "B3 key not match, ignored update article", new Object[0]);
                return;
            }
            article.remove("userB3Key");
            String articleId = article.getString(Keys.OBJECT_ID);
            if (null == this.articleQueryService.getArticleById(articleId)) {
                ret.put("msg", (Object)("No found article[oId=" + articleId + "] to update"));
                ret.put("sc", false);
                return;
            }
            String plainTextContent = Jsoup.parse((String)article.optString("articleContent")).text();
            if (plainTextContent.length() > 500) {
                article.put("articleAbstract", (Object)(plainTextContent.substring(0, 500) + "...."));
            } else {
                article.put("articleAbstract", (Object)plainTextContent);
            }
            article.put("articleIsPublished", true);
            article.put("postToCommunity", false);
            article.put("articleCommentable", true);
            article.put("articleViewPwd", (Object)"");
            String content = article.getString("articleContent");
            content = content + "<br/><br/><p style='font-size: 12px;'><i>\u8be5\u6587\u7ae0\u540c\u6b65\u81ea <a href='http://hacpai.com/article/" + articleId + "' target='_blank'>\u9ed1\u5ba2\u6d3e</a></i></p>";
            article.put("articleContent", (Object)content);
            this.articleMgmtService.updateArticle(requestJSONObject);
            ret.put("msg", (Object)"update article succ");
            ret.put("sc", true);
        }
        catch (ServiceException e) {
            LOGGER.log(Level.ERROR, e.getMessage(), (Throwable)e);
            JSONObject jsonObject = QueryResults.defaultResult();
            renderer.setJSONObject(jsonObject);
            jsonObject.put("msg", (Object)e.getMessage());
        }
    }
}

