/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.solo;

import java.util.ResourceBundle;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletRequestEvent;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import org.b3log.latke.event.AbstractEventListener;
import org.b3log.latke.event.EventManager;
import org.b3log.latke.ioc.LatkeBeanManager;
import org.b3log.latke.ioc.Lifecycle;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.plugin.PluginManager;
import org.b3log.latke.plugin.ViewLoadEventHandler;
import org.b3log.latke.repository.Transaction;
import org.b3log.latke.servlet.AbstractServletListener;
import org.b3log.latke.util.Requests;
import org.b3log.latke.util.Stopwatchs;
import org.b3log.latke.util.Strings;
import org.b3log.solo.event.comment.ArticleCommentReplyNotifier;
import org.b3log.solo.event.comment.PageCommentReplyNotifier;
import org.b3log.solo.event.plugin.PluginRefresher;
import org.b3log.solo.event.rhythm.ArticleSender;
import org.b3log.solo.event.rhythm.ArticleUpdater;
import org.b3log.solo.event.symphony.CommentSender;
import org.b3log.solo.repository.PreferenceRepository;
import org.b3log.solo.repository.impl.PreferenceRepositoryImpl;
import org.b3log.solo.service.PreferenceMgmtService;
import org.b3log.solo.service.StatisticMgmtService;
import org.b3log.solo.util.Skins;
import org.json.JSONObject;

public final class SoloServletListener
extends AbstractServletListener {
    public static final String VERSION = "1.0.0";
    private static final Logger LOGGER = Logger.getLogger((String)SoloServletListener.class.getName());
    public static final int JSON_PRINT_INDENT_FACTOR = 4;
    public static final String ENTER_ESC = "_esc_enter_88250_";
    public static final String B3LOG_RHYTHM_SERVE_PATH;
    public static final String B3LOG_SYMPHONY_SERVE_PATH;
    public static final String FAVICON_API;
    private LatkeBeanManager beanManager;

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        block3: {
            super.contextInitialized(servletContextEvent);
            this.beanManager = Lifecycle.getBeanManager();
            Stopwatchs.start((String)"Context Initialized");
            Skins.setDirectoryForTemplateLoading("finding");
            PreferenceRepository preferenceRepository = (PreferenceRepository)this.beanManager.getReference(PreferenceRepositoryImpl.class);
            Transaction transaction = preferenceRepository.beginTransaction();
            try {
                this.loadPreference();
                if (transaction.isActive()) {
                    transaction.commit();
                }
            }
            catch (Exception e) {
                if (!transaction.isActive()) break block3;
                transaction.rollback();
            }
        }
        this.registerEventProcessor();
        PluginManager pluginManager = (PluginManager)this.beanManager.getReference(PluginManager.class);
        pluginManager.load();
        LOGGER.info("Initialized the context");
        Stopwatchs.end();
        LOGGER.log(Level.DEBUG, "Stopwatch: {0}{1}", new Object[]{Strings.LINE_SEPARATOR, Stopwatchs.getTimingStat()});
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        super.contextDestroyed(servletContextEvent);
        LOGGER.info("Destroyed the context");
    }

    public void sessionCreated(HttpSessionEvent httpSessionEvent) {
    }

    public void sessionDestroyed(HttpSessionEvent httpSessionEvent) {
    }

    public void requestInitialized(ServletRequestEvent servletRequestEvent) {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequestEvent.getServletRequest();
        Requests.log((HttpServletRequest)httpServletRequest, (Level)Level.DEBUG, (Logger)LOGGER);
        String requestURI = httpServletRequest.getRequestURI();
        Stopwatchs.start((String)("Request Initialized[requestURI=" + requestURI + "]"));
        if (Requests.searchEngineBotRequest((HttpServletRequest)httpServletRequest)) {
            LOGGER.log(Level.DEBUG, "Request made from a search engine[User-Agent={0}]", new Object[]{httpServletRequest.getHeader("User-Agent")});
            httpServletRequest.setAttribute("isSearchEngineBot", (Object)true);
        } else {
            HttpSession session = httpServletRequest.getSession();
            LOGGER.log(Level.DEBUG, "Gets a session[id={0}, remoteAddr={1}, User-Agent={2}, isNew={3}]", new Object[]{session.getId(), httpServletRequest.getRemoteAddr(), httpServletRequest.getHeader("User-Agent"), session.isNew()});
            StatisticMgmtService statisticMgmtService = (StatisticMgmtService)this.beanManager.getReference(StatisticMgmtService.class);
            statisticMgmtService.onlineVisitorCount(httpServletRequest);
        }
        this.resolveSkinDir(httpServletRequest);
    }

    public void requestDestroyed(ServletRequestEvent servletRequestEvent) {
        Stopwatchs.end();
        LOGGER.log(Level.DEBUG, "Stopwatch: {0}{1}", new Object[]{Strings.LINE_SEPARATOR, Stopwatchs.getTimingStat()});
        Stopwatchs.release();
        super.requestDestroyed(servletRequestEvent);
    }

    private void loadPreference() {
        Stopwatchs.start((String)"Load Preference");
        LOGGER.info("Loading preference....");
        PreferenceRepository preferenceRepository = (PreferenceRepository)this.beanManager.getReference(PreferenceRepositoryImpl.class);
        try {
            JSONObject preference = preferenceRepository.get("preference");
            if (null == preference) {
                LOGGER.log(Level.WARN, "Can't not init default skin, please init Solo first", new Object[0]);
                return;
            }
            PreferenceMgmtService preferenceMgmtService = (PreferenceMgmtService)this.beanManager.getReference(PreferenceMgmtService.class);
            preferenceMgmtService.loadSkins(preference);
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, e.getMessage(), (Throwable)e);
            throw new IllegalStateException(e);
        }
        Stopwatchs.end();
    }

    private void registerEventProcessor() {
        Stopwatchs.start((String)"Register Event Processors");
        LOGGER.log(Level.INFO, "Registering event processors....", new Object[0]);
        try {
            EventManager eventManager = (EventManager)this.beanManager.getReference(EventManager.class);
            eventManager.registerListener((AbstractEventListener)new ArticleCommentReplyNotifier());
            eventManager.registerListener((AbstractEventListener)new PageCommentReplyNotifier());
            eventManager.registerListener((AbstractEventListener)new PluginRefresher());
            eventManager.registerListener((AbstractEventListener)new ViewLoadEventHandler());
            eventManager.registerListener((AbstractEventListener)new ArticleSender());
            eventManager.registerListener((AbstractEventListener)new ArticleUpdater());
            eventManager.registerListener((AbstractEventListener)new CommentSender());
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Register event processors error", (Throwable)e);
            throw new IllegalStateException(e);
        }
        LOGGER.log(Level.INFO, "Registering event processors....", new Object[0]);
        Stopwatchs.end();
    }

    private void resolveSkinDir(HttpServletRequest httpServletRequest) {
        try {
            PreferenceRepository preferenceRepository = (PreferenceRepository)this.beanManager.getReference(PreferenceRepositoryImpl.class);
            JSONObject preference = preferenceRepository.get("preference");
            if (null == preference) {
                return;
            }
            String requestURI = httpServletRequest.getRequestURI();
            String desiredView = Requests.mobileSwitchToggle((HttpServletRequest)httpServletRequest);
            if (desiredView == null && !Requests.mobileRequest((HttpServletRequest)httpServletRequest) || desiredView != null && desiredView.equals("normal")) {
                desiredView = preference.getString("skinDirName");
            } else {
                desiredView = "mobile";
                LOGGER.log(Level.DEBUG, "The request [URI={0}] comes frome mobile device", new Object[]{requestURI});
            }
            httpServletRequest.setAttribute("templateDirName", (Object)desiredView);
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Resolves skin failed", (Throwable)e);
        }
    }

    static {
        ResourceBundle b3log = ResourceBundle.getBundle("b3log");
        B3LOG_RHYTHM_SERVE_PATH = b3log.getString("rhythm.servePath");
        B3LOG_SYMPHONY_SERVE_PATH = b3log.getString("symphony.servePath");
        FAVICON_API = b3log.getString("faviconAPI");
    }
}

