/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.taskqueue.gae;

import com.google.appengine.api.taskqueue.QueueFactory;
import com.google.appengine.api.taskqueue.TaskOptions;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.servlet.HTTPRequestMethod;
import org.b3log.latke.taskqueue.Queue;
import org.b3log.latke.taskqueue.Task;
import org.b3log.latke.taskqueue.TaskHandle;
import org.b3log.latke.taskqueue.TaskQueueService;
import org.b3log.latke.taskqueue.gae.GAETaskHandle;

public final class GAETaskQueueService
implements TaskQueueService {
    private static final Logger LOGGER = Logger.getLogger((String)GAETaskQueueService.class.getName());

    public Queue getQueue(String queueName) {
        final com.google.appengine.api.taskqueue.Queue queue = QueueFactory.getQueue((String)queueName);
        return new Queue(){

            public TaskHandle add(Task task) {
                TaskOptions taskOptions = TaskOptions.Builder.withTaskName((String)task.getName()).url(task.getURL());
                HTTPRequestMethod requestMethod = task.getRequestMethod();
                switch (requestMethod) {
                    case GET: {
                        taskOptions.method(TaskOptions.Method.GET);
                        break;
                    }
                    case DELETE: {
                        taskOptions.method(TaskOptions.Method.DELETE);
                        break;
                    }
                    case HEAD: {
                        taskOptions.method(TaskOptions.Method.HEAD);
                        break;
                    }
                    case POST: {
                        taskOptions.payload(task.getPayload());
                        taskOptions.method(TaskOptions.Method.POST);
                        break;
                    }
                    case PUT: {
                        taskOptions.method(TaskOptions.Method.PUT);
                        break;
                    }
                    default: {
                        LOGGER.log(Level.WARN, "Task request method[{0}], uses GET method instead", new Object[]{requestMethod});
                        taskOptions.method(TaskOptions.Method.GET);
                    }
                }
                com.google.appengine.api.taskqueue.TaskHandle handle = queue.add(taskOptions);
                GAETaskHandle ret = new GAETaskHandle(handle);
                return ret;
            }
        };
    }
}

