/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.repository.gae;

import com.google.appengine.api.datastore.Cursor;
import com.google.appengine.api.datastore.DataTypeUtils;
import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.DatastoreServiceFactory;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.EntityNotFoundException;
import com.google.appengine.api.datastore.FetchOptions;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyFactory;
import com.google.appengine.api.datastore.PreparedQuery;
import com.google.appengine.api.datastore.PropertyProjection;
import com.google.appengine.api.datastore.Query;
import com.google.appengine.api.datastore.QueryResultList;
import com.google.appengine.api.datastore.Text;
import com.google.appengine.api.datastore.Transaction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.b3log.latke.Keys;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.repository.Blob;
import org.b3log.latke.repository.CompositeFilter;
import org.b3log.latke.repository.Filter;
import org.b3log.latke.repository.FilterOperator;
import org.b3log.latke.repository.Projection;
import org.b3log.latke.repository.PropertyFilter;
import org.b3log.latke.repository.Query;
import org.b3log.latke.repository.Repository;
import org.b3log.latke.repository.RepositoryException;
import org.b3log.latke.repository.SortDirection;
import org.b3log.latke.repository.gae.GAETransaction;
import org.b3log.latke.util.CollectionUtils;
import org.b3log.latke.util.Ids;
import org.b3log.latke.util.Strings;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class GAERepository
implements Repository {
    private static final Logger LOGGER = Logger.getLogger((String)GAERepository.class.getName());
    private final DatastoreService datastoreService = DatastoreServiceFactory.getDatastoreService();
    private static final Set<Class<?>> GAE_SUPPORTED_TYPES = DataTypeUtils.getSupportedTypes();
    private static final Key DEFAULT_PARENT_KEY = KeyFactory.createKey((String)"parentKind", (String)"parentKeyName");
    private boolean writable = true;
    private static final int QUERY_CHUNK_SIZE = 50;
    public static final ThreadLocal<GAETransaction> TX = new InheritableThreadLocal<GAETransaction>();
    private String name;

    public GAERepository(String name) {
        this.name = name;
    }

    public String add(JSONObject jsonObject) throws RepositoryException {
        GAETransaction currentTransaction = TX.get();
        if (null == currentTransaction) {
            throw new RepositoryException("Invoking add() outside a transaction");
        }
        return this.add(jsonObject, DEFAULT_PARENT_KEY.getKind(), DEFAULT_PARENT_KEY.getName());
    }

    private String add(JSONObject jsonObject, String parentKeyKind, String parentKeyName) throws RepositoryException {
        String ret = null;
        try {
            if (!jsonObject.has(Keys.OBJECT_ID)) {
                ret = GAERepository.genTimeMillisId();
                jsonObject.put(Keys.OBJECT_ID, (Object)ret);
            } else {
                ret = jsonObject.getString(Keys.OBJECT_ID);
            }
            Key parentKey = KeyFactory.createKey((String)parentKeyKind, (String)parentKeyName);
            Entity entity = new Entity(this.getName(), ret, parentKey);
            GAERepository.setProperties(entity, jsonObject);
            this.datastoreService.put(entity);
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, e.getMessage(), (Throwable)e);
            throw new RepositoryException((Throwable)e);
        }
        LOGGER.log(Level.DEBUG, "Added an object[oId={0}] in repository[{1}]", new Object[]{ret, this.getName()});
        return ret;
    }

    public void update(String id, JSONObject jsonObject) throws RepositoryException {
        if (Strings.isEmptyOrNull((String)id)) {
            return;
        }
        GAETransaction currentTransaction = TX.get();
        if (null == currentTransaction) {
            throw new RepositoryException("Invoking update() outside a transaction");
        }
        this.update(id, jsonObject, DEFAULT_PARENT_KEY.getKind(), DEFAULT_PARENT_KEY.getName());
    }

    private void update(String id, JSONObject jsonObject, String parentKeyKind, String parentKeyName) throws RepositoryException {
        try {
            jsonObject.put(Keys.OBJECT_ID, (Object)id);
            Key parentKey = KeyFactory.createKey((String)parentKeyKind, (String)parentKeyName);
            Entity entity = new Entity(this.getName(), id, parentKey);
            GAERepository.setProperties(entity, jsonObject);
            this.datastoreService.put(entity);
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, e.getMessage(), (Throwable)e);
            throw new RepositoryException((Throwable)e);
        }
        LOGGER.log(Level.DEBUG, "Updated an object[oId={0}] in repository[name={1}]", new Object[]{id, this.getName()});
    }

    public void remove(String id) throws RepositoryException {
        if (Strings.isEmptyOrNull((String)id)) {
            return;
        }
        GAETransaction currentTransaction = TX.get();
        if (null == currentTransaction) {
            throw new RepositoryException("Invoking remove() outside a transaction");
        }
        this.remove(id, DEFAULT_PARENT_KEY.getKind(), DEFAULT_PARENT_KEY.getName());
    }

    private void remove(String id, String parentKeyKind, String parentKeyName) throws RepositoryException {
        Key parentKey = KeyFactory.createKey((String)parentKeyKind, (String)parentKeyName);
        Key key = KeyFactory.createKey((Key)parentKey, (String)this.getName(), (String)id);
        this.datastoreService.delete(new Key[]{key});
        LOGGER.log(Level.DEBUG, "Removed an object[oId={0}] from repository[name={1}]", new Object[]{id, this.getName()});
    }

    public JSONObject get(String id) throws RepositoryException {
        LOGGER.log(Level.TRACE, "Getting with id[{0}]", new Object[]{id});
        if (Strings.isEmptyOrNull((String)id)) {
            return null;
        }
        return this.get(DEFAULT_PARENT_KEY, id);
    }

    public Map<String, JSONObject> get(Iterable<String> ids) throws RepositoryException {
        LOGGER.log(Level.TRACE, "Getting with ids[{0}]", new Object[]{ids});
        HashSet<Key> keys = new HashSet<Key>();
        for (String id : ids) {
            Key key = KeyFactory.createKey((Key)DEFAULT_PARENT_KEY, (String)this.getName(), (String)id);
            keys.add(key);
        }
        HashMap<String, JSONObject> ret = new HashMap<String, JSONObject>();
        Map map = this.datastoreService.get(keys);
        for (Map.Entry entry : map.entrySet()) {
            ret.put(((Key)entry.getKey()).getName(), GAERepository.entity2JSONObject((Entity)entry.getValue()));
        }
        LOGGER.log(Level.DEBUG, "Got objects[oIds={0}] from repository[name={1}]", new Object[]{ids, this.getName()});
        return ret;
    }

    private JSONObject get(Key parentKey, String id) throws RepositoryException {
        JSONObject ret;
        Key key = KeyFactory.createKey((Key)parentKey, (String)this.getName(), (String)id);
        try {
            Entity entity = this.datastoreService.get(key);
            ret = GAERepository.entity2JSONObject(entity);
            LOGGER.log(Level.DEBUG, "Got an object[oId={0}] from repository[name={1}]", new Object[]{id, this.getName()});
        }
        catch (EntityNotFoundException e) {
            LOGGER.log(Level.WARN, "Not found an object[oId={0}] in repository[name={1}]", new Object[]{id, this.getName()});
            return null;
        }
        return ret;
    }

    public boolean has(String id) throws RepositoryException {
        return null != this.get(id);
    }

    public JSONObject get(Query query) throws RepositoryException {
        LOGGER.log(Level.TRACE, "Executing a query[query=[{0}]]", new Object[]{query.toString()});
        int currentPageNum = query.getCurrentPageNum();
        Set projections = query.getProjections();
        Filter filter = query.getFilter();
        int pageSize = query.getPageSize();
        Map sorts = query.getSorts();
        int pageCount = -1;
        if (null != query.getPageCount()) {
            pageCount = query.getPageCount();
        }
        return this.get(currentPageNum, pageSize, pageCount, projections, sorts, filter);
    }

    private JSONObject get(int currentPageNum, int pageSize, int pageCount, Set<Projection> projections, Map<String, SortDirection> sorts, Filter filter) throws RepositoryException {
        com.google.appengine.api.datastore.Query query = new com.google.appengine.api.datastore.Query(this.getName());
        if (null != filter) {
            if (filter instanceof PropertyFilter) {
                Query.FilterPredicate filterPredicate = this.processPropertyFiler((PropertyFilter)filter);
                query.setFilter((Query.Filter)filterPredicate);
            } else {
                CompositeFilter compositeFilter = (CompositeFilter)filter;
                Query.CompositeFilter queryCompositeFilter = this.processCompositeFilter(compositeFilter);
                query.setFilter((Query.Filter)queryCompositeFilter);
            }
        }
        for (Map.Entry<String, SortDirection> sort : sorts.entrySet()) {
            Query.SortDirection querySortDirection = sort.getValue().equals((Object)SortDirection.ASCENDING) ? Query.SortDirection.ASCENDING : Query.SortDirection.DESCENDING;
            query.addSort(sort.getKey(), querySortDirection);
        }
        for (Projection projection : projections) {
            query.addProjection((com.google.appengine.api.datastore.Projection)new PropertyProjection(projection.getKey(), projection.getType()));
        }
        return this.get(query, currentPageNum, pageSize, pageCount);
    }

    private Query.CompositeFilter processCompositeFilter(CompositeFilter compositeFilter) throws RepositoryException {
        Query.CompositeFilter ret;
        ArrayList<Object> filters = new ArrayList<Object>();
        List subFilters = compositeFilter.getSubFilters();
        for (Filter subFilter : subFilters) {
            if (subFilter instanceof PropertyFilter) {
                Query.FilterPredicate filterPredicate = this.processPropertyFiler((PropertyFilter)subFilter);
                filters.add(filterPredicate);
                continue;
            }
            Query.CompositeFilter queryCompositeFilter = this.processCompositeFilter((CompositeFilter)subFilter);
            filters.add(queryCompositeFilter);
        }
        switch (compositeFilter.getOperator()) {
            case AND: {
                ret = new Query.CompositeFilter(Query.CompositeFilterOperator.AND, filters);
                break;
            }
            case OR: {
                ret = new Query.CompositeFilter(Query.CompositeFilterOperator.OR, filters);
                break;
            }
            default: {
                throw new RepositoryException("Unsupported composite filter[operator=" + compositeFilter.getOperator() + "]");
            }
        }
        return ret;
    }

    private Query.FilterPredicate processPropertyFiler(PropertyFilter propertyFilter) throws RepositoryException {
        Query.FilterPredicate ret;
        Query.FilterOperator filterOperator = null;
        switch (propertyFilter.getOperator()) {
            case EQUAL: {
                filterOperator = Query.FilterOperator.EQUAL;
                break;
            }
            case GREATER_THAN: {
                filterOperator = Query.FilterOperator.GREATER_THAN;
                break;
            }
            case GREATER_THAN_OR_EQUAL: {
                filterOperator = Query.FilterOperator.GREATER_THAN_OR_EQUAL;
                break;
            }
            case LESS_THAN: {
                filterOperator = Query.FilterOperator.LESS_THAN;
                break;
            }
            case LESS_THAN_OR_EQUAL: {
                filterOperator = Query.FilterOperator.LESS_THAN_OR_EQUAL;
                break;
            }
            case NOT_EQUAL: {
                filterOperator = Query.FilterOperator.NOT_EQUAL;
                break;
            }
            case IN: {
                filterOperator = Query.FilterOperator.IN;
                break;
            }
            default: {
                throw new RepositoryException("Unsupported filter operator[" + propertyFilter.getOperator() + "]");
            }
        }
        if (FilterOperator.IN != propertyFilter.getOperator()) {
            ret = new Query.FilterPredicate(propertyFilter.getKey(), filterOperator, propertyFilter.getValue());
        } else {
            HashSet values = new HashSet();
            StringBuilder logMsgBuilder = new StringBuilder();
            logMsgBuilder.append("In operation[");
            Collection inValues = (Collection)propertyFilter.getValue();
            for (Object inValue : inValues) {
                values.add(inValue);
                logMsgBuilder.append(inValue).append(",");
            }
            logMsgBuilder.deleteCharAt(logMsgBuilder.length() - 1);
            logMsgBuilder.append("]");
            LOGGER.log(Level.TRACE, logMsgBuilder.toString(), new Object[0]);
            ret = new Query.FilterPredicate(propertyFilter.getKey(), Query.FilterOperator.IN, values);
        }
        return ret;
    }

    public List<JSONObject> getRandomly(int fetchSize) throws RepositoryException {
        ArrayList<JSONObject> ret = new ArrayList<JSONObject>();
        com.google.appengine.api.datastore.Query query = new com.google.appengine.api.datastore.Query(this.getName());
        PreparedQuery preparedQuery = this.datastoreService.prepare(query);
        int count = (int)this.count();
        if (0 == count) {
            return ret;
        }
        Iterable entities = preparedQuery.asIterable();
        if (fetchSize >= count) {
            for (Entity entity : entities) {
                JSONObject jsonObject = GAERepository.entity2JSONObject(entity);
                ret.add(jsonObject);
            }
            return ret;
        }
        List fetchIndexes = CollectionUtils.getRandomIntegers((int)0, (int)(count - 1), (int)fetchSize);
        int index = 0;
        for (Entity entity : entities) {
            if (!fetchIndexes.contains(++index)) continue;
            JSONObject jsonObject = GAERepository.entity2JSONObject(entity);
            ret.add(jsonObject);
        }
        return ret;
    }

    public long count() {
        com.google.appengine.api.datastore.Query query = new com.google.appengine.api.datastore.Query(this.getName());
        PreparedQuery preparedQuery = this.datastoreService.prepare(query);
        return preparedQuery.countEntities(FetchOptions.Builder.withDefaults());
    }

    public long count(Query query) throws RepositoryException {
        Filter filter = query.getFilter();
        com.google.appengine.api.datastore.Query q = new com.google.appengine.api.datastore.Query(this.getName());
        if (null != filter) {
            if (filter instanceof PropertyFilter) {
                Query.FilterPredicate filterPredicate = this.processPropertyFiler((PropertyFilter)filter);
                q.setFilter((Query.Filter)filterPredicate);
            } else {
                CompositeFilter compositeFilter = (CompositeFilter)filter;
                Query.CompositeFilter queryCompositeFilter = this.processCompositeFilter(compositeFilter);
                q.setFilter((Query.Filter)queryCompositeFilter);
            }
        }
        PreparedQuery preparedQuery = this.datastoreService.prepare(q);
        return preparedQuery.countEntities(FetchOptions.Builder.withDefaults());
    }

    public static JSONObject entity2JSONObject(Entity entity) {
        Map properties = entity.getProperties();
        HashMap<String, String> jsonMap = new HashMap<String, String>();
        for (Map.Entry property : properties.entrySet()) {
            String k = (String)property.getKey();
            Object v = property.getValue();
            if (v instanceof Text) {
                Text valueText = (Text)v;
                jsonMap.put(k, valueText.getValue());
                continue;
            }
            if (v instanceof com.google.appengine.api.datastore.Blob) {
                com.google.appengine.api.datastore.Blob blob = (com.google.appengine.api.datastore.Blob)v;
                jsonMap.put(k, (String)new Blob(blob.getBytes()));
                continue;
            }
            jsonMap.put(k, (String)v);
        }
        return new JSONObject(jsonMap);
    }

    public static void setProperties(Entity entity, JSONObject jsonObject) throws JSONException {
        Iterator keys = jsonObject.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            Object value = jsonObject.get(key);
            if (!GAE_SUPPORTED_TYPES.contains(value.getClass()) && !(value instanceof Blob)) {
                throw new RuntimeException("Unsupported type[class=" + value.getClass().getName() + "] in Latke GAE repository");
            }
            if (value instanceof String) {
                String valueString = (String)value;
                if (valueString.length() > 500) {
                    Text text = new Text(valueString);
                    entity.setProperty(key, (Object)text);
                    continue;
                }
                entity.setProperty(key, value);
                continue;
            }
            if (value instanceof Number || value instanceof Date || value instanceof Boolean || GAE_SUPPORTED_TYPES.contains(value.getClass())) {
                entity.setProperty(key, value);
                continue;
            }
            if (!(value instanceof Blob)) continue;
            Blob blob = (Blob)value;
            entity.setProperty(key, (Object)new com.google.appengine.api.datastore.Blob(blob.getBytes()));
        }
    }

    private JSONObject get(com.google.appengine.api.datastore.Query query, int currentPageNum, int pageSize, int pageCount) throws RepositoryException {
        PreparedQuery preparedQuery = this.datastoreService.prepare(query);
        int pageCnt = pageCount;
        int recordCnt = 0;
        if (-1 == pageCnt) {
            long count = -1L;
            if (-1L == count) {
                count = preparedQuery.countEntities(FetchOptions.Builder.withDefaults());
                LOGGER.log(Level.WARN, "Invoked countEntities() for repository[name={0}, count={1}]", new Object[]{this.getName(), count});
            }
            recordCnt = (int)count;
            pageCnt = (int)Math.ceil((double)count / (double)pageSize);
        }
        JSONObject ret = new JSONObject();
        try {
            QueryResultList queryResultList;
            JSONObject pagination = new JSONObject();
            ret.put("pagination", (Object)pagination);
            pagination.put("paginationPageCount", pageCnt);
            pagination.put("paginationRecordCount", recordCnt);
            if (1 != currentPageNum) {
                Cursor startCursor = this.getStartCursor(currentPageNum, pageSize, preparedQuery);
                queryResultList = preparedQuery.asQueryResultList(FetchOptions.Builder.withStartCursor((Cursor)startCursor).limit(pageSize).chunkSize(50));
            } else {
                queryResultList = preparedQuery.asQueryResultList(FetchOptions.Builder.withLimit((int)pageSize).chunkSize(50));
            }
            JSONArray results = new JSONArray();
            ret.put("rslts", (Object)results);
            for (Entity entity : queryResultList) {
                JSONObject jsonObject = GAERepository.entity2JSONObject(entity);
                results.put((Object)jsonObject);
            }
            LOGGER.log(Level.DEBUG, "Found objects[size={0}] at page[currentPageNum={1}, pageSize={2}] in repository[{3}]", new Object[]{results.length(), currentPageNum, pageSize, this.getName()});
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, e.getMessage(), (Throwable)e);
            throw new RepositoryException((Throwable)e);
        }
        return ret;
    }

    public static String genTimeMillisId() {
        String timeMillisId = Ids.genTimeMillisId();
        LOGGER.log(Level.TRACE, "[timeMillisId={0}]", new Object[]{timeMillisId});
        return String.valueOf(Long.parseLong(timeMillisId));
    }

    public GAETransaction beginTransaction() {
        GAETransaction ret = TX.get();
        if (null != ret) {
            LOGGER.log(Level.DEBUG, "There is a transaction[isActive={0}] in current thread", new Object[]{ret.isActive()});
            if (ret.isActive()) {
                return TX.get();
            }
        }
        Transaction gaeTx = this.datastoreService.beginTransaction();
        ret = new GAETransaction(gaeTx);
        TX.set(ret);
        return ret;
    }

    public boolean hasTransactionBegun() {
        return null != TX.get();
    }

    public boolean isWritable() {
        return this.writable;
    }

    public void setWritable(boolean writable) {
        this.writable = writable;
    }

    public String getName() {
        return this.name;
    }

    private Cursor getStartCursor(int currentPageNum, int pageSize, PreparedQuery preparedQuery) {
        QueryResultList results;
        Cursor ret = null;
        int emptyCursorIndex = currentPageNum - 1;
        if (null == ret) {
            LOGGER.log(Level.INFO, "No query cursor at all", new Object[0]);
            results = preparedQuery.asQueryResultList(FetchOptions.Builder.withLimit((int)pageSize).chunkSize(50));
            ret = results.getCursor();
            emptyCursorIndex = 2;
        }
        while (emptyCursorIndex < currentPageNum) {
            results = preparedQuery.asQueryResultList(FetchOptions.Builder.withStartCursor(ret).limit(pageSize).chunkSize(50));
            ret = results.getCursor();
            ++emptyCursorIndex;
        }
        return ret;
    }
}

