/*
 * Decompiled with CFR 0.152.
 */
package org.weborganic.furi;

import java.util.Map;
import java.util.regex.Pattern;
import org.weborganic.furi.Matchable;
import org.weborganic.furi.Parameters;
import org.weborganic.furi.Token;
import org.weborganic.furi.TokenBase;
import org.weborganic.furi.URICoder;
import org.weborganic.furi.URITemplateSyntaxException;
import org.weborganic.furi.Variable;

public class TokenVariable
extends TokenBase
implements Token,
Matchable {
    private Variable _var;

    public TokenVariable(String exp) throws NullPointerException, URITemplateSyntaxException {
        this(Variable.parse(exp));
    }

    public TokenVariable(Variable var) throws NullPointerException {
        super('{' + var.toString() + "}");
        this._var = var;
    }

    public Variable getVariable() {
        return this._var;
    }

    @Override
    public String expand(Parameters variables) {
        return URICoder.encode(this._var.value(variables));
    }

    @Override
    public boolean match(String value) {
        return Variable.isValidValue(value);
    }

    @Override
    public Pattern pattern() {
        return Variable.VALID_VALUE;
    }

    @Override
    public boolean resolve(String expanded, Map<Variable, Object> values) {
        values.put(this._var, URICoder.decode(expanded));
        return true;
    }
}

