/*
 * Decompiled with CFR 0.152.
 */
package org.weborganic.furi;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.weborganic.furi.Token;
import org.weborganic.furi.URIPattern;
import org.weborganic.furi.URIResolveResult;
import org.weborganic.furi.URIResolver;
import org.weborganic.furi.URITemplate;
import org.weborganic.furi.URITemplateSyntaxException;

public final class Main {
    private Main() {
    }

    public static void main(String[] args) throws IOException {
        if (args.length == 2 && "-parse".equals(args[0])) {
            Main.main_parse(args[1]);
        } else if (args.length == 3 && "-resolve".equals(args[0])) {
            Main.main_resolve(args[1], args[2]);
        } else {
            Main.usage(null);
        }
    }

    public static void usage(String message) {
        if (message != null) {
            System.err.println(message);
        }
        System.err.println("URI Template");
        System.err.println("Usage: java " + Main.class.getName() + " [options]");
        System.err.println("where options include:");
        System.err.println("  -parse <template>      Parse the given URI template");
        System.err.println("  -resolve <file> <uri>  Resolve the given URI from the patterns in file");
    }

    private static void main_parse(String exp) throws IOException {
        try {
            URITemplate template = new URITemplate(exp);
            for (Token t : template.tokens()) {
                System.err.println(t.getClass().getSimpleName() + "\t" + t.expression());
            }
        }
        catch (URITemplateSyntaxException ex) {
            System.err.println("Not a valid URI template.");
        }
    }

    private static void main_resolve(String filename, String uri) throws IOException {
        File f = new File(filename);
        if (!f.exists()) {
            Main.usage("Could not find file " + f.getName());
            return;
        }
        List<URIPattern> patterns = Main.toPatterns(f);
        if (patterns.size() == 0) {
            Main.usage("No pattern in file " + f.getName());
            return;
        }
        URIResolver resolver = new URIResolver(uri);
        Collection<URIPattern> matches = resolver.findAll(patterns);
        if (matches.size() == 0) {
            System.err.println("No matching patterns for URI.");
        } else {
            System.out.println(matches.size() + " matching patterns for URI:");
            for (URIPattern p : matches) {
                boolean best = p == resolver.find(patterns, URIResolver.MatchRule.BEST_MATCH);
                boolean first = p == resolver.find(patterns, URIResolver.MatchRule.FIRST_MATCH);
                System.out.println(p + (best ? " [BEST]" : "") + (first ? " [FIRST]" : ""));
                URIResolveResult result = resolver.resolve(p);
                System.out.println("with");
                for (String name : result.names()) {
                    System.out.println("\t" + name + "=" + result.get(name));
                }
            }
        }
    }

    private static final List<URIPattern> toPatterns(File file) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        String line = null;
        ArrayList<URIPattern> patterns = new ArrayList<URIPattern>();
        while ((line = reader.readLine()) != null) {
            try {
                patterns.add(new URIPattern(line));
            }
            catch (URITemplateSyntaxException ex) {
                System.err.println("Could not parse '" + line + "' as pattern - ignored");
            }
        }
        reader.close();
        return patterns;
    }
}

