/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Strings {
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final int MAX_EMAIL_LENGTH_LOCAL = 64;
    private static final int MAX_EMAIL_LENGTH_DOMAIN = 255;
    private static final int MAX_EMAIL_LENGTH = 256;
    private static final Pattern EMAIL_PATTERN = Pattern.compile("^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$");

    private Strings() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> toLines(String string) throws IOException {
        if (null == string) {
            return null;
        }
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
        ArrayList<String> ret = new ArrayList<String>();
        try {
            String line = bufferedReader.readLine();
            while (null != line) {
                ret.add(line);
                line = bufferedReader.readLine();
            }
        }
        finally {
            bufferedReader.close();
        }
        return ret;
    }

    public static boolean isNumeric(String string) {
        if (Strings.isEmptyOrNull(string)) {
            return false;
        }
        Pattern pattern = Pattern.compile("[0-9]*");
        Matcher matcher = pattern.matcher(string);
        return matcher.matches();
    }

    public static boolean isEmail(String string) {
        if (Strings.isEmptyOrNull(string)) {
            return false;
        }
        if (256 < string.length()) {
            return false;
        }
        String[] parts = string.split("@");
        if (2 != parts.length) {
            return false;
        }
        String local = parts[0];
        if (64 < local.length()) {
            return false;
        }
        String domain = parts[1];
        if (255 < domain.length()) {
            return false;
        }
        return EMAIL_PATTERN.matcher(string).matches();
    }

    public static boolean isEmptyOrNull(String string) {
        return string == null || string.length() == 0;
    }

    public static String[] trimAll(String[] strings) {
        if (null == strings) {
            return null;
        }
        String[] ret = new String[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            ret[i] = strings[i].trim();
        }
        return ret;
    }

    public static boolean containsIgnoreCase(String string, String[] strings) {
        if (null == strings) {
            return false;
        }
        for (String str : strings) {
            if (null == str && null == string) {
                return true;
            }
            if (null == string || null == str || !string.equalsIgnoreCase(str)) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(String string, String[] strings) {
        if (null == strings) {
            return false;
        }
        for (String str : strings) {
            if (null == str && null == string) {
                return true;
            }
            if (null == string || null == str || !string.equals(str)) continue;
            return true;
        }
        return false;
    }

    public static boolean isURL(String string) {
        try {
            new URL(string);
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }
}

