/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.user;

import freemarker.log.Logger;
import org.b3log.latke.Latkes;
import org.b3log.latke.user.UserService;

public final class UserServiceFactory {
    private static final Logger LOGGER = Logger.getLogger((String)UserServiceFactory.class.getName());
    private static final UserService USER_SERVICE;

    public static UserService getUserService() {
        return USER_SERVICE;
    }

    private UserServiceFactory() {
    }

    static {
        LOGGER.info("Constructing User Service....");
        try {
            Class<?> serviceClass = null;
            switch (Latkes.getRuntime("userService")) {
                case GAE: {
                    serviceClass = Class.forName("org.b3log.latke.user.gae.GAEUserService");
                    USER_SERVICE = (UserService)serviceClass.newInstance();
                    break;
                }
                case LOCAL: {
                    serviceClass = Class.forName("org.b3log.latke.user.local.LocalUserService");
                    USER_SERVICE = (UserService)serviceClass.newInstance();
                    break;
                }
                default: {
                    throw new RuntimeException("Latke runs in the hell.... Please set the enviornment correctly");
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Can not initialize User Service!", e);
        }
        LOGGER.info("Constructed User Service");
    }
}

