/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.thread.local;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.thread.ThreadService;

public final class LocalThreadService
implements ThreadService {
    private static final Logger LOGGER = Logger.getLogger(LocalThreadService.class);
    private static final ExecutorService EXECUTOR_SERVICE = Executors.newFixedThreadPool(50);

    @Override
    public Thread createThreadForCurrentRequest(Runnable runnable) {
        return Executors.defaultThreadFactory().newThread(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<?> submit(Runnable runnable, long millseconds) {
        Object monitor = new Object();
        Worker worker = new Worker(runnable, millseconds, monitor);
        Object object = monitor;
        synchronized (object) {
            EXECUTOR_SERVICE.execute(worker);
            try {
                monitor.wait();
            }
            catch (Exception e) {
                LOGGER.log(Level.ERROR, "Wait failed", e);
            }
        }
        return worker.getFuture();
    }

    private static class Worker
    implements Runnable {
        private Future<?> future;
        private final Runnable runnable;
        private final long timeout;
        private Object monitor;

        public Worker(Runnable runnable, long timeout, Object monitor) {
            this.runnable = runnable;
            this.timeout = timeout;
            this.monitor = monitor;
        }

        public Future<?> getFuture() {
            return this.future;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = this.monitor;
            synchronized (object) {
                try {
                    this.future = EXECUTOR_SERVICE.submit(this.runnable);
                    this.future.get(this.timeout, TimeUnit.MILLISECONDS);
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARN, "Task executes failed", e);
                    this.future = null;
                }
                this.monitor.notify();
            }
        }
    }
}

