/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.taskqueue;

import org.b3log.latke.Latkes;
import org.b3log.latke.RuntimeEnv;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.taskqueue.TaskQueueService;

public final class TaskQueueServiceFactory {
    private static final Logger LOGGER = Logger.getLogger(TaskQueueServiceFactory.class.getName());
    private static final TaskQueueService TASK_QUEUE_SERVICE;

    public static TaskQueueService getTaskQueueService() {
        return TASK_QUEUE_SERVICE;
    }

    private TaskQueueServiceFactory() {
    }

    static {
        LOGGER.info("Constructing Task Query Service....");
        RuntimeEnv runtimeEnv = Latkes.getRuntimeEnv();
        try {
            Class<?> serviceClass = null;
            switch (runtimeEnv) {
                case LOCAL: {
                    serviceClass = Class.forName("org.b3log.latke.taskqueue.local.LocalTaskQueueService");
                    TASK_QUEUE_SERVICE = (TaskQueueService)serviceClass.newInstance();
                    break;
                }
                case GAE: {
                    serviceClass = Class.forName("org.b3log.latke.taskqueue.gae.GAETaskQueueService");
                    TASK_QUEUE_SERVICE = (TaskQueueService)serviceClass.newInstance();
                    break;
                }
                default: {
                    throw new RuntimeException("Latke runs in the hell.... Please set the enviornment correctly");
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Can not initialize Task Queue Service!", e);
        }
        LOGGER.info("Constructed Task Query Service");
    }
}

