/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.servlet.renderer.freemarker;

import freemarker.template.Template;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.time.DateFormatUtils;
import org.b3log.latke.Keys;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.servlet.HTTPRequestContext;
import org.b3log.latke.servlet.renderer.AbstractHTTPResponseRenderer;
import org.b3log.latke.util.freemarker.Templates;

public abstract class AbstractFreeMarkerRenderer
extends AbstractHTTPResponseRenderer {
    private static final Logger LOGGER = Logger.getLogger(AbstractFreeMarkerRenderer.class.getName());
    private String templateName;
    private Map<String, Object> dataModel = new HashMap<String, Object>();

    protected Template getTemplate(String templateDirName, String templateName) {
        return Templates.getTemplate(templateDirName, templateName);
    }

    protected abstract void beforeRender(HTTPRequestContext var1) throws Exception;

    protected abstract void afterRender(HTTPRequestContext var1) throws Exception;

    @Override
    public void render(HTTPRequestContext context) {
        PrintWriter writer;
        HttpServletResponse response = context.getResponse();
        response.setContentType("text/html");
        response.setCharacterEncoding("UTF-8");
        try {
            writer = response.getWriter();
        }
        catch (Exception e) {
            try {
                writer = new PrintWriter((OutputStream)response.getOutputStream());
            }
            catch (IOException ex) {
                LOGGER.log(Level.ERROR, "Can not get response writer", ex);
                return;
            }
        }
        if (response.isCommitted()) {
            writer.flush();
            writer.close();
            return;
        }
        HttpServletRequest request = context.getRequest();
        Template template = this.getTemplate((String)request.getAttribute("templateDirName"), this.templateName);
        if (null == template) {
            LOGGER.log(Level.ERROR, "Not found template[{0}]", this.templateName);
            try {
                response.sendError(404);
            }
            catch (IOException ex) {
                LOGGER.log(Level.ERROR, "Can not send error 404!", ex);
            }
            return;
        }
        try {
            this.dataModel.put("request", request);
            Keys.fillServer(this.dataModel);
            this.beforeRender(context);
            String html = this.genHTML(context.getRequest(), this.dataModel, template);
            long time = System.currentTimeMillis();
            String year = DateFormatUtils.format((long)time, (String)"yyyy");
            String copyright = "<div style='display: none;'>Copyright (c) 2009-" + year + ", <a href='http://b3log.org'>b3log.org</a></div>\n    ";
            html = html.replace("</body>", copyright + "</body>");
            this.doRender(html, context.getRequest(), response);
            this.afterRender(context);
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "FreeMarker renders error", e);
            try {
                response.sendError(500);
            }
            catch (IOException ex) {
                LOGGER.log(Level.ERROR, "Can not send error 500!", ex);
            }
        }
    }

    protected String genHTML(HttpServletRequest request, Map<String, Object> dataModel, Template template) throws Exception {
        StringWriter stringWriter = new StringWriter();
        template.setOutputEncoding("UTF-8");
        template.process(dataModel, (Writer)stringWriter);
        StringBuilder pageContentBuilder = new StringBuilder(stringWriter.toString());
        long endimeMillis = System.currentTimeMillis();
        String dateString = DateFormatUtils.format((long)endimeMillis, (String)"yyyy/MM/dd HH:mm:ss");
        long startTimeMillis = (Long)request.getAttribute("startTimeMillis");
        String msg = String.format("<!-- Generated by B3log Latke(%1$d ms), %2$s -->", endimeMillis - startTimeMillis, dateString);
        pageContentBuilder.append(msg);
        return pageContentBuilder.toString();
    }

    protected void doRender(String html, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PrintWriter writer;
        try {
            writer = response.getWriter();
        }
        catch (Exception e) {
            writer = new PrintWriter((OutputStream)response.getOutputStream());
        }
        if (response.isCommitted()) {
            writer.flush();
            writer.close();
            return;
        }
        writer.write(html);
        writer.flush();
        writer.close();
    }

    public Map<String, Object> getDataModel() {
        return this.dataModel;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    @Override
    public Map<String, Object> getRenderDataModel() {
        return this.dataModel;
    }
}

