/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.servlet.handler;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.b3log.latke.Latkes;
import org.b3log.latke.ioc.LatkeBeanManager;
import org.b3log.latke.ioc.Lifecycle;
import org.b3log.latke.ioc.bean.LatkeBean;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.servlet.HTTPRequestContext;
import org.b3log.latke.servlet.HTTPRequestMethod;
import org.b3log.latke.servlet.HttpControl;
import org.b3log.latke.servlet.annotation.RequestProcessing;
import org.b3log.latke.servlet.annotation.RequestProcessor;
import org.b3log.latke.servlet.handler.Handler;
import org.b3log.latke.servlet.handler.MatchResult;
import org.b3log.latke.servlet.handler.ProcessorInfo;
import org.b3log.latke.util.AntPathMatcher;
import org.b3log.latke.util.DefaultMatcher;
import org.b3log.latke.util.RegexPathMatcher;
import org.b3log.latke.util.Strings;
import org.weborganic.furi.URIResolveResult;

public class RequestDispatchHandler
implements Handler {
    private static final Logger LOGGER = Logger.getLogger(RequestDispatchHandler.class.getName());
    public static final String MATCH_RESULT = "MATCH_RESULT";
    private final List<ProcessorInfo> processorInfos = new ArrayList<ProcessorInfo>();

    public RequestDispatchHandler() {
        LatkeBeanManager beanManager = Lifecycle.getBeanManager();
        Set<LatkeBean<?>> processBeans = beanManager.getBeans(RequestProcessor.class);
        this.genInfo(processBeans);
    }

    @Override
    public void handle(HTTPRequestContext context, HttpControl httpControl) throws Exception {
        HttpServletRequest request = context.getRequest();
        String requestURI = this.getRequestURI(request);
        String httpMethod = this.getHTTPMethod(request);
        LOGGER.log(Level.DEBUG, "Request[requestURI={0}, method={1}]", requestURI, httpMethod);
        MatchResult result = this.doMatch(requestURI, httpMethod);
        if (result != null) {
            httpControl.data(MATCH_RESULT, result);
            httpControl.nextHandler();
        }
    }

    private MatchResult doMatch(String requestURI, String httpMethod) {
        MatchResult ret = null;
        String contextPath = Latkes.getContextPath();
        for (ProcessorInfo processorInfo : this.processorInfos) {
            for (HTTPRequestMethod httpRequestMethod : processorInfo.getHttpMethod()) {
                String[] uriPatterns;
                if (!httpMethod.equals(httpRequestMethod.toString())) continue;
                for (String uriPattern : uriPatterns = processorInfo.getPattern()) {
                    ret = this.getResult(contextPath + uriPattern, processorInfo, requestURI, httpMethod);
                    if (null == ret) continue;
                    return ret;
                }
            }
        }
        return ret;
    }

    private MatchResult getResult(String uriPattern, ProcessorInfo processorInfo, String requestURI, String method) {
        if (requestURI.equals(uriPattern)) {
            return new MatchResult(processorInfo, requestURI, method, uriPattern);
        }
        switch (processorInfo.getUriPatternMode()) {
            case REGEX: {
                if (!RegexPathMatcher.match(uriPattern, requestURI)) break;
                return new MatchResult(processorInfo, requestURI, method, uriPattern);
            }
            case ANT_PATH: {
                if (AntPathMatcher.match(uriPattern, requestURI)) {
                    return new MatchResult(processorInfo, requestURI, method, uriPattern);
                }
                URIResolveResult result = DefaultMatcher.match(uriPattern, requestURI);
                if (URIResolveResult.Status.RESOLVED != result.getStatus()) break;
                MatchResult ret = new MatchResult(processorInfo, requestURI, method, uriPattern);
                HashMap<String, Object> map = new HashMap<String, Object>();
                for (String s : result.names()) {
                    map.put(s, result.get(s));
                }
                ret.setMapValues(map);
                return ret;
            }
            default: {
                throw new IllegalStateException("Can not process URI pattern[uriPattern=" + uriPattern + ", mode=" + (Object)((Object)processorInfo.getUriPatternMode()) + "]");
            }
        }
        return null;
    }

    private String getHTTPMethod(HttpServletRequest request) {
        String ret = (String)request.getAttribute("requestMethod");
        if (Strings.isEmptyOrNull(ret)) {
            ret = request.getMethod();
        }
        return ret;
    }

    private String getRequestURI(HttpServletRequest request) {
        String ret = (String)request.getAttribute("requestURI");
        if (Strings.isEmptyOrNull(ret)) {
            ret = request.getRequestURI();
        }
        return ret;
    }

    private void genInfo(Set<LatkeBean<?>> processBeans) {
        for (LatkeBean<?> latkeBean : processBeans) {
            Class clz = latkeBean.getBeanClass();
            Method[] declaredMethods = clz.getDeclaredMethods();
            for (int i = 0; i < declaredMethods.length; ++i) {
                Method mthd = declaredMethods[i];
                RequestProcessing requestProcessingMethodAnn = mthd.getAnnotation(RequestProcessing.class);
                if (null == requestProcessingMethodAnn) continue;
                LOGGER.log(Level.DEBUG, "Added a processor method[className={0}], method[{1}]", clz.getCanonicalName(), mthd.getName());
                this.addProcessorInfo(requestProcessingMethodAnn, mthd);
            }
        }
    }

    private void addProcessorInfo(RequestProcessing requestProcessingMethodAnn, Method mthd) {
        ProcessorInfo processorInfo = new ProcessorInfo();
        processorInfo.setPattern(requestProcessingMethodAnn.value());
        processorInfo.setUriPatternMode(requestProcessingMethodAnn.uriPatternsMode());
        processorInfo.setHttpMethod(requestProcessingMethodAnn.method());
        processorInfo.setConvertClass(requestProcessingMethodAnn.convertClass());
        processorInfo.setInvokeHolder(mthd);
        this.processorInfos.add(processorInfo);
    }
}

