/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.repository.jdbc.util;

import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.repository.Repositories;
import org.b3log.latke.repository.RepositoryException;
import org.b3log.latke.repository.jdbc.JdbcFactory;
import org.b3log.latke.repository.jdbc.util.Connections;
import org.b3log.latke.repository.jdbc.util.FieldDefinition;
import org.b3log.latke.util.Strings;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class JdbcRepositories {
    private static final Logger LOGGER = Logger.getLogger(JdbcRepositories.class.getName());
    private static final String REPOSITORIES = "repositories";
    private static final String NAME = "name";
    private static final String KEYS = "keys";
    private static final String TYPE = "type";
    private static final String NULLABLE = "nullable";
    private static final String LENGTH = "length";
    private static final String ISKEY = "iskey";
    private static String defaultKeyName = "oId";
    private static Map<String, List<FieldDefinition>> repositoriesMap = null;

    public static void setDefaultKeyName(String keyName) {
        defaultKeyName = keyName;
    }

    public static String getDefaultKeyName() {
        return defaultKeyName;
    }

    public static Map<String, List<FieldDefinition>> getRepositoriesMap() {
        if (repositoriesMap == null) {
            try {
                JdbcRepositories.initRepositoriesMap();
            }
            catch (Exception e) {
                LOGGER.log(Level.ERROR, "initRepositoriesMap mistake " + e.getMessage(), e);
            }
        }
        return repositoriesMap;
    }

    private static void initRepositoriesMap() throws JSONException, RepositoryException {
        JSONObject jsonObject = Repositories.getRepositoriesDescription();
        if (jsonObject == null) {
            LOGGER.warn("the repository description[repository.json] miss");
            return;
        }
        JdbcRepositories.jsonToRepositoriesMap(jsonObject);
    }

    private static void jsonToRepositoriesMap(JSONObject jsonObject) throws JSONException {
        repositoriesMap = new HashMap<String, List<FieldDefinition>>();
        JSONArray repositoritArray = jsonObject.getJSONArray(REPOSITORIES);
        for (int i = 0; i < repositoritArray.length(); ++i) {
            JSONObject repositoryObject = repositoritArray.getJSONObject(i);
            String repositoryName = repositoryObject.getString(NAME);
            ArrayList<FieldDefinition> fieldDefinitions = new ArrayList<FieldDefinition>();
            repositoriesMap.put(repositoryName, fieldDefinitions);
            JSONArray keysJsonArray = repositoryObject.getJSONArray(KEYS);
            for (int j = 0; j < keysJsonArray.length(); ++j) {
                JSONObject fieldDefinitionObject = keysJsonArray.getJSONObject(j);
                FieldDefinition definition = JdbcRepositories.fillFieldDefinitionData(fieldDefinitionObject);
                fieldDefinitions.add(definition);
            }
        }
    }

    private static FieldDefinition fillFieldDefinitionData(JSONObject fieldDefinitionObject) throws JSONException {
        FieldDefinition fieldDefinition = new FieldDefinition();
        fieldDefinition.setName(fieldDefinitionObject.getString(NAME));
        fieldDefinition.setType(fieldDefinitionObject.getString(TYPE));
        fieldDefinition.setNullable(fieldDefinitionObject.optBoolean(NULLABLE));
        fieldDefinition.setLength(fieldDefinitionObject.optInt(LENGTH));
        fieldDefinition.setIsKey(fieldDefinitionObject.optBoolean(ISKEY));
        if (defaultKeyName.equals(fieldDefinition.getName())) {
            fieldDefinition.setIsKey(true);
        }
        return fieldDefinition;
    }

    public static List<CreateTableResult> initAllTables() {
        ArrayList<CreateTableResult> ret = new ArrayList<CreateTableResult>();
        Map<String, List<FieldDefinition>> map = JdbcRepositories.getRepositoriesMap();
        boolean isSuccess = false;
        for (String tableName : map.keySet()) {
            try {
                isSuccess = JdbcFactory.createJdbcFactory().createTable(tableName, map.get(tableName));
            }
            catch (SQLException e) {
                LOGGER.log(Level.ERROR, "createTable[" + tableName + "] error", e);
            }
            ret.add(new CreateTableResult(tableName, isSuccess));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initRepositoryJSON(Set<String> tableNames, String destPath) {
        FileWriter writer = null;
        try {
            Connection connection = Connections.getConnection();
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            ResultSet resultSet = databaseMetaData.getTables(null, "%", "%", new String[]{"TABLE"});
            JSONObject repositoryJSON = new JSONObject();
            JSONArray repositories = new JSONArray();
            repositoryJSON.put(REPOSITORIES, repositories);
            while (resultSet.next()) {
                String tableName = resultSet.getString("TABLE_NAME");
                if (!tableNames.contains(tableName)) continue;
                JSONObject repository = new JSONObject();
                repositories.put(repository);
                repository.put(NAME, tableName);
                JSONArray keys = new JSONArray();
                repository.put(KEYS, keys);
                ResultSet rs = databaseMetaData.getColumns(null, "%", tableName, "%");
                while (rs.next()) {
                    String columnName = rs.getString("COLUMN_NAME");
                    String remarks = rs.getString("REMARKS");
                    int dataType = rs.getInt("DATA_TYPE");
                    int length = rs.getInt("COLUMN_SIZE");
                    int nullable = rs.getInt("NULLABLE");
                    JSONObject key = new JSONObject();
                    keys.put(key);
                    key.put(NAME, columnName);
                    if (!Strings.isEmptyOrNull(remarks)) {
                        key.put("description", remarks);
                    }
                    key.put(NULLABLE, 0 != nullable);
                    switch (dataType) {
                        case -16: 
                        case -15: 
                        case -9: 
                        case -1: 
                        case 1: 
                        case 12: {
                            key.put(TYPE, "String");
                            break;
                        }
                        case -6: 
                        case -5: 
                        case 4: 
                        case 5: {
                            key.put(TYPE, "int");
                            break;
                        }
                        case 91: {
                            key.put(TYPE, "Date");
                            break;
                        }
                        case 92: 
                        case 93: {
                            key.put(TYPE, "Datetime");
                            break;
                        }
                        case 2: 
                        case 3: {
                            key.put(TYPE, "Decimal");
                            key.put("precision", rs.getInt("DECIMAL_DIGITS"));
                            break;
                        }
                        case -7: {
                            key.put(TYPE, "Bit");
                            break;
                        }
                        case 2005: {
                            key.put(TYPE, "Clob");
                            break;
                        }
                        case 2004: {
                            key.put(TYPE, "Blob");
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unsupported type [" + dataType + ']');
                        }
                    }
                    key.put(LENGTH, length);
                }
            }
            File file = new File(destPath);
            FileUtils.deleteQuietly((File)file);
            writer = new FileWriter(file);
            String content = repositoryJSON.toString(Integer.valueOf("4"));
            IOUtils.write((String)content, (Writer)writer);
            IOUtils.closeQuietly((Writer)writer);
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Init repository.json failed", e);
        }
        finally {
            IOUtils.closeQuietly(writer);
        }
    }

    public static void setRepositoriesMap(Map<String, List<FieldDefinition>> repositoriesMap) {
        JdbcRepositories.repositoriesMap = repositoriesMap;
    }

    private JdbcRepositories() {
    }

    public static class CreateTableResult {
        private String name;
        private boolean isSuccess;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean isSuccess() {
            return this.isSuccess;
        }

        public void setSuccess(boolean isSuccess) {
            this.isSuccess = isSuccess;
        }

        public CreateTableResult(String name, boolean isSuccess) {
            this.name = name;
            this.isSuccess = isSuccess;
        }
    }
}

