/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.repository.jdbc.util;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.pool.DruidPooledConnection;
import com.jolbox.bonecp.BoneCP;
import com.jolbox.bonecp.BoneCPConfig;
import com.mchange.v2.c3p0.ComboPooledDataSource;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.b3log.latke.Latkes;
import org.b3log.latke.RuntimeDatabase;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.util.Callstacks;
import org.h2.jdbcx.JdbcConnectionPool;

public final class Connections {
    private static final Logger LOGGER = Logger.getLogger(Connections.class.getName());
    private static String poolType;
    private static final long CONN_TIMEOUT = 5000L;
    private static BoneCP boneCP;
    private static ComboPooledDataSource c3p0;
    private static final int C3P0_CHECKTIME = 60;
    private static JdbcConnectionPool h2;
    private static DruidDataSource druid;
    private static String transactionIsolation;
    private static int transactionIsolationInt;
    private static String url;
    private static String userName;
    private static String password;

    public static Connection getConnection() throws SQLException {
        if (LOGGER.isTraceEnabled()) {
            Callstacks.printCallstack(Level.TRACE, new String[]{"org.b3log"}, null);
        }
        if ("BoneCP".equals(poolType)) {
            LOGGER.log(Level.TRACE, "Connection pool[createdConns={0}, freeConns={1}, leasedConns={2}]", boneCP.getTotalCreatedConnections(), boneCP.getTotalFree(), boneCP.getTotalLeased());
            return boneCP.getConnection();
        }
        if ("c3p0".equals(poolType)) {
            LOGGER.log(Level.TRACE, "Connection pool[createdConns={0}, freeConns={1}, leasedConns={2}]", c3p0.getNumConnections(), c3p0.getNumIdleConnections(), c3p0.getNumBusyConnections());
            Connection ret = c3p0.getConnection();
            ret.setTransactionIsolation(transactionIsolationInt);
            ret.setAutoCommit(false);
            return ret;
        }
        if ("h2".equals(poolType)) {
            LOGGER.log(Level.TRACE, "Connection pool[leasedConns={0}]", h2.getActiveConnections());
            Connection ret = h2.getConnection();
            ret.setTransactionIsolation(transactionIsolationInt);
            ret.setAutoCommit(false);
            return ret;
        }
        if ("druid".equals(poolType)) {
            LOGGER.log(Level.TRACE, "Connection pool[leasedConns={0}]", druid.getActiveConnections());
            DruidPooledConnection ret = druid.getConnection();
            ret.setTransactionIsolation(transactionIsolationInt);
            ret.setAutoCommit(false);
            return ret;
        }
        if ("none".equals(poolType)) {
            Connection ret = DriverManager.getConnection(url, userName, password);
            ret.setTransactionIsolation(transactionIsolationInt);
            ret.setAutoCommit(false);
            return ret;
        }
        if (RuntimeDatabase.NONE == Latkes.getRuntimeDatabase()) {
            return null;
        }
        throw new IllegalStateException("Not found database connection pool [" + poolType + "]");
    }

    public static void shutdownConnectionPool() {
        if (null != boneCP) {
            boneCP.shutdown();
            LOGGER.info("Closed [BoneCP] database connection pool");
        }
        if (null != h2) {
            h2.dispose();
            LOGGER.info("Closed [H2] database connection pool");
        }
        if (null != c3p0) {
            c3p0.close();
            LOGGER.info("Closed [c3p0] database connection pool");
        }
        if (null != druid) {
            druid.close();
            LOGGER.info("Closed [druid] database connection pool");
        }
    }

    private Connections() {
    }

    static {
        try {
            if (RuntimeDatabase.NONE != Latkes.getRuntimeDatabase()) {
                String driver = Latkes.getLocalProperty("jdbc.driver");
                Class.forName(driver);
                poolType = Latkes.getLocalProperty("jdbc.pool");
                url = Latkes.getLocalProperty("jdbc.URL");
                userName = Latkes.getLocalProperty("jdbc.username");
                password = Latkes.getLocalProperty("jdbc.password");
                int minConnCnt = Integer.valueOf(Latkes.getLocalProperty("jdbc.minConnCnt"));
                int maxConnCnt = Integer.valueOf(Latkes.getLocalProperty("jdbc.maxConnCnt"));
                transactionIsolation = Latkes.getLocalProperty("jdbc.transactionIsolation");
                if ("NONE".equals(transactionIsolation)) {
                    transactionIsolationInt = 0;
                } else if ("READ_COMMITTED".equals(transactionIsolation)) {
                    transactionIsolationInt = 2;
                } else if ("READ_UNCOMMITTED".equals(transactionIsolation)) {
                    transactionIsolationInt = 1;
                } else if ("REPEATABLE_READ".equals(transactionIsolation)) {
                    transactionIsolationInt = 4;
                } else if ("SERIALIZABLE".equals(transactionIsolation)) {
                    transactionIsolationInt = 8;
                } else {
                    throw new IllegalStateException("Undefined transaction isolation [" + transactionIsolation + ']');
                }
                if ("BoneCP".equals(poolType)) {
                    LOGGER.log(Level.DEBUG, "Initializing database connection pool [BoneCP]", new Object[0]);
                    BoneCPConfig config = new BoneCPConfig();
                    config.setDefaultAutoCommit(false);
                    config.setDefaultTransactionIsolation(transactionIsolation);
                    config.setJdbcUrl(url);
                    config.setUsername(userName);
                    config.setPassword(password);
                    config.setMinConnectionsPerPartition(minConnCnt);
                    config.setMaxConnectionsPerPartition(maxConnCnt);
                    config.setPartitionCount(1);
                    config.setDisableJMX(true);
                    config.setConnectionTimeoutInMs(5000L);
                    boneCP = new BoneCP(config);
                } else if ("c3p0".equals(poolType)) {
                    LOGGER.log(Level.DEBUG, "Initializing database connection pool [c3p0]", new Object[0]);
                    System.setProperty("com.mchange.v2.c3p0.management.ManagementCoordinator", "com.mchange.v2.c3p0.management.NullManagementCoordinator");
                    c3p0 = new ComboPooledDataSource();
                    c3p0.setUser(userName);
                    c3p0.setPassword(password);
                    c3p0.setJdbcUrl(url);
                    c3p0.setDriverClass(driver);
                    c3p0.setInitialPoolSize(minConnCnt);
                    c3p0.setMinPoolSize(minConnCnt);
                    c3p0.setMaxPoolSize(maxConnCnt);
                    c3p0.setMaxStatementsPerConnection(maxConnCnt);
                    c3p0.setTestConnectionOnCheckin(true);
                    c3p0.setCheckoutTimeout(maxConnCnt);
                    c3p0.setIdleConnectionTestPeriod(60);
                    c3p0.setCheckoutTimeout(5000);
                } else if ("h2".equals(poolType)) {
                    LOGGER.log(Level.DEBUG, "Initialing database connection pool [h2]", new Object[0]);
                    h2 = JdbcConnectionPool.create((String)url, (String)userName, (String)password);
                    h2.setMaxConnections(maxConnCnt);
                } else if ("druid".equals(poolType)) {
                    LOGGER.log(Level.DEBUG, "Initialing database connection pool [druid]", new Object[0]);
                    druid = new DruidDataSource();
                    druid.setUsername(userName);
                    druid.setPassword(password);
                    druid.setUrl(url);
                    druid.setDriverClassName(driver);
                    druid.setInitialSize(minConnCnt);
                    druid.setMinIdle(minConnCnt);
                    druid.setMaxActive(maxConnCnt);
                    druid.setTestOnReturn(true);
                    druid.setValidationQuery("SELECT 1");
                } else if ("none".equals(poolType)) {
                    LOGGER.info("Do not use database connection pool");
                }
                LOGGER.info("Initialized connection pool [type=" + poolType + ']');
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Can not initialize database connection", e);
        }
    }
}

