/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.repository.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import org.b3log.latke.repository.Transaction;
import org.b3log.latke.repository.jdbc.JdbcRepository;
import org.b3log.latke.repository.jdbc.util.Connections;

public final class JdbcTransaction
implements Transaction {
    private Connection connection = Connections.getConnection();
    private boolean isActive;

    public JdbcTransaction() throws SQLException {
        this.connection.setAutoCommit(false);
        this.isActive = true;
    }

    @Override
    public String getId() {
        return null;
    }

    @Override
    public void commit() {
        boolean ifSuccess = false;
        try {
            this.connection.commit();
            ifSuccess = true;
        }
        catch (SQLException e) {
            throw new RuntimeException("commit mistake", e);
        }
        if (ifSuccess) {
            this.dispose();
        }
    }

    @Override
    public void rollback() {
        try {
            this.connection.rollback();
        }
        catch (SQLException e) {
            throw new RuntimeException("rollback mistake", e);
        }
        finally {
            this.dispose();
        }
    }

    public void setActive(boolean isActive) {
        this.isActive = isActive;
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    public void dispose() {
        try {
            this.connection.close();
            JdbcRepository.TX.set(null);
        }
        catch (SQLException e) {
            throw new RuntimeException("close connection", e);
        }
        finally {
            this.isActive = false;
            this.connection = null;
        }
    }

    public Connection getConnection() {
        return this.connection;
    }
}

