/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.repository.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.b3log.latke.repository.jdbc.JdbcDatabase;
import org.b3log.latke.repository.jdbc.mapping.Mapping;
import org.b3log.latke.repository.jdbc.util.Connections;
import org.b3log.latke.repository.jdbc.util.FieldDefinition;
import org.b3log.latke.repository.jdbc.util.JdbcUtil;

public abstract class AbstractJdbcDatabaseSolution
implements JdbcDatabase {
    private Map<String, Mapping> jdbcTypeMapping = new HashMap<String, Mapping>();

    public void registerType(String type, Mapping mapping) {
        this.jdbcTypeMapping.put(type, mapping);
    }

    @Override
    public boolean createTable(String tableName, List<FieldDefinition> fieldDefinitions) throws SQLException {
        Connection connection = Connections.getConnection();
        try {
            StringBuilder createTableSql = new StringBuilder();
            this.createTableHead(createTableSql, tableName);
            this.createTableBody(createTableSql, fieldDefinitions);
            this.createTableEnd(createTableSql);
            boolean bl = JdbcUtil.executeSql(createTableSql.toString(), connection);
            return bl;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            connection.close();
        }
    }

    protected abstract void createDropTableSql(StringBuilder var1, String var2);

    protected abstract void createTableHead(StringBuilder var1, String var2);

    protected abstract void createTableBody(StringBuilder var1, List<FieldDefinition> var2);

    protected abstract void createTableEnd(StringBuilder var1);

    @Override
    public boolean clearTable(String tableName, boolean ifdrop) throws SQLException {
        Connection connection = Connections.getConnection();
        try {
            StringBuilder clearTableSql = new StringBuilder();
            this.clearTableSql(clearTableSql, tableName, ifdrop);
            boolean bl = JdbcUtil.executeSql(clearTableSql.toString(), connection);
            return bl;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            connection.close();
        }
    }

    public abstract void clearTableSql(StringBuilder var1, String var2, boolean var3);

    public Map<String, Mapping> getJdbcTypeMapping() {
        return this.jdbcTypeMapping;
    }
}

